# This program gets employee data from the user and
# saves it as records in the employee.txt file.

def main():
    # Get the number of employee records to create.
    num_emps = int(input('How many employee records ' +
                         'do you want to create? '))

    # Open the file for writing.
    with open('employees.txt', 'w') as emp_file:
        # Get each employee's data and write it to the file.
        for count in range(1, num_emps + 1):
            # Get the data for an employee.
            print(f'Enter data for employee #{count}')
            name = input('Name: ')
            id_num = input('ID number: ')
            dept = input('Department: ')

            # Write the data as a record to the file.
            emp_file.write(f'{name}\n')
            emp_file.write(f'{id_num}\n')
            emp_file.write(f'{dept}\n')

            # Display a blank line.
            print()

    print('Employee records written to employees.txt.')

# Call the main function.
if __name__ == '__main__':
    main()