/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.FastVector;
import weka.core.Instances;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.PlotData2D;

public class LegendPanel
extends JScrollPane {
    protected FastVector m_plots;
    protected JPanel m_span = null;
    protected FastVector m_Repainters = new FastVector();

    public LegendPanel() {
        this.setBackground(Color.blue);
        this.setVerticalScrollBarPolicy(22);
    }

    public void setPlotList(FastVector fastVector) {
        this.m_plots = fastVector;
        this.updateLegends();
    }

    public void addRepaintNotify(Component component) {
        this.m_Repainters.addElement(component);
    }

    private void updateLegends() {
        if (this.m_span == null) {
            this.m_span = new JPanel();
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.m_span.setPreferredSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_plots.size() + 1) * 20));
        this.m_span.setMaximumSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_plots.size() + 1) * 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_span.removeAll();
        jPanel.setLayout(gridBagLayout);
        this.m_span.setLayout(gridBagLayout2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.m_span, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 5.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.setViewportView(jPanel);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 5.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        int n = 0;
        while (n < this.m_plots.size()) {
            LegendEntry legendEntry = new LegendEntry((PlotData2D)this.m_plots.elementAt(n), n);
            gridBagConstraints.gridy = n++;
            this.m_span.add((Component)legendEntry, gridBagConstraints);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage : weka.gui.visualize.LegendPanel <dataset> [dataset2], [dataset3],...");
                System.exit(1);
            }
            final JFrame jFrame = new JFrame("Weka Explorer: Legend");
            jFrame.setSize(100, 100);
            jFrame.getContentPane().setLayout(new BorderLayout());
            LegendPanel legendPanel = new LegendPanel();
            jFrame.getContentPane().add((Component)legendPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            FastVector fastVector = new FastVector();
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("Loading instances from " + stringArray[i]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[i]));
                Instances instances = new Instances(bufferedReader);
                PlotData2D plotData2D = new PlotData2D(instances);
                if (i != 1) {
                    plotData2D.m_useCustomColour = true;
                    plotData2D.m_customColour = Color.red;
                }
                plotData2D.setPlotName(instances.relationName());
                fastVector.addElement(plotData2D);
            }
            legendPanel.setPlotList(fastVector);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected class LegendEntry
    extends JPanel {
        private PlotData2D m_plotData = null;
        private int m_dataIndex;
        private JLabel m_legendText;
        private JPanel m_pointShape;

        public LegendEntry(PlotData2D plotData2D, int n) {
            this.m_plotData = plotData2D;
            this.m_dataIndex = n;
            if (this.m_plotData.m_useCustomColour) {
                this.addMouseListener(new MouseAdapter(this){
                    private final /* synthetic */ LegendEntry this$1;
                    {
                        this.this$1 = legendEntry;
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        Color color;
                        if ((mouseEvent.getModifiers() & 0x10) == 16 && (color = JColorChooser.showDialog(LegendEntry.access$000(this.this$1), "Select new Color", LegendEntry.access$100((LegendEntry)this.this$1).m_customColour)) != null) {
                            LegendEntry.access$100((LegendEntry)this.this$1).m_customColour = color;
                            LegendEntry.access$200(this.this$1).setForeground(color);
                            if (LegendEntry.access$000((LegendEntry)this.this$1).m_Repainters.size() > 0) {
                                for (int i = 0; i < LegendEntry.access$000((LegendEntry)this.this$1).m_Repainters.size(); ++i) {
                                    ((Component)LegendEntry.access$000((LegendEntry)this.this$1).m_Repainters.elementAt(i)).repaint();
                                }
                            }
                            LegendEntry.access$000(this.this$1).repaint();
                        }
                    }
                });
            }
            this.m_legendText = new JLabel(this.m_plotData.m_plotName);
            if (this.m_plotData.m_useCustomColour) {
                this.m_legendText.setForeground(this.m_plotData.m_customColour);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_legendText, "Center");
            this.m_pointShape = new JPanel(this){
                private final /* synthetic */ LegendEntry this$1;
                {
                    this.this$1 = legendEntry;
                }

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!LegendEntry.access$100((LegendEntry)this.this$1).m_useCustomColour) {
                        graphics.setColor(Color.black);
                    } else {
                        graphics.setColor(LegendEntry.access$100((LegendEntry)this.this$1).m_customColour);
                    }
                    Plot2D.drawDataPoint(10.0, 10.0, 3, LegendEntry.access$300(this.this$1), graphics);
                }
            };
            this.m_pointShape.setPreferredSize(new Dimension(20, 20));
            this.m_pointShape.setMinimumSize(new Dimension(20, 20));
            this.add((Component)this.m_pointShape, "West");
        }

        static /* synthetic */ LegendPanel access$000(LegendEntry legendEntry) {
            return legendEntry.LegendPanel.this;
        }

        static /* synthetic */ PlotData2D access$100(LegendEntry legendEntry) {
            return legendEntry.m_plotData;
        }

        static /* synthetic */ JLabel access$200(LegendEntry legendEntry) {
            return legendEntry.m_legendText;
        }

        static /* synthetic */ int access$300(LegendEntry legendEntry) {
            return legendEntry.m_dataIndex;
        }
    }
}

