/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.experiment.PairedStats;

public class PairedTTester
implements OptionHandler {
    protected Instances m_Instances;
    protected int m_RunColumn = 0;
    protected int m_RunColumnSet = -1;
    protected int m_FoldColumn = -1;
    protected double m_SignificanceLevel = 0.05;
    protected Range m_DatasetKeyColumnsRange = new Range();
    protected int[] m_DatasetKeyColumns;
    protected DatasetSpecifiers m_DatasetSpecifiers = new DatasetSpecifiers();
    protected Range m_ResultsetKeyColumnsRange = new Range();
    protected int[] m_ResultsetKeyColumns;
    protected FastVector m_Resultsets = new FastVector();
    protected boolean m_ResultsetsValid;
    protected boolean m_ShowStdDevs = false;
    protected boolean m_latexOutput = false;

    protected String templateString(Instance instance) {
        String string = "";
        for (int i = 0; i < this.m_DatasetKeyColumns.length; ++i) {
            string = string + instance.toString(this.m_DatasetKeyColumns[i]) + ' ';
        }
        if (string.startsWith("weka.classifiers.")) {
            string = string.substring("weka.classifiers.".length());
        }
        return string.trim();
    }

    public void setProduceLatex(boolean bl) {
        this.m_latexOutput = bl;
    }

    public boolean getProduceLatex() {
        return this.m_latexOutput;
    }

    public void setShowStdDevs(boolean bl) {
        this.m_ShowStdDevs = bl;
    }

    public boolean getShowStdDevs() {
        return this.m_ShowStdDevs;
    }

    protected void prepareData() throws Exception {
        Object object;
        int n;
        if (this.m_Instances == null) {
            throw new Exception("No instances have been set");
        }
        this.m_RunColumn = this.m_RunColumnSet == -1 ? this.m_Instances.numAttributes() - 1 : this.m_RunColumnSet;
        if (this.m_ResultsetKeyColumnsRange == null) {
            throw new Exception("No result specifier columns have been set");
        }
        this.m_ResultsetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_ResultsetKeyColumns = this.m_ResultsetKeyColumnsRange.getSelection();
        if (this.m_DatasetKeyColumnsRange == null) {
            throw new Exception("No dataset specifier columns have been set");
        }
        this.m_DatasetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_DatasetKeyColumns = this.m_DatasetKeyColumnsRange.getSelection();
        this.m_Resultsets.removeAllElements();
        this.m_DatasetSpecifiers.removeAllSpecifiers();
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            int n2;
            object = this.m_Instances.instance(n);
            if (((Instance)object).isMissing(this.m_RunColumn)) {
                throw new Exception("Instance has missing value in run column!\n" + object);
            }
            for (n2 = 0; n2 < this.m_ResultsetKeyColumns.length; ++n2) {
                if (!((Instance)object).isMissing(this.m_ResultsetKeyColumns[n2])) continue;
                throw new Exception("Instance has missing value in resultset key column " + (this.m_ResultsetKeyColumns[n2] + 1) + "!\n" + object);
            }
            for (n2 = 0; n2 < this.m_DatasetKeyColumns.length; ++n2) {
                if (!((Instance)object).isMissing(this.m_DatasetKeyColumns[n2])) continue;
                throw new Exception("Instance has missing value in dataset key column " + (this.m_DatasetKeyColumns[n2] + 1) + "!\n" + object);
            }
            n2 = 0;
            for (int i = 0; i < this.m_Resultsets.size(); ++i) {
                Resultset resultset = (Resultset)this.m_Resultsets.elementAt(i);
                if (!resultset.matchesTemplate((Instance)object)) continue;
                resultset.add((Instance)object);
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                Resultset resultset = new Resultset((Instance)object);
                this.m_Resultsets.addElement(resultset);
            }
            this.m_DatasetSpecifiers.add((Instance)object);
        }
        for (n = 0; n < this.m_Resultsets.size(); ++n) {
            object = (Resultset)this.m_Resultsets.elementAt(n);
            if (this.m_FoldColumn >= 0) {
                ((Resultset)object).sort(this.m_FoldColumn);
            }
            ((Resultset)object).sort(this.m_RunColumn);
        }
        this.m_ResultsetsValid = true;
    }

    public int getNumDatasets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        return this.m_DatasetSpecifiers.numSpecifiers();
    }

    public int getNumResultsets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        return this.m_Resultsets.size();
    }

    public String getResultsetName(int n) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return ((Resultset)this.m_Resultsets.elementAt(n)).templateString();
    }

    public PairedStats calculateStatistics(Instance instance, int n, int n2, int n3) throws Exception {
        if (this.m_Instances.attribute(n3).type() != 0) {
            throw new Exception("Comparison column " + (n3 + 1) + " (" + this.m_Instances.attribute(n3).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        Resultset resultset = (Resultset)this.m_Resultsets.elementAt(n);
        Resultset resultset2 = (Resultset)this.m_Resultsets.elementAt(n2);
        FastVector fastVector = resultset.dataset(instance);
        FastVector fastVector2 = resultset2.dataset(instance);
        String string = this.templateString(instance);
        if (fastVector == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset.templateString());
        }
        if (fastVector2 == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset2.templateString());
        }
        if (fastVector.size() != fastVector2.size()) {
            throw new Exception("Results for dataset=" + string + " differ in size for resultset=" + resultset.templateString() + " and resultset=" + resultset2.templateString());
        }
        PairedStats pairedStats = new PairedStats(this.m_SignificanceLevel);
        for (int i = 0; i < fastVector.size(); ++i) {
            Instance instance2 = (Instance)fastVector.elementAt(i);
            Instance instance3 = (Instance)fastVector2.elementAt(i);
            if (instance2.isMissing(n3)) {
                throw new Exception("Instance has missing value in comparison column!\n" + instance2);
            }
            if (instance3.isMissing(n3)) {
                throw new Exception("Instance has missing value in comparison column!\n" + instance3);
            }
            if (instance2.value(this.m_RunColumn) != instance3.value(this.m_RunColumn)) {
                System.err.println("Run numbers do not match!\n" + instance2 + instance3);
            }
            if (this.m_FoldColumn != -1 && instance2.value(this.m_FoldColumn) != instance3.value(this.m_FoldColumn)) {
                System.err.println("Fold numbers do not match!\n" + instance2 + instance3);
            }
            double d = instance2.value(n3);
            double d2 = instance3.value(n3);
            pairedStats.add(d, d2);
        }
        pairedStats.calculateDerived();
        System.err.println("Differences stats:\n" + pairedStats.differencesStats);
        return pairedStats;
    }

    public String resultsetKey() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        }
        String string = "";
        for (int i = 0; i < this.getNumResultsets(); ++i) {
            string = string + "(" + (i + 1) + ") " + this.getResultsetName(i) + '\n';
        }
        return string + '\n';
    }

    public String header(int n) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        }
        return "Analysing:  " + this.m_Instances.attribute(n).name() + '\n' + "Datasets:   " + this.getNumDatasets() + '\n' + "Resultsets: " + this.getNumResultsets() + '\n' + "Confidence: " + this.getSignificanceLevel() + " (two tailed)\n" + "Date:       " + new SimpleDateFormat().format(new Date()) + "\n\n";
    }

    public int[][] multiResultsetWins(int n) throws Exception {
        int n2 = this.getNumResultsets();
        int[][] nArray = new int[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                System.err.print("Comparing (" + (i + 1) + ") with (" + (j + 1) + ")\r");
                System.err.flush();
                for (int k = 0; k < this.getNumDatasets(); ++k) {
                    try {
                        PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(k), i, j, n);
                        if (pairedStats.differencesSignificance < 0) {
                            int[] nArray2 = nArray[i];
                            int n3 = j;
                            nArray2[n3] = nArray2[n3] + 1;
                            continue;
                        }
                        if (pairedStats.differencesSignificance <= 0) continue;
                        int[] nArray3 = nArray[j];
                        int n4 = i;
                        nArray3[n4] = nArray3[n4] + 1;
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.err.println(exception.getMessage());
                    }
                }
            }
        }
        return nArray;
    }

    public String multiResultsetSummary(int n) throws Exception {
        int n2;
        int[][] nArray = this.multiResultsetWins(n);
        int n3 = this.getNumResultsets();
        int n4 = 1 + Math.max((int)(Math.log(n3) / Math.log(10.0)), (int)(Math.log(this.getNumDatasets()) / Math.log(10.0)));
        String string = "";
        String string2 = "";
        if (this.m_latexOutput) {
            string = string + "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n";
            string = string + "\\footnotesize\n";
            string = string + "{\\centering \\begin{tabular}{l";
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_latexOutput) {
                string2 = string2 + " &";
                string = string + "c";
            }
            string2 = string2 + ' ' + Utils.padLeft("" + (char)(97 + n2 % 26), n4);
        }
        if (this.m_latexOutput) {
            string = string + "}}\\\\\n\\hline\n";
            string = string + string2 + " \\\\\n\\hline\n";
        } else {
            string = string + string2 + "  (No. of datasets where [col] >> [row])\n";
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n3; ++i) {
                if (this.m_latexOutput && i == 0) {
                    string = string + (char)(97 + n2 % 26);
                }
                if (i == n2) {
                    if (this.m_latexOutput) {
                        string = string + " & - ";
                        continue;
                    }
                    string = string + ' ' + Utils.padLeft("-", n4);
                    continue;
                }
                string = this.m_latexOutput ? string + "& " + nArray[n2][i] + ' ' : string + ' ' + Utils.padLeft("" + nArray[n2][i], n4);
            }
            string = !this.m_latexOutput ? string + " | " + (char)(97 + n2 % 26) + " = " + this.getResultsetName(n2) + '\n' : string + "\\\\\n";
        }
        if (this.m_latexOutput) {
            string = string + "\\hline\n\\end{tabular} \\footnotesize \\par}\n\\end{table}";
        }
        return string;
    }

    public String multiResultsetRanking(int n) throws Exception {
        String string;
        int n2;
        int n3;
        int[][] nArray = this.multiResultsetWins(n);
        int n4 = this.getNumResultsets();
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (n2 = 0; n2 < nArray[n3].length; ++n2) {
                int n5 = n2;
                nArray2[n5] = nArray2[n5] + nArray[n3][n2];
                int n6 = n2;
                nArray4[n6] = nArray4[n6] + nArray[n3][n2];
                int n7 = n3;
                nArray3[n7] = nArray3[n7] + nArray[n3][n2];
                int n8 = n3;
                nArray4[n8] = nArray4[n8] - nArray[n3][n2];
            }
        }
        n3 = Math.max(nArray2[Utils.maxIndex(nArray2)], nArray3[Utils.maxIndex(nArray3)]);
        n2 = Math.max(2 + (int)(Math.log(n3) / Math.log(10.0)), ">-<".length());
        if (this.m_latexOutput) {
            string = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n\\footnotesize\n{\\centering \\begin{tabular}{rlll}\\\\\n\\hline\n";
            string = string + "Resultset & Wins$-$ & Wins & Losses \\\\\n& Losses & & \\\\\n\\hline\n";
        } else {
            string = Utils.padLeft(">-<", n2) + ' ' + Utils.padLeft(">", n2) + ' ' + Utils.padLeft("<", n2) + " Resultset\n";
        }
        int[] nArray5 = Utils.sort(nArray4);
        for (int i = n4 - 1; i >= 0; --i) {
            int n9 = nArray5[i];
            string = this.m_latexOutput ? string + "(" + (n9 + 1) + ") & " + Utils.padLeft("" + nArray4[n9], n2) + " & " + Utils.padLeft("" + nArray2[n9], n2) + " & " + Utils.padLeft("" + nArray3[n9], n2) + "\\\\\n" : string + Utils.padLeft("" + nArray4[n9], n2) + ' ' + Utils.padLeft("" + nArray2[n9], n2) + ' ' + Utils.padLeft("" + nArray3[n9], n2) + ' ' + this.getResultsetName(n9) + '\n';
        }
        if (this.m_latexOutput) {
            string = string + "\\hline\n\\end{tabular} \\footnotesize \\par}\n\\end{table}";
        }
        return string;
    }

    private String multiResultsetFullLatex(int n, int n2, int n3, int n4) {
        int n5;
        StringBuffer stringBuffer = new StringBuffer(1000);
        int n6 = this.getNumResultsets() * 2;
        if (this.m_ShowStdDevs) {
            n6 += this.getNumResultsets();
        }
        stringBuffer.append("\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n");
        if (!this.m_ShowStdDevs) {
            stringBuffer.append("\\footnotesize\n");
        } else {
            stringBuffer.append("\\scriptsize\n");
        }
        if (!this.m_ShowStdDevs) {
            stringBuffer.append("{\\centering \\begin{tabular}{ll");
        } else {
            stringBuffer.append("{\\centering \\begin{tabular}{lr@{\\hspace{0cm}}l");
        }
        for (n5 = 0; n5 < this.getNumResultsets(); ++n5) {
            if (n5 == n) continue;
            if (!this.m_ShowStdDevs) {
                stringBuffer.append("l@{\\hspace{0.1cm}}l");
                continue;
            }
            stringBuffer.append("r@{\\hspace{0cm}}l@{\\hspace{0cm}}r");
        }
        stringBuffer.append("}\n\\\\\n\\hline\n");
        if (!this.m_ShowStdDevs) {
            stringBuffer.append("Data Set & (" + (n + 1) + ")");
        } else {
            stringBuffer.append("Data Set & \\multicolumn{2}{c}{(" + (n + 1) + ")}");
        }
        for (n5 = 0; n5 < this.getNumResultsets(); ++n5) {
            if (n5 == n) continue;
            if (!this.m_ShowStdDevs) {
                stringBuffer.append("& (" + (n5 + 1) + ") & ");
                continue;
            }
            stringBuffer.append("& \\multicolumn{3}{c}{(" + (n5 + 1) + ")} ");
        }
        stringBuffer.append("\\\\\n\\hline\n");
        n5 = 25;
        int n7 = n3 + 7;
        if (this.m_ShowStdDevs) {
            n7 += n4 + 5;
        }
        for (int i = 0; i < this.getNumDatasets(); ++i) {
            String string = this.templateString(this.m_DatasetSpecifiers.specifier(i)).replace('_', '-');
            try {
                PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i), n, n, n2);
                string = Utils.padRight(string, n5);
                stringBuffer.append(string);
                if (!this.m_ShowStdDevs) {
                    stringBuffer.append("& " + this.padIt(pairedStats.xStats.mean, n7 - 2, 2));
                } else {
                    stringBuffer.append("& " + this.padIt(pairedStats.xStats.mean, n3 + 5, 2) + "$\\pm$");
                    if (Double.isNaN(pairedStats.xStats.stdDev)) {
                        stringBuffer.append("&" + Utils.doubleToString(0.0, n4 + 3, 2) + " ");
                    } else {
                        stringBuffer.append("&" + this.padIt(pairedStats.xStats.stdDev, n4 + 3, 2) + " ");
                    }
                }
                for (int j = 0; j < this.getNumResultsets(); ++j) {
                    if (j == n) continue;
                    try {
                        pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i), n, j, n2);
                        String string2 = "";
                        if (pairedStats.differencesSignificance < 0) {
                            string2 = "$\\circ$";
                        } else if (pairedStats.differencesSignificance > 0) {
                            string2 = "$\\bullet$";
                        }
                        if (!this.m_ShowStdDevs) {
                            stringBuffer.append(" & " + this.padIt(pairedStats.yStats.mean, n7 - 2, 2)).append(" & " + string2);
                            continue;
                        }
                        stringBuffer.append(" & " + this.padIt(pairedStats.yStats.mean, n3 + 5, 2) + "$\\pm$");
                        if (Double.isNaN(pairedStats.yStats.stdDev)) {
                            stringBuffer.append("&" + Utils.doubleToString(0.0, n4 + 3, 2) + " ");
                        } else {
                            stringBuffer.append("&" + this.padIt(pairedStats.yStats.stdDev, n4 + 3, 2) + " ");
                        }
                        stringBuffer.append(" & ").append(string2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        stringBuffer.append(Utils.padLeft("", n7 + 1));
                    }
                }
                stringBuffer.append("\\\\\n");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        stringBuffer.append("\\hline\n\\multicolumn{" + n6 + "}{c}{$\\circ$, $\\bullet$" + " statistically significant improvement or degradation}" + "\\\\\n\\end{tabular} ");
        if (!this.m_ShowStdDevs) {
            stringBuffer.append("\\footnotesize ");
        } else {
            stringBuffer.append("\\scriptsize ");
        }
        stringBuffer.append("\\par}\n\\end{table}\n");
        System.out.println(stringBuffer.toString() + "\n\n");
        return stringBuffer.toString();
    }

    private String padIt(double d, int n, int n2) {
        String string = Utils.doubleToString(d, n, n2);
        int n3 = string.length();
        if ((string = string.trim()).indexOf(".") == -1) {
            string = string + ".00";
        } else if (string.indexOf(".") == string.length() - 2) {
            string = string + "0";
        }
        while (string.length() < n3) {
            string = " " + string;
        }
        return string;
    }

    private String multiResultsetFullPlainText(int n, int n2, int n3, int n4) {
        int n5;
        StringBuffer stringBuffer = new StringBuffer(1000);
        int n6 = 25;
        int n7 = n3 + 7;
        if (this.m_ShowStdDevs) {
            n7 += n4 + 5;
        }
        StringBuffer stringBuffer2 = new StringBuffer(Utils.padRight("Dataset", n6));
        stringBuffer2.append(' ');
        StringBuffer stringBuffer3 = new StringBuffer(Utils.padLeft("(" + (n + 1) + ") " + this.getResultsetName(n), n7 + 3));
        stringBuffer2.append(stringBuffer3);
        StringBuffer stringBuffer4 = new StringBuffer(Utils.padRight("", n6));
        while (stringBuffer4.length() < stringBuffer2.length()) {
            stringBuffer4.append('-');
        }
        stringBuffer4.append("---");
        stringBuffer2.append(" | ");
        for (int i = 0; i < this.getNumResultsets(); ++i) {
            if (i == n) continue;
            stringBuffer3 = new StringBuffer(Utils.padLeft("(" + (i + 1) + ") " + this.getResultsetName(i), n7));
            stringBuffer2.append(stringBuffer3).append(' ');
            for (int j = 0; j < stringBuffer3.length(); ++j) {
                stringBuffer4.append('-');
            }
            stringBuffer4.append('-');
        }
        stringBuffer.append(stringBuffer2).append('\n').append(stringBuffer4).append('\n');
        int[] nArray = new int[this.getNumResultsets()];
        int[] nArray2 = new int[this.getNumResultsets()];
        int[] nArray3 = new int[this.getNumResultsets()];
        StringBuffer stringBuffer5 = new StringBuffer("");
        for (n5 = 0; n5 < this.getNumDatasets(); ++n5) {
            String string = this.templateString(this.m_DatasetSpecifiers.specifier(n5));
            try {
                PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(n5), n, n, n2);
                string = Utils.padRight(string, n6);
                stringBuffer.append(string);
                stringBuffer.append(Utils.padLeft('(' + Utils.doubleToString(pairedStats.count, 0) + ')', 5)).append(' ');
                if (!this.m_ShowStdDevs) {
                    stringBuffer.append(this.padIt(pairedStats.xStats.mean, n7 - 2, 2)).append(" | ");
                } else {
                    stringBuffer.append(this.padIt(pairedStats.xStats.mean, n3 + 5, 2));
                    if (Double.isInfinite(pairedStats.xStats.stdDev)) {
                        stringBuffer.append('(' + Utils.padRight("Inf", n4 + 3) + ')').append(" | ");
                    } else {
                        stringBuffer.append('(' + this.padIt(pairedStats.xStats.stdDev, n4 + 3, 2) + ')').append(" | ");
                    }
                }
                for (int i = 0; i < this.getNumResultsets(); ++i) {
                    if (i == n) continue;
                    try {
                        pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(n5), n, i, n2);
                        char c = ' ';
                        if (pairedStats.differencesSignificance < 0) {
                            c = 'v';
                            int n8 = i;
                            nArray[n8] = nArray[n8] + 1;
                        } else if (pairedStats.differencesSignificance > 0) {
                            c = '*';
                            int n9 = i;
                            nArray2[n9] = nArray2[n9] + 1;
                        } else {
                            int n10 = i;
                            nArray3[n10] = nArray3[n10] + 1;
                        }
                        if (!this.m_ShowStdDevs) {
                            stringBuffer.append(this.padIt(pairedStats.yStats.mean, n7 - 2, 2)).append(' ').append(c).append(' ');
                            continue;
                        }
                        stringBuffer.append(this.padIt(pairedStats.yStats.mean, n3 + 5, 2));
                        if (Double.isInfinite(pairedStats.yStats.stdDev)) {
                            stringBuffer.append('(' + Utils.padRight("Inf", n4 + 3) + ')');
                        } else {
                            stringBuffer.append('(' + this.padIt(pairedStats.yStats.stdDev, n4 + 3, 2) + ')');
                        }
                        stringBuffer.append(' ').append(c).append(' ');
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        stringBuffer.append(Utils.padLeft("", n7 + 1));
                    }
                }
                stringBuffer.append('\n');
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                stringBuffer5.append(string).append(' ');
            }
        }
        stringBuffer.append(stringBuffer4).append('\n');
        stringBuffer.append(Utils.padLeft("(v/ /*)", n6 + 4 + n7)).append(" | ");
        for (n5 = 0; n5 < this.getNumResultsets(); ++n5) {
            if (n5 == n) continue;
            stringBuffer.append(Utils.padLeft("(" + nArray[n5] + '/' + nArray3[n5] + '/' + nArray2[n5] + ')', n7)).append(' ');
        }
        stringBuffer.append('\n');
        if (!stringBuffer5.equals("")) {
            stringBuffer.append("Skipped: ").append(stringBuffer5).append('\n');
        }
        return stringBuffer.toString();
    }

    public String multiResultsetFull(int n, int n2) throws Exception {
        int n3;
        int n4 = 2;
        int n5 = 2;
        for (int i = 0; i < this.getNumDatasets(); ++i) {
            for (n3 = 0; n3 < this.getNumResultsets(); ++n3) {
                try {
                    double d;
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i), n, n3, n2);
                    if (!Double.isInfinite(pairedStats.yStats.mean) && !Double.isNaN(pairedStats.yStats.mean) && (d = Math.log(Math.abs(pairedStats.yStats.mean)) / Math.log(10.0) + 1.0) > (double)n4) {
                        n4 = (int)d;
                    }
                    if (!this.m_ShowStdDevs || Double.isInfinite(pairedStats.yStats.stdDev) || Double.isNaN(pairedStats.yStats.stdDev) || !((d = Math.log(Math.abs(pairedStats.yStats.stdDev)) / Math.log(10.0) + 1.0) > (double)n5)) continue;
                    n5 = (int)d;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer = this.m_latexOutput ? new StringBuffer(this.multiResultsetFullLatex(n, n2, n4, n5)) : new StringBuffer(this.multiResultsetFullPlainText(n, n2, n4, n5));
        stringBuffer.append("\nKey:\n\n");
        for (n3 = 0; n3 < this.getNumResultsets(); ++n3) {
            stringBuffer.append("(" + (n3 + 1) + ") ");
            stringBuffer.append(this.getResultsetName(n3) + "\n");
        }
        return stringBuffer.toString();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tSpecify list of columns that specify a unique\n\tdataset.\n\tFirst and last are valid indexes. (default none)", "D", 1, "-D <index,index2-index4,...>"));
        vector.addElement(new Option("\tSet the index of the column containing the run number", "R", 1, "-R <index>"));
        vector.addElement(new Option("\tSet the index of the column containing the fold number", "F", 1, "-F <index>"));
        vector.addElement(new Option("\tSpecify list of columns that specify a unique\n\t'result generator' (eg: classifier name and options).\n\tFirst and last are valid indexes. (default none)", "G", 1, "-G <index1,index2-index4,...>"));
        vector.addElement(new Option("\tSet the significance level for comparisons (default 0.05)", "S", 1, "-S <significance level>"));
        vector.addElement(new Option("\tShow standard deviations", "V", 0, "-V"));
        vector.addElement(new Option("\tProduce table comparisons in Latex table format", "L", 0, "-L"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setShowStdDevs(Utils.getFlag('V', stringArray));
        this.setProduceLatex(Utils.getFlag('L', stringArray));
        String string = Utils.getOption('D', stringArray);
        Range range = new Range();
        if (string.length() != 0) {
            range.setRanges(string);
        }
        this.setDatasetKeyColumns(range);
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            if (string2.equals("first")) {
                this.setRunColumn(0);
            } else if (string2.equals("last")) {
                this.setRunColumn(-1);
            } else {
                this.setRunColumn(Integer.parseInt(string2) - 1);
            }
        } else {
            this.setRunColumn(-1);
        }
        String string3 = Utils.getOption('F', stringArray);
        if (string3.length() != 0) {
            this.setFoldColumn(Integer.parseInt(string3) - 1);
        } else {
            this.setFoldColumn(-1);
        }
        String string4 = Utils.getOption('S', stringArray);
        if (string4.length() != 0) {
            this.setSignificanceLevel(new Double(string4));
        } else {
            this.setSignificanceLevel(0.05);
        }
        String string5 = Utils.getOption('G', stringArray);
        Range range2 = new Range();
        if (string5.length() != 0) {
            range2.setRanges(string5);
        }
        this.setResultsetKeyColumns(range2);
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (!this.getResultsetKeyColumns().getRanges().equals("")) {
            stringArray[n++] = "-G";
            stringArray[n++] = this.getResultsetKeyColumns().getRanges();
        }
        if (!this.getDatasetKeyColumns().getRanges().equals("")) {
            stringArray[n++] = "-D";
            stringArray[n++] = this.getDatasetKeyColumns().getRanges();
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + (this.getRunColumn() + 1);
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSignificanceLevel();
        if (this.getShowStdDevs()) {
            stringArray[n++] = "-V";
        }
        if (this.getProduceLatex()) {
            stringArray[n++] = "-L";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Range getResultsetKeyColumns() {
        return this.m_ResultsetKeyColumnsRange;
    }

    public void setResultsetKeyColumns(Range range) {
        this.m_ResultsetKeyColumnsRange = range;
        this.m_ResultsetsValid = false;
    }

    public double getSignificanceLevel() {
        return this.m_SignificanceLevel;
    }

    public void setSignificanceLevel(double d) {
        this.m_SignificanceLevel = d;
    }

    public Range getDatasetKeyColumns() {
        return this.m_DatasetKeyColumnsRange;
    }

    public void setDatasetKeyColumns(Range range) {
        this.m_DatasetKeyColumnsRange = range;
        this.m_ResultsetsValid = false;
    }

    public int getRunColumn() {
        return this.m_RunColumnSet;
    }

    public void setRunColumn(int n) {
        this.m_RunColumnSet = n;
        this.m_ResultsetsValid = false;
    }

    public int getFoldColumn() {
        return this.m_FoldColumn;
    }

    public void setFoldColumn(int n) {
        this.m_FoldColumn = n;
        this.m_ResultsetsValid = false;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_ResultsetsValid = false;
    }

    public static void main(String[] stringArray) {
        try {
            PairedTTester pairedTTester = new PairedTTester();
            String string = Utils.getOption('t', stringArray);
            String string2 = Utils.getOption('c', stringArray);
            String string3 = Utils.getOption('b', stringArray);
            boolean bl = Utils.getFlag('s', stringArray);
            boolean bl2 = Utils.getFlag('r', stringArray);
            try {
                if (string.length() == 0 || string2.length() == 0) {
                    throw new Exception("-t and -c options are required");
                }
                pairedTTester.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string4 = "";
                Enumeration enumeration = pairedTTester.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string4 = string4 + option.synopsis() + '\n' + option.description() + '\n';
                }
                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + string4);
            }
            Instances instances = new Instances(new BufferedReader(new FileReader(string)));
            pairedTTester.setInstances(instances);
            int n = Integer.parseInt(string2) - 1;
            System.out.println(pairedTTester.header(n));
            if (bl2) {
                System.out.println(pairedTTester.multiResultsetRanking(n));
            } else if (bl) {
                System.out.println(pairedTTester.multiResultsetSummary(n));
            } else {
                System.out.println(pairedTTester.resultsetKey());
                if (string3.length() == 0) {
                    for (int i = 0; i < pairedTTester.getNumResultsets(); ++i) {
                        System.out.println(pairedTTester.multiResultsetFull(i, n));
                    }
                } else {
                    int n2 = Integer.parseInt(string3) - 1;
                    System.out.println(pairedTTester.multiResultsetFull(n2, n));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected class Resultset {
        Instance m_Template;
        FastVector m_Datasets;

        public Resultset(Instance instance) {
            this.m_Template = instance;
            this.m_Datasets = new FastVector();
            this.add(instance);
        }

        protected boolean matchesTemplate(Instance instance) {
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                if (instance.value(PairedTTester.this.m_ResultsetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_ResultsetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected String templateString() {
            String string = "";
            String string2 = "";
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                string2 = this.m_Template.toString(PairedTTester.this.m_ResultsetKeyColumns[i]) + ' ';
                string2 = Utils.removeSubstring(string2, "weka.classifiers.");
                string2 = Utils.removeSubstring(string2, "weka.filters.");
                string2 = Utils.removeSubstring(string2, "weka.attributeSelection.");
                string = string + string2;
            }
            return string.trim();
        }

        public FastVector dataset(Instance instance) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(instance)) continue;
                return ((Dataset)this.m_Datasets.elementAt(i)).contents();
            }
            return null;
        }

        public void add(Instance instance) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(instance)) continue;
                ((Dataset)this.m_Datasets.elementAt(i)).add(instance);
                return;
            }
            Dataset dataset = new Dataset(instance);
            this.m_Datasets.addElement(dataset);
        }

        public void sort(int n) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                ((Dataset)this.m_Datasets.elementAt(i)).sort(n);
            }
        }
    }

    protected class Dataset {
        Instance m_Template;
        FastVector m_Dataset;

        public Dataset(Instance instance) {
            this.m_Template = instance;
            this.m_Dataset = new FastVector();
            this.add(instance);
        }

        protected boolean matchesTemplate(Instance instance) {
            for (int i = 0; i < PairedTTester.this.m_DatasetKeyColumns.length; ++i) {
                if (instance.value(PairedTTester.this.m_DatasetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_DatasetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected void add(Instance instance) {
            this.m_Dataset.addElement(instance);
        }

        protected FastVector contents() {
            return this.m_Dataset;
        }

        public void sort(int n) {
            double[] dArray = new double[this.m_Dataset.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((Instance)this.m_Dataset.elementAt(i)).value(n);
            }
            int[] nArray = Utils.stableSort(dArray);
            FastVector fastVector = new FastVector(dArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                fastVector.addElement(this.m_Dataset.elementAt(nArray[i]));
            }
            this.m_Dataset = fastVector;
        }
    }

    protected class DatasetSpecifiers {
        FastVector m_Specifiers = new FastVector();

        protected DatasetSpecifiers() {
        }

        protected void removeAllSpecifiers() {
            this.m_Specifiers.removeAllElements();
        }

        protected void add(Instance instance) {
            for (int i = 0; i < this.m_Specifiers.size(); ++i) {
                Instance instance2 = (Instance)this.m_Specifiers.elementAt(i);
                boolean bl = true;
                for (int j = 0; j < PairedTTester.this.m_DatasetKeyColumns.length; ++j) {
                    if (instance.value(PairedTTester.this.m_DatasetKeyColumns[j]) == instance2.value(PairedTTester.this.m_DatasetKeyColumns[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
            this.m_Specifiers.addElement(instance);
        }

        protected Instance specifier(int n) {
            return (Instance)this.m_Specifiers.elementAt(n);
        }

        protected int numSpecifiers() {
            return this.m_Specifiers.size();
        }
    }
}

