/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.StringTokenizer;
import weka.core.Utils;

public class Matrix
implements Cloneable,
Serializable {
    protected double[][] m_Elements;

    public Matrix(int n, int n2) {
        this.m_Elements = new double[n][n2];
        this.initialize();
    }

    public Matrix(double[][] dArray) throws Exception {
        this.m_Elements = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                this.m_Elements[i][j] = dArray[i][j];
            }
        }
    }

    public Matrix(Reader reader) throws Exception {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            StringTokenizer stringTokenizer;
            if (string.startsWith("%") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens()) continue;
            if (n < 0) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of columns");
                }
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                this.m_Elements = new double[n2][n3];
                this.initialize();
                ++n;
                continue;
            }
            if (n == this.numRows()) {
                throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too many rows provided");
            }
            for (n2 = 0; n2 < this.numColumns(); ++n2) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few matrix elements provided");
                }
                this.m_Elements[n][n2] = Double.valueOf(stringTokenizer.nextToken());
            }
            ++n;
        }
        if (n == -1) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of rows");
        }
        if (n != this.numRows()) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few rows provided");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Matrix matrix = (Matrix)super.clone();
        matrix.m_Elements = new double[this.numRows()][this.numColumns()];
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numColumns(); ++j) {
                matrix.m_Elements[i][j] = this.m_Elements[i][j];
            }
        }
        return matrix;
    }

    public void write(Writer writer) throws Exception {
        writer.write("% Rows\tColumns\n");
        writer.write("" + this.numRows() + "\t" + this.numColumns() + "\n");
        writer.write("% Matrix elements\n");
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numColumns(); ++j) {
                writer.write("" + this.m_Elements[i][j] + "\t");
            }
            writer.write("\n");
        }
        writer.flush();
    }

    protected void initialize() {
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numColumns(); ++j) {
                this.m_Elements[i][j] = 0.0;
            }
        }
    }

    public final double getElement(int n, int n2) {
        return this.m_Elements[n][n2];
    }

    public final void addElement(int n, int n2, double d) {
        double[] dArray = this.m_Elements[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public final int numRows() {
        return this.m_Elements.length;
    }

    public final int numColumns() {
        return this.m_Elements[0].length;
    }

    public final void setElement(int n, int n2, double d) {
        this.m_Elements[n][n2] = d;
    }

    public final void setRow(int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.m_Elements[n][i] = dArray[i];
        }
    }

    public double[] getRow(int n) {
        double[] dArray = new double[this.numColumns()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.m_Elements[n][i];
        }
        return dArray;
    }

    public double[] getColumn(int n) {
        double[] dArray = new double[this.numRows()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.m_Elements[i][n];
        }
        return dArray;
    }

    public final void setColumn(int n, double[] dArray) {
        for (int i = 0; i < this.m_Elements.length; ++i) {
            this.m_Elements[i][n] = dArray[i];
        }
    }

    public String toString() {
        int n;
        double d = 0.0;
        boolean bl = false;
        for (n = 0; n < this.m_Elements.length; ++n) {
            for (int i = 0; i < this.m_Elements[n].length; ++i) {
                double d2 = this.m_Elements[n][i];
                if (d2 < 0.0) {
                    d2 *= -10.0;
                }
                if (d2 > d) {
                    d = d2;
                }
                double d3 = d2 - Math.rint(d2);
                if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                bl = true;
            }
        }
        n = (int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 4 : 1));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_Elements.length; ++i) {
            for (int j = 0; j < this.m_Elements[i].length; ++j) {
                stringBuffer.append(" ").append(Utils.doubleToString(this.m_Elements[i][j], n, bl ? 2 : 0));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public final Matrix add(Matrix matrix) {
        Matrix matrix2;
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        try {
            matrix2 = (Matrix)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            matrix2 = new Matrix(n, n2);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix2.m_Elements[i][j] = this.m_Elements[j][i] + matrix.m_Elements[j][i];
            }
        }
        return matrix2;
    }

    public final Matrix transpose() {
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        Matrix matrix = new Matrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix.m_Elements[i][j] = this.m_Elements[j][i];
            }
        }
        return matrix;
    }

    public boolean isSymmetric() {
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.m_Elements[i][j] == this.m_Elements[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public final Matrix multiply(Matrix matrix) {
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        int n3 = matrix.m_Elements.length;
        int n4 = matrix.m_Elements[0].length;
        Matrix matrix2 = new Matrix(n, n4);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double[] dArray = matrix2.m_Elements[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] + this.m_Elements[i][k] * matrix.m_Elements[k][j];
                }
            }
        }
        return matrix2;
    }

    public final double[] regression(Matrix matrix, double d) {
        if (matrix.numColumns() > 1) {
            throw new IllegalArgumentException("Only one dependent variable allowed");
        }
        int n = this.m_Elements[0].length;
        double[] dArray = new double[n];
        Matrix matrix2 = this.transpose();
        boolean bl = true;
        do {
            Matrix matrix3 = matrix2.multiply(this);
            for (int i = 0; i < n; ++i) {
                matrix3.setElement(i, i, matrix3.getElement(i, i) + d);
            }
            Matrix matrix4 = matrix2.multiply(matrix);
            for (int i = 0; i < n; ++i) {
                dArray[i] = matrix4.m_Elements[i][0];
            }
            try {
                matrix3.solve(dArray);
                bl = true;
            }
            catch (Exception exception) {
                d *= 10.0;
                bl = false;
            }
        } while (!bl);
        return dArray;
    }

    public final double[] regression(Matrix matrix, double[] dArray, double d) {
        if (dArray.length != this.numRows()) {
            throw new IllegalArgumentException("Incorrect number of weights provided");
        }
        Matrix matrix2 = new Matrix(this.numRows(), this.numColumns());
        Matrix matrix3 = new Matrix(this.numRows(), 1);
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.sqrt(dArray[i]);
            for (int j = 0; j < this.numColumns(); ++j) {
                matrix2.setElement(i, j, this.getElement(i, j) * d2);
            }
            matrix3.setElement(i, 0, matrix.getElement(i, 0) * d2);
        }
        return matrix2.regression(matrix3, d);
    }

    public Matrix getL() throws Exception {
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i && j < n2; ++j) {
                dArray[i][j] = this.m_Elements[i][j];
            }
            if (i >= n2) continue;
            dArray[i][i] = 1.0;
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    public Matrix getU() throws Exception {
        int n = this.m_Elements.length;
        int n2 = this.m_Elements[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n2; ++j) {
                dArray[i][j] = this.m_Elements[i][j];
            }
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    public int[] LUDecomposition() throws Exception {
        int n;
        double d;
        int n2;
        int n3 = this.m_Elements.length;
        int n4 = this.m_Elements[0].length;
        int[] nArray = new int[n3];
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            d = Math.abs(this.m_Elements[n2][0]);
            for (n = 1; n < n4; ++n) {
                double d2;
                double d3 = Math.abs(this.m_Elements[n2][n]);
                if (!(d2 > d)) continue;
                d = d3;
            }
            if (d < 1.0E-9) {
                throw new Exception("Matrix is singular!");
            }
            dArray[n2] = 1.0 / d;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            double d4;
            int n6;
            for (n6 = 0; n6 <= n2 && n6 < n3; ++n6) {
                d4 = 0.0;
                for (n5 = 0; n5 < n6; ++n5) {
                    d4 += this.m_Elements[n6][n5] * this.m_Elements[n5][n2];
                }
                this.m_Elements[n6][n2] = this.m_Elements[n6][n2] - d4;
            }
            for (n6 = n2 + 1; n6 < n3; ++n6) {
                d4 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    d4 += this.m_Elements[n6][n5] * this.m_Elements[n5][n2];
                }
                this.m_Elements[n6][n2] = this.m_Elements[n6][n2] - d4;
            }
            d = Math.abs(this.m_Elements[n2][n2]) * dArray[n2];
            n = n2;
            for (n5 = n2 + 1; n5 < n3; ++n5) {
                if (!(Math.abs(this.m_Elements[n5][n2]) * dArray[n5] > d)) continue;
                n = n5;
                d = Math.abs(this.m_Elements[n5][n2]) * dArray[n5];
            }
            if (n != n2) {
                double d5;
                for (n5 = 0; n5 < n4; ++n5) {
                    d5 = this.m_Elements[n2][n5];
                    this.m_Elements[n2][n5] = this.m_Elements[n][n5];
                    this.m_Elements[n][n5] = d5;
                }
                n5 = nArray[n2];
                nArray[n2] = nArray[n];
                nArray[n] = n5;
                d5 = dArray[n2];
                dArray[n2] = dArray[n];
                dArray[n] = n5;
            }
            if (this.m_Elements[n2][n2] == 0.0) {
                throw new Exception("Matrix is singular");
            }
            for (n5 = n2 + 1; n5 < n3; ++n5) {
                this.m_Elements[n5][n2] = this.m_Elements[n5][n2] / this.m_Elements[n2][n2];
            }
        }
        return nArray;
    }

    public void solve(double[] dArray) throws Exception {
        int n;
        double d;
        int n2;
        int n3 = this.m_Elements.length;
        int n4 = this.m_Elements[0].length;
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        int[] nArray = this.LUDecomposition();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dArray2[n2] = dArray[nArray[n2]];
        }
        dArray4[0] = dArray2[0];
        for (n2 = 1; n2 < n3; ++n2) {
            d = 0.0;
            for (n = 0; n < n2; ++n) {
                d += this.m_Elements[n2][n] * dArray4[n];
            }
            dArray4[n2] = dArray2[n2] - d;
        }
        dArray3[n4 - 1] = dArray4[n4 - 1] / this.m_Elements[n4 - 1][n4 - 1];
        for (n2 = n4 - 2; n2 >= 0; --n2) {
            d = 0.0;
            for (n = n2 + 1; n < n4; ++n) {
                d += this.m_Elements[n2][n] * dArray3[n];
            }
            dArray3[n2] = (dArray4[n2] - d) / this.m_Elements[n2][n2];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dArray[n2] = dArray3[n2];
        }
    }

    public void eigenvalueDecomposition(double[][] dArray, double[] dArray2) throws Exception {
        if (!this.isSymmetric()) {
            throw new Exception("EigenvalueDecomposition: Matrix must be symmetric.");
        }
        int n = this.numRows();
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = this.m_Elements[i][j];
            }
        }
        this.tred2(dArray, dArray2, dArray3, n);
        this.tql2(dArray, dArray2, dArray3, n);
    }

    private void tred2(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws Exception {
        double d;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = dArray[n - 1][n2];
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            int n3;
            d = 0.0;
            double d2 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                d += Math.abs(dArray2[n3]);
            }
            if (d == 0.0) {
                dArray3[n2] = dArray2[n2 - 1];
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray2[n3] = dArray[n2 - 1][n3];
                    dArray[n2][n3] = 0.0;
                    dArray[n3][n2] = 0.0;
                }
            } else {
                int n4;
                int n5;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n6 = n3;
                    dArray2[n6] = dArray2[n6] / d;
                    d2 += dArray2[n3] * dArray2[n3];
                }
                double d3 = dArray2[n2 - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                dArray3[n2] = d * d4;
                d2 -= d3 * d4;
                dArray2[n2 - 1] = d3 - d4;
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray3[n5] = 0.0;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray[n5][n2] = d3 = dArray2[n5];
                    d4 = dArray3[n5] + dArray[n5][n5] * d3;
                    for (int i = n5 + 1; i <= n2 - 1; ++i) {
                        d4 += dArray[i][n5] * dArray2[i];
                        int n7 = i;
                        dArray3[n7] = dArray3[n7] + dArray[i][n5] * d3;
                    }
                    dArray3[n5] = d4;
                }
                d3 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    int n8 = n5;
                    dArray3[n8] = dArray3[n8] / d2;
                    d3 += dArray3[n5] * dArray2[n5];
                }
                double d5 = d3 / (d2 + d2);
                for (n4 = 0; n4 < n2; ++n4) {
                    int n9 = n4;
                    dArray3[n9] = dArray3[n9] - d5 * dArray2[n4];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    d3 = dArray2[n4];
                    d4 = dArray3[n4];
                    for (int i = n4; i <= n2 - 1; ++i) {
                        double[] dArray4 = dArray[i];
                        int n10 = n4;
                        dArray4[n10] = dArray4[n10] - (d3 * dArray3[i] + d4 * dArray2[i]);
                    }
                    dArray2[n4] = dArray[n2 - 1][n4];
                    dArray[n2][n4] = 0.0;
                }
            }
            dArray2[n2] = d2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            int n11;
            dArray[n - 1][n2] = dArray[n2][n2];
            dArray[n2][n2] = 1.0;
            d = dArray2[n2 + 1];
            if (d != 0.0) {
                for (n11 = 0; n11 <= n2; ++n11) {
                    dArray2[n11] = dArray[n11][n2 + 1] / d;
                }
                for (n11 = 0; n11 <= n2; ++n11) {
                    int n12;
                    double d6 = 0.0;
                    for (n12 = 0; n12 <= n2; ++n12) {
                        d6 += dArray[n12][n2 + 1] * dArray[n12][n11];
                    }
                    for (n12 = 0; n12 <= n2; ++n12) {
                        double[] dArray5 = dArray[n12];
                        int n13 = n11;
                        dArray5[n13] = dArray5[n13] - d6 * dArray2[n12];
                    }
                }
            }
            for (n11 = 0; n11 <= n2; ++n11) {
                dArray[n11][n2 + 1] = 0.0;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = dArray[n - 1][n2];
            dArray[n - 1][n2] = 0.0;
        }
        dArray[n - 1][n - 1] = 1.0;
        dArray3[0] = 0.0;
    }

    private void tql2(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws Exception {
        for (int i = 1; i < n; ++i) {
            dArray3[i - 1] = dArray3[i];
        }
        dArray3[n - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.pow(2.0, -52.0);
        for (int i = 0; i < n; ++i) {
            int n2;
            d2 = Math.max(d2, Math.abs(dArray2[i]) + Math.abs(dArray3[i]));
            for (n2 = i; n2 < n && !(Math.abs(dArray3[n2]) <= d3 * d2); ++n2) {
            }
            if (n2 > i) {
                int n3 = 0;
                do {
                    double d4;
                    ++n3;
                    double d5 = dArray2[i];
                    double d6 = (dArray2[i + 1] - d5) / (2.0 * dArray3[i]);
                    double d7 = Matrix.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    dArray2[i] = dArray3[i] / (d6 + d7);
                    dArray2[i + 1] = dArray3[i] * (d6 + d7);
                    double d8 = dArray2[i + 1];
                    double d9 = d5 - dArray2[i];
                    int n4 = i + 2;
                    while (n4 < n) {
                        int n5 = n4++;
                        dArray2[n5] = dArray2[n5] - d9;
                    }
                    d += d9;
                    d6 = dArray2[n2];
                    double d10 = d4 = 1.0;
                    double d11 = d4;
                    double d12 = dArray3[i + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (int j = n2 - 1; j >= i; --j) {
                        d11 = d10;
                        d10 = d4;
                        d14 = d13;
                        d5 = d4 * dArray3[j];
                        d9 = d4 * d6;
                        d7 = Matrix.hypot(d6, dArray3[j]);
                        dArray3[j + 1] = d13 * d7;
                        d13 = dArray3[j] / d7;
                        d4 = d6 / d7;
                        d6 = d4 * dArray2[j] - d13 * d5;
                        dArray2[j + 1] = d9 + d13 * (d4 * d5 + d13 * dArray2[j]);
                        for (int k = 0; k < n; ++k) {
                            d9 = dArray[k][j + 1];
                            dArray[k][j + 1] = d13 * dArray[k][j] + d4 * d9;
                            dArray[k][j] = d4 * dArray[k][j] - d13 * d9;
                        }
                    }
                    d6 = -d13 * d14 * d11 * d12 * dArray3[i] / d8;
                    dArray3[i] = d13 * d6;
                    dArray2[i] = d4 * d6;
                } while (Math.abs(dArray3[i]) > d3 * d2);
            }
            dArray2[i] = dArray2[i] + d;
            dArray3[i] = 0.0;
        }
    }

    protected static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public boolean testEigen(Matrix matrix, double[] dArray, boolean bl) throws Exception {
        boolean bl2 = true;
        if (bl) {
            System.out.println("--- test Eigenvectors and Eigenvalues of Matrix A --------");
            System.out.println("Matrix A \n" + this);
            System.out.println("Matrix V, the columns are the Eigenvectors\n" + matrix);
            System.out.println("the Eigenvalues are");
            for (int i = 0; i < dArray.length; ++i) {
                System.out.println(Utils.doubleToString(dArray[i], 2));
            }
            System.out.println("\n---");
        }
        double[][] dArray2 = new double[matrix.numRows()][1];
        Matrix matrix2 = new Matrix(dArray2);
        for (int i = 0; i < matrix.numRows(); ++i) {
            int n;
            double[] dArray3 = matrix.getColumn(i);
            double d = 0.0;
            for (int j = 0; j < dArray3.length; ++j) {
                d += Math.pow(dArray3[j], 2.0);
            }
            d = Math.pow(d, 0.5);
            matrix2.setColumn(0, matrix.getColumn(i));
            if (bl) {
                System.out.println("Eigenvektor " + i + " =\n" + matrix2 + "\nNorm " + d);
            }
            Matrix matrix3 = this.multiply(matrix2);
            if (bl) {
                System.out.println("this x Eigenvektor " + i + " =\n");
                for (n = 0; n < matrix.numRows(); ++n) {
                    System.out.print(Utils.doubleToString(matrix3.getElement(n, 0), 2) + "  ");
                }
                System.out.println(" ");
                System.out.println(" ");
                System.out.println("Eigenvektor " + i + " x Eigenvalue " + Utils.doubleToString(dArray[i], 2) + " =");
            }
            for (n = 0; n < matrix.numRows() && bl2; ++n) {
                double d2 = matrix2.getElement(n, 0) * dArray[i];
                double d3 = d2 - matrix3.getElement(n, 0);
                boolean bl3 = bl2 = Math.abs(d3) < Utils.SMALL;
                if (Math.abs(d3) > Utils.SMALL) {
                    System.out.println("OOOOOOps");
                }
                if (!bl) continue;
                System.out.print(Utils.doubleToString(d2, 2) + "  ");
            }
            if (!bl) continue;
            System.out.println(" ");
            System.out.println("---");
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{2.3, 1.2, 5.0};
        double[] dArray2 = new double[]{5.2, 1.4, 9.0};
        double[] dArray3 = new double[]{4.0, 7.0, 8.0};
        double[] dArray4 = new double[]{1.0, 2.0, 3.0};
        try {
            int n;
            double[][] dArrayArray = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 6.0}, {3.0, 6.0, 9.0}};
            Matrix matrix = new Matrix(dArrayArray);
            int n2 = matrix.numRows();
            double[][] dArray5 = new double[n2][n2];
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            matrix.eigenvalueDecomposition(dArray5, dArray6);
            Matrix matrix2 = new Matrix(dArray5);
            Matrix matrix3 = new Matrix(2, 3);
            Matrix matrix4 = new Matrix(3, 2);
            System.out.println("Number of columns for a: " + matrix3.numColumns());
            System.out.println("Number of rows for a: " + matrix3.numRows());
            matrix3.setRow(0, dArray);
            matrix3.setRow(1, dArray2);
            matrix4.setColumn(0, dArray);
            matrix4.setColumn(1, dArray2);
            System.out.println("a:\n " + matrix3);
            System.out.println("b:\n " + matrix4);
            System.out.println("a (0, 0): " + matrix3.getElement(0, 0));
            System.out.println("a transposed:\n " + matrix3.transpose());
            System.out.println("a * b:\n " + matrix3.multiply(matrix4));
            Matrix matrix5 = new Matrix(3, 1);
            matrix5.setColumn(0, dArray3);
            System.out.println("r:\n " + matrix5);
            System.out.println("Coefficients of regression of b on r: ");
            double[] dArray8 = matrix4.regression(matrix5, 1.0E-8);
            for (n = 0; n < dArray8.length; ++n) {
                System.out.print(dArray8[n] + " ");
            }
            System.out.println();
            System.out.println("Weights: ");
            for (n = 0; n < dArray4.length; ++n) {
                System.out.print(dArray4[n] + " ");
            }
            System.out.println();
            System.out.println("Coefficients of weighted regression of b on r: ");
            dArray8 = matrix4.regression(matrix5, dArray4, 1.0E-8);
            for (n = 0; n < dArray8.length; ++n) {
                System.out.print(dArray8[n] + " ");
            }
            System.out.println();
            matrix3.setElement(0, 0, 6.0);
            System.out.println("a with (0, 0) set to 6:\n " + matrix3);
            matrix3.write(new FileWriter("main.matrix"));
            System.out.println("wrote matrix to \"main.matrix\"\n" + matrix3);
            matrix3 = new Matrix(new FileReader("main.matrix"));
            System.out.println("read matrix from \"main.matrix\"\n" + matrix3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

