/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;

public class FilteredClassifier
extends Classifier
implements Drawable {
    protected Classifier m_Classifier = new ZeroR();
    protected Filter m_Filter = new AttributeSelection();
    protected Instances m_FilteredInstances;
    static /* synthetic */ Class class$weka$filters$Filter;

    public String globalInfo() {
        return "Class for running an arbitrary classifier on data that has been passed through an arbitrary filter, providing the only way to access \"supervised\" filters in the Explorer. Like the classifier, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing its structure.";
    }

    public FilteredClassifier() {
        this(new ZeroR(), new AttributeSelection());
    }

    public FilteredClassifier(Classifier classifier, Filter filter) {
        this.m_Classifier = classifier;
        this.m_Filter = filter;
    }

    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull class name of classifier to use, followed\n\tby scheme options.\n\teg: \"weka.classifiers.bayes.NaiveBayes -D\"", "W", 1, "-W <classifier specification>"));
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.AttributeFilter -V -R 1,2\"", "F", 1, "-F <filter specification>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        Object object;
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            object = Utils.splitOptions(string);
            if (((String[])object).length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
            stringArray2 = object[0];
            object[0] = "";
            this.setClassifier(Classifier.forName((String)stringArray2, (String[])object));
        } else {
            this.setClassifier(new ZeroR());
        }
        object = Utils.getOption('F', stringArray);
        if (((String)object).length() > 0) {
            stringArray2 = Utils.splitOptions((String)object);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(class$weka$filters$Filter == null ? (class$weka$filters$Filter = FilteredClassifier.class$("weka.filters.Filter")) : class$weka$filters$Filter, string2, stringArray2));
        } else {
            this.setFilter(new AttributeSelection());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getClassifierSpec();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getFilterSpec();
        return stringArray;
    }

    public String classifierTipText() {
        return "The classifier to be used.";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        if (classifier instanceof OptionHandler) {
            return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
        }
        return classifier.getClass().getName();
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        if (filter instanceof OptionHandler) {
            return filter.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return filter.getClass().getName();
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifiers have been set!");
        }
        this.m_Filter.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Filter);
        this.m_FilteredInstances = instances.stringFreeStructure();
        this.m_Classifier.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            throw new Exception("Filter didn't make the test instance immediately available!");
        }
        this.m_Filter.batchFinished();
        Instance instance2 = this.m_Filter.output();
        return this.m_Classifier.distributionForInstance(instance2);
    }

    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "FilteredClassifier: No model built yet.";
        }
        String string = "FilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new FilteredClassifier(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

