/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class AttributeSelectedClassifier
extends Classifier
implements OptionHandler,
Drawable,
AdditionalMeasureProducer {
    protected Classifier m_Classifier = new ZeroR();
    protected AttributeSelection m_AttributeSelection = null;
    protected ASEvaluation m_Evaluator = new CfsSubsetEval();
    protected ASSearch m_Search = new BestFirst();
    protected Instances m_ReducedHeader;
    protected int m_numClasses;
    protected double m_numAttributesSelected;
    protected double m_selectionTime;
    protected double m_totalTime;

    public String globalInfo() {
        return "Dimensionality of training and test data is reduced by attribute selection before being passed on to a classifier.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tFull class name of classifier to use, followed\n\tby scheme options. (required)\n\teg: \"weka.classifiers.bayes.NaiveBayes -D\"", "W", 1, "-W <classifier specification>"));
        vector.addElement(new Option("\tFull class name of attribute evaluator, followed\n\tby its options. (required)\n\teg: \"weka.attributeSelection.CfsSubsetEval -L\"", "E", 1, "-E <attribute evaluator specification>"));
        vector.addElement(new Option("\tFull class name of search method, followed\n\tby its options. (required)\n\teg: \"weka.attributeSelection.BestFirst -D 1\"", "S", 1, "-S <search method specification>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length == 0) {
            throw new Exception("Invalid classifier specification string");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setClassifier(Classifier.forName(string2, stringArray2));
        String string3 = Utils.getOption('E', stringArray);
        if (string3.length() == 0) {
            throw new Exception("An attribute evaluator must be specified with the -E option.");
        }
        String[] stringArray3 = Utils.splitOptions(string3);
        if (stringArray3.length == 0) {
            throw new Exception("Invalid attribute evaluator specification string");
        }
        String string4 = stringArray3[0];
        stringArray3[0] = "";
        this.setEvaluator(ASEvaluation.forName(string4, stringArray3));
        String string5 = Utils.getOption('S', stringArray);
        if (string5.length() == 0) {
            throw new Exception("A search method must be specified with the -S option.");
        }
        String[] stringArray4 = Utils.splitOptions(string5);
        if (stringArray4.length == 0) {
            throw new Exception("Invalid search specification string");
        }
        String string6 = stringArray4[0];
        stringArray4[0] = "";
        this.setSearch(ASSearch.forName(string6, stringArray4));
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getClassifierSpec();
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.getEvaluatorSpec();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSearchSpec();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String classifierTipText() {
        return "Set the classifier to use";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        if (classifier instanceof OptionHandler) {
            return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
        }
        return classifier.getClass().getName();
    }

    public String evaluatorTipText() {
        return "Set the attribute evaluator to use. This evaluator is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setEvaluator(ASEvaluation aSEvaluation) {
        this.m_Evaluator = aSEvaluation;
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    protected String getEvaluatorSpec() {
        ASEvaluation aSEvaluation = this.getEvaluator();
        if (aSEvaluation instanceof OptionHandler) {
            return aSEvaluation.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)aSEvaluation)).getOptions());
        }
        return aSEvaluation.getClass().getName();
    }

    public String searchTipText() {
        return "Set the search method. This search method is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setSearch(ASSearch aSSearch) {
        this.m_Search = aSSearch;
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    protected String getSearchSpec() {
        ASSearch aSSearch = this.getSearch();
        if (aSSearch instanceof OptionHandler) {
            return aSSearch.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)aSSearch)).getOptions());
        }
        return aSSearch.getClass().getName();
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        if (this.m_Evaluator == null) {
            throw new Exception("No attribute evaluator has been set!");
        }
        if (this.m_Search == null) {
            throw new Exception("No search method has been set!");
        }
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() == 0) {
            this.m_Classifier.buildClassifier(instances2);
            return;
        }
        this.m_numClasses = instances2.classAttribute().isNominal() ? instances2.classAttribute().numValues() : 1;
        this.m_AttributeSelection = new AttributeSelection();
        this.m_AttributeSelection.setEvaluator(this.m_Evaluator);
        this.m_AttributeSelection.setSearch(this.m_Search);
        long l = System.currentTimeMillis();
        this.m_AttributeSelection.SelectAttributes(instances2);
        long l2 = System.currentTimeMillis();
        instances2 = this.m_AttributeSelection.reduceDimensionality(instances2);
        this.m_Classifier.buildClassifier(instances2);
        long l3 = System.currentTimeMillis();
        this.m_numAttributesSelected = this.m_AttributeSelection.numberAttributesSelected();
        this.m_ReducedHeader = new Instances(instances2, 0);
        this.m_selectionTime = l2 - l;
        this.m_totalTime = l3 - l;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance instance2 = this.m_AttributeSelection == null ? instance : this.m_AttributeSelection.reduceDimensionality(instance);
        return this.m_Classifier.distributionForInstance(instance2);
    }

    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public String toString() {
        if (this.m_AttributeSelection == null) {
            return "AttributeSelectedClassifier: No attribute selection possible.\n\n" + this.m_Classifier.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AttributeSelectedClassifier:\n\n");
        stringBuffer.append(this.m_AttributeSelection.toResultsString());
        stringBuffer.append("\n\nHeader of reduced data:\n" + this.m_ReducedHeader.toString());
        stringBuffer.append("\n\nClassifier Model\n" + this.m_Classifier.toString());
        return stringBuffer.toString();
    }

    public double measureNumAttributesSelected() {
        return this.m_numAttributesSelected;
    }

    public double measureSelectionTime() {
        return this.m_selectionTime;
    }

    public double measureTime() {
        return this.m_totalTime;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("measureNumAttributesSelected");
        vector.addElement("measureSelectionTime");
        vector.addElement("measureTime");
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumAttributesSelected") == 0) {
            return this.measureNumAttributesSelected();
        }
        if (string.compareToIgnoreCase("measureSelectionTime") == 0) {
            return this.measureSelectionTime();
        }
        if (string.compareToIgnoreCase("measureTime") == 0) {
            return this.measureTime();
        }
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(string);
        }
        throw new IllegalArgumentException(string + " not supported (AttributeSelectedClassifier)");
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new AttributeSelectedClassifier(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

