/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instance;
import weka.core.Instances;

public class RBFKernel
extends Kernel {
    private double[] m_kernelPrecalc;
    private int m_kernelEvals = 0;
    private int m_cacheSize;
    private double[] m_storage;
    private long[] m_keys;
    private double m_gamma = 0.01;
    private int m_numInsts;

    public RBFKernel(Instances instances, int n, double d) throws Exception {
        this.m_gamma = d;
        this.m_data = instances;
        this.m_numInsts = this.m_data.numInstances();
        this.m_cacheSize = n;
        this.m_storage = new double[this.m_cacheSize];
        this.m_keys = new long[this.m_cacheSize];
        this.m_kernelPrecalc = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.m_kernelPrecalc[i] = this.dotProd(instances.instance(i), instances.instance(i));
        }
    }

    public double eval(int n, int n2, Instance instance) throws Exception {
        double d = 0.0;
        long l = -1L;
        int n3 = -1;
        if (n >= 0) {
            l = n > n2 ? (long)n * (long)this.m_numInsts + (long)n2 : (long)n2 * (long)this.m_numInsts + (long)n;
            if (l < 0L) {
                throw new Exception("Cache overflow detected!");
            }
            n3 = (int)(l % (long)this.m_keys.length);
            if (this.m_keys[n3] == l + 1L) {
                return this.m_storage[n3];
            }
        }
        Instance instance2 = this.m_data.instance(n2);
        double d2 = n == -1 ? this.dotProd(instance, instance) : this.m_kernelPrecalc[n];
        d = Math.exp(this.m_gamma * (2.0 * this.dotProd(instance, instance2) - d2 - this.m_kernelPrecalc[n2]));
        ++this.m_kernelEvals;
        if (l != -1L) {
            this.m_storage[n3] = d;
            this.m_keys[n3] = l + 1L;
        }
        return d;
    }

    private double dotProd(Instance instance, Instance instance2) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = instance2.numValues();
        int n3 = this.m_data.classIndex();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            int n6;
            int n7 = instance.index(n4);
            if (n7 == (n6 = instance2.index(n5))) {
                if (n7 != n3) {
                    d += instance.valueSparse(n4) * instance2.valueSparse(n5);
                }
                ++n4;
                ++n5;
                continue;
            }
            if (n7 > n6) {
                ++n5;
                continue;
            }
            ++n4;
        }
        return d;
    }

    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
    }

    public int numEvals() {
        return this.m_kernelEvals;
    }
}

