/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Sourcable;
import weka.classifiers.UpdateableClassifier;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class Evaluation
implements Summarizable {
    protected int m_NumClasses;
    protected int m_NumFolds;
    protected double m_Incorrect;
    protected double m_Correct;
    protected double m_Unclassified;
    protected double m_MissingClass;
    protected double m_WithClass;
    protected double[][] m_ConfusionMatrix;
    protected String[] m_ClassNames;
    protected boolean m_ClassIsNominal;
    protected double[] m_ClassPriors;
    protected double m_ClassPriorsSum;
    protected CostMatrix m_CostMatrix;
    protected double m_TotalCost;
    protected double m_SumErr;
    protected double m_SumAbsErr;
    protected double m_SumSqrErr;
    protected double m_SumClass;
    protected double m_SumSqrClass;
    protected double m_SumPredicted;
    protected double m_SumSqrPredicted;
    protected double m_SumClassPredicted;
    protected double m_SumPriorAbsErr;
    protected double m_SumPriorSqrErr;
    protected double m_SumKBInfo;
    protected static int k_MarginResolution = 500;
    protected double[] m_MarginCounts;
    protected int m_NumTrainClassVals;
    protected double[] m_TrainClassVals;
    protected double[] m_TrainClassWeights;
    protected Estimator m_PriorErrorEstimator;
    protected Estimator m_ErrorEstimator;
    protected static final double MIN_SF_PROB = Double.MIN_VALUE;
    protected double m_SumPriorEntropy;
    protected double m_SumSchemeEntropy;

    public Evaluation(Instances instances) throws Exception {
        this(instances, null);
    }

    public Evaluation(Instances instances, CostMatrix costMatrix) throws Exception {
        this.m_NumClasses = instances.numClasses();
        this.m_NumFolds = 1;
        this.m_ClassIsNominal = instances.classAttribute().isNominal();
        if (this.m_ClassIsNominal) {
            this.m_ConfusionMatrix = new double[this.m_NumClasses][this.m_NumClasses];
            this.m_ClassNames = new String[this.m_NumClasses];
            for (int i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassNames[i] = instances.classAttribute().value(i);
            }
        }
        this.m_CostMatrix = costMatrix;
        if (this.m_CostMatrix != null) {
            if (!this.m_ClassIsNominal) {
                throw new Exception("Class has to be nominal if cost matrix given!");
            }
            if (this.m_CostMatrix.size() != this.m_NumClasses) {
                throw new Exception("Cost matrix not compatible with data!");
            }
        }
        this.m_ClassPriors = new double[this.m_NumClasses];
        this.setPriors(instances);
        this.m_MarginCounts = new double[k_MarginResolution + 1];
    }

    public double[][] confusionMatrix() {
        double[][] dArray = new double[this.m_ConfusionMatrix.length][0];
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            dArray[i] = new double[this.m_ConfusionMatrix[i].length];
            System.arraycopy(this.m_ConfusionMatrix[i], 0, dArray[i], 0, this.m_ConfusionMatrix[i].length);
        }
        return dArray;
    }

    public void crossValidateModel(Classifier classifier, Instances instances, int n, Random random) throws Exception {
        instances = new Instances(instances);
        instances.randomize(random);
        if (instances.classAttribute().isNominal()) {
            instances.stratify(n);
        }
        for (int i = 0; i < n; ++i) {
            Instances instances2 = instances.trainCV(n, i, random);
            this.setPriors(instances2);
            classifier.buildClassifier(instances2);
            Instances instances3 = instances.testCV(n, i);
            this.evaluateModel(classifier, instances3);
        }
        this.m_NumFolds = n;
    }

    public void crossValidateModel(String string, Instances instances, int n, String[] stringArray, Random random) throws Exception {
        this.crossValidateModel(Classifier.forName(string, stringArray), instances, n, random);
    }

    public static String evaluateModel(String string, String[] stringArray) throws Exception {
        Classifier classifier;
        try {
            classifier = (Classifier)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
        return Evaluation.evaluateModel(classifier, stringArray);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            System.out.println(Evaluation.evaluateModel(string, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public static String evaluateModel(Classifier classifier, String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Instances instances = null;
        Instances instances2 = null;
        Instances instances3 = null;
        int n = 1;
        int n2 = 10;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        ObjectInputStream objectInputStream = null;
        CostMatrix costMatrix = null;
        StringBuffer stringBuffer2 = null;
        Range range = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            String string6;
            String string7;
            String string8 = Utils.getOption('c', stringArray);
            if (string8.length() != 0) {
                n3 = Integer.parseInt(string8);
            }
            string5 = Utils.getOption('t', stringArray);
            string4 = Utils.getOption('l', stringArray);
            string3 = Utils.getOption('d', stringArray);
            string2 = Utils.getOption('T', stringArray);
            if (string5.length() == 0) {
                if (string4.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (string2.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (!(string4.length() == 0 || classifier instanceof UpdateableClassifier && string2.length() != 0)) {
                throw new Exception("Classifier not incremental, or no test file provided: can't use both train and model file.");
            }
            try {
                if (string5.length() != 0) {
                    bufferedReader = new BufferedReader(new FileReader(string5));
                }
                if (string2.length() != 0) {
                    bufferedReader2 = new BufferedReader(new FileReader(string2));
                }
                if (string4.length() != 0) {
                    InputStream inputStream = new FileInputStream(string4);
                    if (string4.endsWith(".gz")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    objectInputStream = new ObjectInputStream(inputStream);
                }
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + '.');
            }
            if (string2.length() != 0) {
                instances3 = instances2 = new Instances(bufferedReader2, 1);
                if (n3 != -1) {
                    instances2.setClassIndex(n3 - 1);
                } else {
                    instances2.setClassIndex(instances2.numAttributes() - 1);
                }
                if (n3 > instances2.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
            }
            if (string5.length() != 0) {
                instances = classifier instanceof UpdateableClassifier && string2.length() != 0 ? new Instances(bufferedReader, 1) : new Instances(bufferedReader);
                instances3 = instances;
                if (n3 != -1) {
                    instances.setClassIndex(n3 - 1);
                } else {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                if (string2.length() != 0 && !instances2.equalHeaders(instances)) {
                    throw new IllegalArgumentException("Train and test file not compatible!");
                }
                if (n3 > instances.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
            }
            if (instances3 == null) {
                throw new Exception("No actual dataset provided to use as template");
            }
            String string9 = Utils.getOption('s', stringArray);
            if (string9.length() != 0) {
                n = Integer.parseInt(string9);
            }
            if ((string7 = Utils.getOption('x', stringArray)).length() != 0) {
                n2 = Integer.parseInt(string7);
            }
            costMatrix = Evaluation.handleCostOption(Utils.getOption('m', stringArray), instances3.numClasses());
            bl8 = Utils.getFlag('i', stringArray);
            bl2 = Utils.getFlag('o', stringArray);
            bl4 = !Utils.getFlag('v', stringArray);
            bl6 = Utils.getFlag('k', stringArray);
            bl5 = Utils.getFlag('r', stringArray);
            bl7 = Utils.getFlag('g', stringArray);
            string = Utils.getOption('z', stringArray);
            bl9 = string.length() != 0;
            try {
                string6 = Utils.getOption('p', stringArray);
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage() + "\nNOTE: the -p option has changed. " + "It now expects a parameter specifying a range of attributes " + "to list with the predictions. Use '-p 0' for none.");
            }
            if (string6.length() != 0) {
                bl3 = true;
                if (!string6.equals("0")) {
                    range = new Range(string6);
                }
            }
            if (string4.length() != 0) {
                Utils.checkForRemainingOptions(stringArray);
            } else if (classifier instanceof OptionHandler) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 0) continue;
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer();
                    }
                    if (stringArray[i].indexOf(32) != -1) {
                        stringBuffer2.append('\"' + stringArray[i] + "\" ");
                        continue;
                    }
                    stringBuffer2.append(stringArray[i] + " ");
                }
                classifier.setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            throw new Exception("\nWeka exception: " + exception.getMessage() + Evaluation.makeOptionString(classifier));
        }
        Evaluation evaluation = new Evaluation(new Instances(instances3, 0), costMatrix);
        Evaluation evaluation2 = new Evaluation(new Instances(instances3, 0), costMatrix);
        if (string4.length() != 0) {
            classifier = (Classifier)objectInputStream.readObject();
            objectInputStream.close();
        }
        if (classifier instanceof UpdateableClassifier && string2.length() != 0 && costMatrix == null && string5.length() != 0) {
            evaluation.setPriors(instances);
            evaluation2.setPriors(instances);
            l = System.currentTimeMillis();
            if (string4.length() == 0) {
                classifier.buildClassifier(instances);
            }
            while (instances.readInstance(bufferedReader)) {
                evaluation.updatePriors(instances.instance(0));
                evaluation2.updatePriors(instances.instance(0));
                ((UpdateableClassifier)((Object)classifier)).updateClassifier(instances.instance(0));
                instances.delete(0);
            }
            l2 = System.currentTimeMillis() - l;
            bufferedReader.close();
        } else if (string4.length() == 0) {
            Instances instances4 = new Instances(instances);
            evaluation.setPriors(instances4);
            evaluation2.setPriors(instances4);
            l = System.currentTimeMillis();
            classifier.buildClassifier(instances4);
            l2 = System.currentTimeMillis() - l;
        }
        if (string3.length() != 0) {
            object = new FileOutputStream(string3);
            if (string3.endsWith(".gz")) {
                object = new GZIPOutputStream((OutputStream)object);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            objectOutputStream.writeObject(classifier);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        if (classifier instanceof Drawable && bl7) {
            return ((Drawable)((Object)classifier)).graph();
        }
        if (classifier instanceof Sourcable && bl9) {
            return Evaluation.wekaStaticWrapper((Sourcable)((Object)classifier), string);
        }
        if (bl3) {
            return Evaluation.printClassifications(classifier, new Instances(instances3, 0), string2, n3, range);
        }
        if (!bl2 && !bl5) {
            if (classifier instanceof OptionHandler && stringBuffer2 != null) {
                stringBuffer.append("\nOptions: " + stringBuffer2);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n" + classifier.toString() + "\n");
        }
        if (!bl5 && costMatrix != null) {
            stringBuffer.append("\n=== Evaluation Cost Matrix ===\n\n").append(costMatrix.toString());
        }
        if (bl4 && string5.length() != 0) {
            if (classifier instanceof UpdateableClassifier && string2.length() != 0 && costMatrix == null) {
                bufferedReader = new BufferedReader(new FileReader(string5));
                instances = new Instances(bufferedReader, 1);
                if (n3 != -1) {
                    instances.setClassIndex(n3 - 1);
                } else {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                l3 = System.currentTimeMillis();
                while (instances.readInstance(bufferedReader)) {
                    evaluation.evaluateModelOnce(classifier, instances.instance(0));
                    instances.delete(0);
                }
                l4 = System.currentTimeMillis() - l3;
                bufferedReader.close();
            } else {
                l3 = System.currentTimeMillis();
                evaluation.evaluateModel(classifier, instances);
                l4 = System.currentTimeMillis() - l3;
            }
            if (bl5) {
                return evaluation.toCumulativeMarginDistributionString();
            }
            stringBuffer.append("\nTime taken to build model: " + Utils.doubleToString((double)l2 / 1000.0, 2) + " seconds");
            stringBuffer.append("\nTime taken to test model on training data: " + Utils.doubleToString((double)l4 / 1000.0, 2) + " seconds");
            stringBuffer.append(evaluation.toSummaryString("\n\n=== Error on training data ===\n", bl6));
            if (instances3.classAttribute().isNominal()) {
                if (bl8) {
                    stringBuffer.append("\n\n" + evaluation.toClassDetailsString());
                }
                stringBuffer.append("\n\n" + evaluation.toMatrixString());
            }
        }
        if (string2.length() != 0) {
            while (instances2.readInstance(bufferedReader2)) {
                evaluation2.evaluateModelOnce(classifier, instances2.instance(0));
                instances2.delete(0);
            }
            bufferedReader2.close();
            stringBuffer.append("\n\n" + evaluation2.toSummaryString("=== Error on test data ===\n", bl6));
        } else if (string5.length() != 0) {
            object = new Random(n);
            evaluation2.crossValidateModel(classifier, instances, n2, (Random)object);
            if (instances3.classAttribute().isNumeric()) {
                stringBuffer.append("\n\n\n" + evaluation2.toSummaryString("=== Cross-validation ===\n", bl6));
            } else {
                stringBuffer.append("\n\n\n" + evaluation2.toSummaryString("=== Stratified cross-validation ===\n", bl6));
            }
        }
        if (instances3.classAttribute().isNominal()) {
            if (bl8) {
                stringBuffer.append("\n\n" + evaluation2.toClassDetailsString());
            }
            stringBuffer.append("\n\n" + evaluation2.toMatrixString());
        }
        return stringBuffer.toString();
    }

    protected static CostMatrix handleCostOption(String string, int n) throws Exception {
        if (string != null && string.length() != 0) {
            System.out.println("NOTE: The behaviour of the -m option has changed between WEKA 3.0 and WEKA 3.1. -m now carries out cost-sensitive *evaluation* only. For cost-sensitive *prediction*, use one of the cost-sensitive metaschemes such as weka.classifiers.meta.CostSensitiveClassifier or weka.classifiers.meta.MetaCost");
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + '.');
            }
            try {
                return new CostMatrix(bufferedReader);
            }
            catch (Exception exception) {
                try {
                    try {
                        ((Reader)bufferedReader).close();
                        bufferedReader = new BufferedReader(new FileReader(string));
                    }
                    catch (Exception exception2) {
                        throw new Exception("Can't open file " + exception2.getMessage() + '.');
                    }
                    CostMatrix costMatrix = new CostMatrix(n);
                    costMatrix.readOldFormat(bufferedReader);
                    return costMatrix;
                }
                catch (Exception exception3) {
                    throw exception;
                }
            }
        }
        return null;
    }

    public double[] evaluateModel(Classifier classifier, Instances instances) throws Exception {
        double[] dArray = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray[i] = this.evaluateModelOnce(classifier, instances.instance(i));
        }
        return dArray;
    }

    public double evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        double d = 0.0;
        instance2.setDataset(instance.dataset());
        instance2.setClassMissing();
        if (this.m_ClassIsNominal) {
            double[] dArray = classifier.distributionForInstance(instance2);
            if (dArray[(int)(d = (double)Utils.maxIndex(dArray))] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
        } else {
            d = classifier.classifyInstance(instance2);
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public double evaluateModelOnce(double[] dArray, Instance instance) throws Exception {
        double d;
        if (this.m_ClassIsNominal) {
            d = Utils.maxIndex(dArray);
            if (dArray[(int)d] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
        } else {
            d = dArray[0];
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public void evaluateModelOnce(double d, Instance instance) throws Exception {
        if (this.m_ClassIsNominal) {
            this.updateStatsForClassifier(this.makeDistribution(d), instance);
        } else {
            this.updateStatsForPredictor(d, instance);
        }
    }

    protected static String wekaStaticWrapper(Sourcable sourcable, String string) throws Exception {
        String string2 = sourcable.toSource(string);
        return "package weka.classifiers;\nimport weka.core.Attribute;\nimport weka.core.Instance;\nimport weka.core.Instances;\nimport weka.classifiers.Classifier;\n\npublic class WekaWrapper extends Classifier {\n\n  public void buildClassifier(Instances i) throws Exception {\n  }\n\n  public double classifyInstance(Instance i) throws Exception {\n\n    Object [] s = new Object [i.numAttributes()];\n    for (int j = 0; j < s.length; j++) {\n      if (!i.isMissing(j)) {\n        if (i.attribute(j).type() == Attribute.NOMINAL) {\n          s[j] = i.attribute(j).value((int) i.value(j));\n        } else if (i.attribute(j).type() == Attribute.NUMERIC) {\n          s[j] = new Double(i.value(j));\n        }\n      }\n    }\n    return " + string + ".classify(s);\n" + "  }\n\n" + "}\n\n" + string2;
    }

    public final double numInstances() {
        return this.m_WithClass;
    }

    public final double incorrect() {
        return this.m_Incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * this.m_Incorrect / this.m_WithClass;
    }

    public final double totalCost() {
        return this.m_TotalCost;
    }

    public final double avgCost() {
        return this.m_TotalCost / this.m_WithClass;
    }

    public final double correct() {
        return this.m_Correct;
    }

    public final double pctCorrect() {
        return 100.0 * this.m_Correct / this.m_WithClass;
    }

    public final double unclassified() {
        return this.m_Unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * this.m_Unclassified / this.m_WithClass;
    }

    public final double errorRate() {
        if (!this.m_ClassIsNominal) {
            return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
        }
        if (this.m_CostMatrix == null) {
            return this.m_Incorrect / this.m_WithClass;
        }
        return this.avgCost();
    }

    public final double kappa() {
        double[] dArray = new double[this.m_ConfusionMatrix.length];
        double[] dArray2 = new double[this.m_ConfusionMatrix.length];
        double d = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            for (int j = 0; j < this.m_ConfusionMatrix.length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.m_ConfusionMatrix[i][j];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.m_ConfusionMatrix[i][j];
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            d3 += dArray[i] * dArray2[i];
            d2 += this.m_ConfusionMatrix[i][i];
        }
        d3 /= d * d;
        d2 /= d;
        if (d3 < 1.0) {
            return (d2 - d3) / (1.0 - d3);
        }
        return 1.0;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_ClassIsNominal) {
            throw new Exception("Can't compute correlation coefficient: class is nominal!");
        }
        double d = 0.0;
        double d2 = this.m_SumSqrClass - this.m_SumClass * this.m_SumClass / this.m_WithClass;
        double d3 = this.m_SumSqrPredicted - this.m_SumPredicted * this.m_SumPredicted / this.m_WithClass;
        double d4 = this.m_SumClassPredicted - this.m_SumClass * this.m_SumPredicted / this.m_WithClass;
        d = Utils.smOrEq(d2 * d3, 0.0) ? 0.0 : d4 / Math.sqrt(d2 * d3);
        return d;
    }

    public final double meanAbsoluteError() {
        return this.m_SumAbsErr / this.m_WithClass;
    }

    public final double meanPriorAbsoluteError() {
        return this.m_SumPriorAbsErr / this.m_WithClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
    }

    public final double rootMeanPriorSquaredError() {
        return Math.sqrt(this.m_SumPriorSqrErr / this.m_WithClass);
    }

    public final double rootRelativeSquaredError() {
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute entropy of class prior: class numeric!");
        }
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            d -= this.m_ClassPriors[i] / this.m_ClassPriorsSum * Utils.log2(this.m_ClassPriors[i] / this.m_ClassPriorsSum);
        }
        return d;
    }

    public final double KBInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return this.m_SumKBInfo;
    }

    public final double KBMeanInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return this.m_SumKBInfo / this.m_WithClass;
    }

    public final double KBRelativeInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return 100.0 * this.KBInformation() / this.priorEntropy();
    }

    public final double SFPriorEntropy() {
        return this.m_SumPriorEntropy;
    }

    public final double SFMeanPriorEntropy() {
        return this.m_SumPriorEntropy / this.m_WithClass;
    }

    public final double SFSchemeEntropy() {
        return this.m_SumSchemeEntropy;
    }

    public final double SFMeanSchemeEntropy() {
        return this.m_SumSchemeEntropy / this.m_WithClass;
    }

    public final double SFEntropyGain() {
        return this.m_SumPriorEntropy - this.m_SumSchemeEntropy;
    }

    public final double SFMeanEntropyGain() {
        return (this.m_SumPriorEntropy - this.m_SumSchemeEntropy) / this.m_WithClass;
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String string = "";
        double d = 0.0;
        for (int i = 0; i <= k_MarginResolution; ++i) {
            if (this.m_MarginCounts[i] != 0.0) {
                double d2 = (double)i * 2.0 / (double)k_MarginResolution - 1.0;
                string = string + Utils.doubleToString(d2, 7, 3) + ' ' + Utils.doubleToString((d += this.m_MarginCounts[i]) * 100.0 / this.m_WithClass, 7, 3) + '\n';
                continue;
            }
            if (i != 0) continue;
            string = Utils.doubleToString(-1.0, 7, 3) + ' ' + Utils.doubleToString(0.0, 7, 3) + '\n';
        }
        return string;
    }

    public String toSummaryString() {
        return this.toSummaryString("", false);
    }

    public String toSummaryString(boolean bl) {
        return this.toSummaryString("=== Summary ===\n", bl);
    }

    public String toSummaryString(String string, boolean bl) {
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "\n");
        try {
            if (this.m_WithClass > 0.0) {
                if (this.m_ClassIsNominal) {
                    stringBuffer.append("Correctly Classified Instances     ");
                    stringBuffer.append(Utils.doubleToString(this.correct(), 12, 4) + "     " + Utils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
                    stringBuffer.append("Incorrectly Classified Instances   ");
                    stringBuffer.append(Utils.doubleToString(this.incorrect(), 12, 4) + "     " + Utils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
                    stringBuffer.append("Kappa statistic                    ");
                    stringBuffer.append(Utils.doubleToString(this.kappa(), 12, 4) + "\n");
                    if (this.m_CostMatrix != null) {
                        stringBuffer.append("Total Cost                         ");
                        stringBuffer.append(Utils.doubleToString(this.totalCost(), 12, 4) + "\n");
                        stringBuffer.append("Average Cost                       ");
                        stringBuffer.append(Utils.doubleToString(this.avgCost(), 12, 4) + "\n");
                    }
                    if (bl) {
                        stringBuffer.append("K&B Relative Info Score            ");
                        stringBuffer.append(Utils.doubleToString(this.KBRelativeInformation(), 12, 4) + " %\n");
                        stringBuffer.append("K&B Information Score              ");
                        stringBuffer.append(Utils.doubleToString(this.KBInformation(), 12, 4) + " bits");
                        stringBuffer.append(Utils.doubleToString(this.KBMeanInformation(), 12, 4) + " bits/instance\n");
                    }
                } else {
                    stringBuffer.append("Correlation coefficient            ");
                    stringBuffer.append(Utils.doubleToString(this.correlationCoefficient(), 12, 4) + "\n");
                }
                if (bl) {
                    stringBuffer.append("Class complexity | order 0         ");
                    stringBuffer.append(Utils.doubleToString(this.SFPriorEntropy(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanPriorEntropy(), 12, 4) + " bits/instance\n");
                    stringBuffer.append("Class complexity | scheme          ");
                    stringBuffer.append(Utils.doubleToString(this.SFSchemeEntropy(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanSchemeEntropy(), 12, 4) + " bits/instance\n");
                    stringBuffer.append("Complexity improvement     (Sf)    ");
                    stringBuffer.append(Utils.doubleToString(this.SFEntropyGain(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanEntropyGain(), 12, 4) + " bits/instance\n");
                }
                stringBuffer.append("Mean absolute error                ");
                stringBuffer.append(Utils.doubleToString(this.meanAbsoluteError(), 12, 4) + "\n");
                stringBuffer.append("Root mean squared error            ");
                stringBuffer.append(Utils.doubleToString(this.rootMeanSquaredError(), 12, 4) + "\n");
                stringBuffer.append("Relative absolute error            ");
                stringBuffer.append(Utils.doubleToString(this.relativeAbsoluteError(), 12, 4) + " %\n");
                stringBuffer.append("Root relative squared error        ");
                stringBuffer.append(Utils.doubleToString(this.rootRelativeSquaredError(), 12, 4) + " %\n");
            }
            if (Utils.gr(this.unclassified(), 0.0)) {
                stringBuffer.append("UnClassified Instances             ");
                stringBuffer.append(Utils.doubleToString(this.unclassified(), 12, 4) + "     " + Utils.doubleToString(this.pctUnclassified(), 12, 4) + " %\n");
            }
            stringBuffer.append("Total Number of Instances          ");
            stringBuffer.append(Utils.doubleToString(this.m_WithClass, 12, 4) + "\n");
            if (this.m_MissingClass > 0.0) {
                stringBuffer.append("Ignored Class Unknown Instances            ");
                stringBuffer.append(Utils.doubleToString(this.m_MissingClass, 12, 4) + "\n");
            }
        }
        catch (Exception exception) {
            System.err.println("Arggh - Must be a bug in Evaluation class");
        }
        return stringBuffer.toString();
    }

    public String toMatrixString() throws Exception {
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String string) throws Exception {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean bl = false;
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        double d = 0.0;
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            for (n = 0; n < this.m_NumClasses; ++n) {
                double d2 = this.m_ConfusionMatrix[n2][n];
                if (d2 < 0.0) {
                    d2 *= -10.0;
                }
                if (d2 > d) {
                    d = d2;
                }
                double d3 = d2 - Math.rint(d2);
                if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                bl = true;
            }
        }
        int n3 = 1 + Math.max((int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 3 : 0)), (int)(Math.log(this.m_NumClasses) / Math.log(cArray.length)));
        stringBuffer.append(string).append("\n");
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            if (bl) {
                stringBuffer.append(" ").append(this.num2ShortID(n2, cArray, n3 - 3)).append("   ");
                continue;
            }
            stringBuffer.append(" ").append(this.num2ShortID(n2, cArray, n3));
        }
        stringBuffer.append("   <-- classified as\n");
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            for (n = 0; n < this.m_NumClasses; ++n) {
                stringBuffer.append(" ").append(Utils.doubleToString(this.m_ConfusionMatrix[n2][n], n3, bl ? 2 : 0));
            }
            stringBuffer.append(" | ").append(this.num2ShortID(n2, cArray, n3)).append(" = ").append(this.m_ClassNames[n2]).append("\n");
        }
        return stringBuffer.toString();
    }

    public String toClassDetailsString() throws Exception {
        return this.toClassDetailsString("=== Detailed Accuracy By Class ===\n");
    }

    public String toClassDetailsString(String string) throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        StringBuffer stringBuffer = new StringBuffer(string + "\nTP Rate   FP Rate" + "   Precision   Recall" + "  F-Measure   Class\n");
        for (int i = 0; i < this.m_NumClasses; ++i) {
            stringBuffer.append(Utils.doubleToString(this.truePositiveRate(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.falsePositiveRate(i), 7, 3)).append("    ");
            stringBuffer.append(Utils.doubleToString(this.precision(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.recall(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.fMeasure(i), 7, 3)).append("    ");
            stringBuffer.append(this.m_ClassNames[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public double numTruePositives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            d += this.m_ConfusionMatrix[n][i];
        }
        return d;
    }

    public double truePositiveRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) {
                d += this.m_ConfusionMatrix[n][i];
            }
            d2 += this.m_ConfusionMatrix[n][i];
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numTrueNegatives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double trueNegativeRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numFalsePositives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double falsePositiveRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numFalseNegatives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double falseNegativeRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double recall(int n) {
        return this.truePositiveRate(n);
    }

    public double precision(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) {
                d += this.m_ConfusionMatrix[i][n];
            }
            d2 += this.m_ConfusionMatrix[i][n];
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double fMeasure(int n) {
        double d;
        double d2 = this.precision(n);
        if (d2 + (d = this.recall(n)) == 0.0) {
            return 0.0;
        }
        return 2.0 * d2 * d / (d2 + d);
    }

    public void setPriors(Instances instances) throws Exception {
        if (!this.m_ClassIsNominal) {
            this.m_NumTrainClassVals = 0;
            this.m_TrainClassVals = null;
            this.m_TrainClassWeights = null;
            this.m_PriorErrorEstimator = null;
            this.m_ErrorEstimator = null;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (instance.classIsMissing()) continue;
                this.addNumericTrainClass(instance.classValue(), instance.weight());
            }
        } else {
            int n;
            for (n = 0; n < this.m_NumClasses; ++n) {
                this.m_ClassPriors[n] = 1.0;
            }
            this.m_ClassPriorsSum = this.m_NumClasses;
            for (n = 0; n < instances.numInstances(); ++n) {
                if (instances.instance(n).classIsMissing()) continue;
                int n2 = (int)instances.instance(n).classValue();
                this.m_ClassPriors[n2] = this.m_ClassPriors[n2] + instances.instance(n).weight();
                this.m_ClassPriorsSum += instances.instance(n).weight();
            }
        }
    }

    public void updatePriors(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_ClassIsNominal) {
                if (!instance.classIsMissing()) {
                    this.addNumericTrainClass(instance.classValue(), instance.weight());
                }
            } else {
                int n = (int)instance.classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Evaluation evaluation = (Evaluation)object;
        if (this.m_ClassIsNominal != evaluation.m_ClassIsNominal) {
            return false;
        }
        if (this.m_NumClasses != evaluation.m_NumClasses) {
            return false;
        }
        if (this.m_Incorrect != evaluation.m_Incorrect) {
            return false;
        }
        if (this.m_Correct != evaluation.m_Correct) {
            return false;
        }
        if (this.m_Unclassified != evaluation.m_Unclassified) {
            return false;
        }
        if (this.m_MissingClass != evaluation.m_MissingClass) {
            return false;
        }
        if (this.m_WithClass != evaluation.m_WithClass) {
            return false;
        }
        if (this.m_SumErr != evaluation.m_SumErr) {
            return false;
        }
        if (this.m_SumAbsErr != evaluation.m_SumAbsErr) {
            return false;
        }
        if (this.m_SumSqrErr != evaluation.m_SumSqrErr) {
            return false;
        }
        if (this.m_SumClass != evaluation.m_SumClass) {
            return false;
        }
        if (this.m_SumSqrClass != evaluation.m_SumSqrClass) {
            return false;
        }
        if (this.m_SumPredicted != evaluation.m_SumPredicted) {
            return false;
        }
        if (this.m_SumSqrPredicted != evaluation.m_SumSqrPredicted) {
            return false;
        }
        if (this.m_SumClassPredicted != evaluation.m_SumClassPredicted) {
            return false;
        }
        if (this.m_ClassIsNominal) {
            for (int i = 0; i < this.m_NumClasses; ++i) {
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    if (this.m_ConfusionMatrix[i][j] == evaluation.m_ConfusionMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static String printClassifications(Classifier classifier, Instances instances, String string, int n, Range range) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() != 0) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + '.');
            }
            Instances instances2 = new Instances(bufferedReader, 1);
            if (n != -1) {
                instances2.setClassIndex(n - 1);
            } else {
                instances2.setClassIndex(instances2.numAttributes() - 1);
            }
            int n2 = 0;
            while (instances2.readInstance(bufferedReader)) {
                Instance instance = instances2.instance(0);
                Instance instance2 = (Instance)instance.copy();
                instance2.setDataset(instances2);
                double d = classifier.classifyInstance(instance2);
                if (instances2.classAttribute().isNumeric()) {
                    if (Instance.isMissingValue(d)) {
                        stringBuffer.append(n2 + " missing ");
                    } else {
                        stringBuffer.append(n2 + " " + d + " ");
                    }
                    if (instance.classIsMissing()) {
                        stringBuffer.append("missing");
                    } else {
                        stringBuffer.append(instance.classValue());
                    }
                    stringBuffer.append(" " + Evaluation.attributeValuesString(instance2, range) + "\n");
                } else {
                    if (Instance.isMissingValue(d)) {
                        stringBuffer.append(n2 + " missing ");
                    } else {
                        stringBuffer.append(n2 + " " + instances2.classAttribute().value((int)d) + " ");
                    }
                    if (Instance.isMissingValue(d)) {
                        stringBuffer.append("missing ");
                    } else {
                        stringBuffer.append(classifier.distributionForInstance(instance2)[(int)d] + " ");
                    }
                    stringBuffer.append(instance.toString(instance.classIndex()) + " " + Evaluation.attributeValuesString(instance2, range) + "\n");
                }
                instances2.delete(0);
                ++n2;
            }
            bufferedReader.close();
        }
        return stringBuffer.toString();
    }

    protected static String attributeValuesString(Instance instance, Range range) {
        StringBuffer stringBuffer = new StringBuffer();
        if (range != null) {
            boolean bl = true;
            range.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!range.isInRange(i) || i == instance.classIndex()) continue;
                if (bl) {
                    stringBuffer.append("(");
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(instance.toString(i));
                bl = false;
            }
            if (!bl) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    protected static String makeOptionString(Classifier classifier) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n\nGeneral options:\n\n");
        stringBuffer.append("-t <name of training file>\n");
        stringBuffer.append("\tSets training file.\n");
        stringBuffer.append("-T <name of test file>\n");
        stringBuffer.append("\tSets test file. If missing, a cross-validation");
        stringBuffer.append(" will be performed on the training data.\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tSets index of class attribute (default: last).\n");
        stringBuffer.append("-x <number of folds>\n");
        stringBuffer.append("\tSets number of folds for cross-validation (default: 10).\n");
        stringBuffer.append("-s <random number seed>\n");
        stringBuffer.append("\tSets random number seed for cross-validation (default: 1).\n");
        stringBuffer.append("-m <name of file with cost matrix>\n");
        stringBuffer.append("\tSets file with cost matrix.\n");
        stringBuffer.append("-l <name of input file>\n");
        stringBuffer.append("\tSets model input file.\n");
        stringBuffer.append("-d <name of output file>\n");
        stringBuffer.append("\tSets model output file.\n");
        stringBuffer.append("-v\n");
        stringBuffer.append("\tOutputs no statistics for training data.\n");
        stringBuffer.append("-o\n");
        stringBuffer.append("\tOutputs statistics only, not the classifier.\n");
        stringBuffer.append("-i\n");
        stringBuffer.append("\tOutputs detailed information-retrieval");
        stringBuffer.append(" statistics for each class.\n");
        stringBuffer.append("-k\n");
        stringBuffer.append("\tOutputs information-theoretic statistics.\n");
        stringBuffer.append("-p <attribute range>\n");
        stringBuffer.append("\tOnly outputs predictions for test instances, along with attributes (0 for none).\n");
        stringBuffer.append("-r\n");
        stringBuffer.append("\tOnly outputs cumulative margin distribution.\n");
        if (classifier instanceof Sourcable) {
            stringBuffer.append("-z <class name>\n");
            stringBuffer.append("\tOnly outputs the source representation of the classifier, giving it the supplied name.\n");
        }
        if (classifier instanceof Drawable) {
            stringBuffer.append("-g\n");
            stringBuffer.append("\tOnly outputs the graph representation of the classifier.\n");
        }
        if (classifier instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + classifier.getClass().getName() + ":\n\n");
            Enumeration enumeration = classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected String num2ShortID(int n, char[] cArray, int n2) {
        int n3;
        char[] cArray2 = new char[n2];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            cArray2[n3] = cArray[n % cArray.length];
            if ((n = n / cArray.length - 1) < 0) break;
        }
        --n3;
        while (n3 >= 0) {
            cArray2[n3] = 32;
            --n3;
        }
        return new String(cArray2);
    }

    protected double[] makeDistribution(double d) {
        double[] dArray = new double[this.m_NumClasses];
        if (Instance.isMissingValue(d)) {
            return dArray;
        }
        if (this.m_ClassIsNominal) {
            dArray[(int)d] = 1.0;
        } else {
            dArray[0] = d;
        }
        return dArray;
    }

    protected void updateStatsForClassifier(double[] dArray, Instance instance) throws Exception {
        int n = (int)instance.classValue();
        double d = 1.0;
        if (!instance.classIsMissing()) {
            double d2;
            this.updateMargins(dArray, n, instance.weight());
            int n2 = -1;
            double d3 = 0.0;
            for (int i = 0; i < this.m_NumClasses; ++i) {
                if (!(dArray[i] > d3)) continue;
                n2 = i;
                d3 = dArray[i];
            }
            this.m_WithClass += instance.weight();
            if (this.m_CostMatrix != null) {
                this.m_TotalCost = n2 < 0 ? (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getMaxCost(n)) : (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getElement(n, n2));
            }
            if (n2 < 0) {
                this.m_Unclassified += instance.weight();
                return;
            }
            double d4 = Math.max(Double.MIN_VALUE, dArray[n]);
            this.m_SumKBInfo = d4 >= (d2 = Math.max(Double.MIN_VALUE, this.m_ClassPriors[n] / this.m_ClassPriorsSum)) ? (this.m_SumKBInfo += (Utils.log2(d4) - Utils.log2(d2)) * instance.weight()) : (this.m_SumKBInfo -= (Utils.log2(1.0 - d4) - Utils.log2(1.0 - d2)) * instance.weight());
            this.m_SumSchemeEntropy -= Utils.log2(d4) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(d2) * instance.weight();
            this.updateNumericScores(dArray, this.makeDistribution(instance.classValue()), instance.weight());
            double[] dArray2 = this.m_ConfusionMatrix[n];
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + instance.weight();
            if (n2 != n) {
                this.m_Incorrect += instance.weight();
            } else {
                this.m_Correct += instance.weight();
            }
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateStatsForPredictor(double d, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_WithClass += instance.weight();
            if (Instance.isMissingValue(d)) {
                this.m_Unclassified += instance.weight();
                return;
            }
            this.m_SumClass += instance.weight() * instance.classValue();
            this.m_SumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_SumClassPredicted += instance.weight() * instance.classValue() * d;
            this.m_SumPredicted += d;
            this.m_SumSqrPredicted += d * d;
            if (this.m_ErrorEstimator == null) {
                this.setNumericPriorsFromBuffer();
            }
            double d2 = Math.max(this.m_ErrorEstimator.getProbability(d - instance.classValue()), Double.MIN_VALUE);
            double d3 = Math.max(this.m_PriorErrorEstimator.getProbability(instance.classValue()), Double.MIN_VALUE);
            this.m_SumSchemeEntropy -= Utils.log2(d2) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(d3) * instance.weight();
            this.m_ErrorEstimator.addValue(d - instance.classValue(), instance.weight());
            this.updateNumericScores(this.makeDistribution(d), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateMargins(double[] dArray, int n, double d) {
        int n2;
        double d2 = dArray[n];
        double d3 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n || !(dArray[i] > d3)) continue;
            d3 = dArray[i];
        }
        double d4 = d2 - d3;
        int n3 = n2 = (int)((d4 + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n3] = this.m_MarginCounts[n3] + d;
    }

    protected void updateNumericScores(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double d7 = dArray[i] - dArray2[i];
            d2 += d7;
            d3 += Math.abs(d7);
            d4 += d7 * d7;
            d7 = this.m_ClassPriors[i] / this.m_ClassPriorsSum - dArray2[i];
            d5 += Math.abs(d7);
            d6 += d7 * d7;
        }
        this.m_SumErr += d * d2 / (double)this.m_NumClasses;
        this.m_SumAbsErr += d * d3 / (double)this.m_NumClasses;
        this.m_SumSqrErr += d * d4 / (double)this.m_NumClasses;
        this.m_SumPriorAbsErr += d * d5 / (double)this.m_NumClasses;
        this.m_SumPriorSqrErr += d * d6 / (double)this.m_NumClasses;
    }

    protected void addNumericTrainClass(double d, double d2) {
        if (this.m_TrainClassVals == null) {
            this.m_TrainClassVals = new double[100];
            this.m_TrainClassWeights = new double[100];
        }
        if (this.m_NumTrainClassVals == this.m_TrainClassVals.length) {
            double[] dArray = new double[this.m_TrainClassVals.length * 2];
            System.arraycopy(this.m_TrainClassVals, 0, dArray, 0, this.m_TrainClassVals.length);
            this.m_TrainClassVals = dArray;
            dArray = new double[this.m_TrainClassWeights.length * 2];
            System.arraycopy(this.m_TrainClassWeights, 0, dArray, 0, this.m_TrainClassWeights.length);
            this.m_TrainClassWeights = dArray;
        }
        this.m_TrainClassVals[this.m_NumTrainClassVals] = d;
        this.m_TrainClassWeights[this.m_NumTrainClassVals] = d2;
        ++this.m_NumTrainClassVals;
    }

    protected void setNumericPriorsFromBuffer() {
        double d = 0.01;
        if (this.m_NumTrainClassVals > 1) {
            double[] dArray = new double[this.m_NumTrainClassVals];
            System.arraycopy(this.m_TrainClassVals, 0, dArray, 0, this.m_NumTrainClassVals);
            int[] nArray = Utils.sort(dArray);
            double d2 = dArray[nArray[0]];
            double d3 = 0.0;
            int n = 0;
            for (int i = 1; i < dArray.length; ++i) {
                double d4 = dArray[nArray[i]];
                if (d4 == d2) continue;
                d3 += d4 - d2;
                d2 = d4;
                ++n;
            }
            if (n > 0) {
                d = d3 / (double)n;
            }
        }
        this.m_PriorErrorEstimator = new KernelEstimator(d);
        this.m_ErrorEstimator = new KernelEstimator(d);
        this.m_ClassPriorsSum = 0.0;
        this.m_ClassPriors[0] = 0.0;
        for (int i = 0; i < this.m_NumTrainClassVals; ++i) {
            this.m_ClassPriors[0] = this.m_ClassPriors[0] + this.m_TrainClassVals[i] * this.m_TrainClassWeights[i];
            this.m_ClassPriorsSum += this.m_TrainClassWeights[i];
            this.m_PriorErrorEstimator.addValue(this.m_TrainClassVals[i], this.m_TrainClassWeights[i]);
        }
    }
}

