/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClassifier
implements OptionHandler {
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_ClassifierOptions;
    protected String m_AnalysisResults;
    protected boolean m_Debug;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tFull name of the classifier analysed.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 4];
        int n = 0;
        if (this.getDebug()) {
            stringArray2[n++] = "-D";
        }
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void doTests() {
        if (this.getClassifier() == null) {
            System.out.println("\n=== No classifier set ===");
            return;
        }
        System.out.println("\n=== Check on Classifier: " + this.getClassifier().getClass().getName() + " ===\n");
        this.canTakeOptions();
        boolean bl = this.updateableClassifier();
        boolean bl2 = this.weightedInstancesHandler();
        this.testsPerClassType(false, bl, bl2);
        this.testsPerClassType(true, bl, bl2);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public static void main(String[] stringArray) {
        try {
            CheckClassifier checkClassifier = new CheckClassifier();
            try {
                checkClassifier.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\nCheckClassifier Options:\n\n";
                Enumeration enumeration = checkClassifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            checkClassifier.doTests();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    protected void testsPerClassType(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.canPredict(true, false, bl);
        boolean bl5 = this.canPredict(false, true, bl);
        if (bl4 || bl5) {
            boolean bl6;
            if (bl3) {
                this.instanceWeights(bl4, bl5, bl);
            }
            if (!bl) {
                this.canHandleNClasses(bl4, bl5, 4);
            }
            this.canHandleZeroTraining(bl4, bl5, bl);
            boolean bl7 = this.canHandleMissing(bl4, bl5, bl, true, false, 20);
            if (bl7) {
                this.canHandleMissing(bl4, bl5, bl, true, false, 100);
            }
            if (bl6 = this.canHandleMissing(bl4, bl5, bl, false, true, 20)) {
                this.canHandleMissing(bl4, bl5, bl, false, true, 100);
            }
            this.correctBuildInitialisation(bl4, bl5, bl);
            this.datasetIntegrity(bl4, bl5, bl, bl7, bl6);
            this.doesntUseTestClassVal(bl4, bl5, bl);
            if (bl2) {
                this.updatingEquality(bl4, bl5, bl);
            }
        }
    }

    protected boolean canTakeOptions() {
        System.out.print("options...");
        if (this.m_Classifier instanceof OptionHandler) {
            System.out.println("yes");
            if (this.m_Debug) {
                System.out.println("\n=== Full report ===");
                Enumeration enumeration = this.m_Classifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    System.out.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                System.out.println("\n");
            }
            return true;
        }
        System.out.println("no");
        return false;
    }

    protected boolean updateableClassifier() {
        System.out.print("updateable classifier...");
        if (this.m_Classifier instanceof UpdateableClassifier) {
            System.out.println("yes");
            return true;
        }
        System.out.println("no");
        return false;
    }

    protected boolean weightedInstancesHandler() {
        System.out.print("weighted instances classifier...");
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            System.out.println("yes");
            return true;
        }
        System.out.println("no");
        return false;
    }

    protected boolean canPredict(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        int n = 20;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        return this.runBasicTest(bl, bl2, bl3, n4, bl4, bl5, n, n2, n3, fastVector);
    }

    protected boolean canHandleNClasses(boolean bl, boolean bl2, int n) {
        System.out.print("more than two class problems");
        this.printAttributeSummary(bl, bl2, false);
        System.out.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("number");
        fastVector.addElement("class");
        int n2 = 20;
        int n3 = 20;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        return this.runBasicTest(bl, bl2, false, n4, bl3, bl4, n2, n3, n, fastVector);
    }

    protected boolean canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n = 0;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        return this.runBasicTest(bl, bl2, bl3, n4, bl4, bl5, n, n2, n3, fastVector);
    }

    protected boolean correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("correct initialisation during buildClassifier");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        int n = 20;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        Instances instances = null;
        Instances instances2 = null;
        Instances instances3 = null;
        Instances instances4 = null;
        Classifier classifier = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        Evaluation evaluation3 = null;
        boolean bl6 = false;
        int n5 = 0;
        try {
            instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            instances3 = this.makeTestDataset(84, n, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            instances4 = this.makeTestDataset(48, n2, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
                instances3.deleteAttributeAt(0);
                instances4.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl4, bl5);
                this.addMissing(instances2, Math.min(n4, 50), bl4, bl5);
                this.addMissing(instances3, n4, bl4, bl5);
                this.addMissing(instances4, Math.min(n4, 50), bl4, bl5);
            }
            classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            evaluation3 = new Evaluation(instances3);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            n5 = 0;
            classifier.buildClassifier(instances);
            bl6 = true;
            if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)) {
                throw new Exception("Scheme performs worse than ZeroR");
            }
            n5 = 1;
            bl6 = false;
            classifier.buildClassifier(instances3);
            bl6 = true;
            if (!this.testWRTZeroR(classifier, evaluation3, instances3, instances4)) {
                throw new Exception("Scheme performs worse than ZeroR");
            }
            n5 = 2;
            bl6 = false;
            classifier.buildClassifier(instances);
            bl6 = true;
            if (!this.testWRTZeroR(classifier, evaluation2, instances, instances2)) {
                throw new Exception("Scheme performs worse than ZeroR");
            }
            n5 = 3;
            if (!evaluation.equals(evaluation2)) {
                if (this.m_Debug) {
                    System.out.println("\n=== Full report ===\n" + evaluation.toSummaryString("\nFirst buildClassifier()", true) + "\n\n");
                    System.out.println(evaluation2.toSummaryString("\nSecond buildClassifier()", true) + "\n\n");
                }
                throw new Exception("Results differ between buildClassifier calls");
            }
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            String string = exception.getMessage().toLowerCase();
            if (string.indexOf("worse than zeror") >= 0) {
                System.out.println("warning: performs worse than ZeroR");
            } else {
                System.out.println("no");
            }
            if (this.m_Debug) {
                System.out.println("\n=== Full Report ===");
                System.out.print("Problem during");
                if (bl6) {
                    System.out.print(" testing");
                } else {
                    System.out.print(" training");
                }
                switch (n5) {
                    case 0: {
                        System.out.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        System.out.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        System.out.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        System.out.print(", comparing results from builds of dataset 1");
                    }
                }
                System.out.println(": " + exception.getMessage() + "\n");
                System.out.println("here are the datasets:\n");
                System.out.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                System.out.println("=== Test1 Dataset ===\n" + instances2.toString() + "\n\n");
                System.out.println("=== Train2 Dataset ===\n" + instances3.toString() + "\n");
                System.out.println("=== Test2 Dataset ===\n" + instances4.toString() + "\n\n");
            }
            return false;
        }
    }

    protected boolean canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        if (n == 100) {
            System.out.print("100% ");
        }
        System.out.print("missing");
        if (bl4) {
            System.out.print(" predictor");
            if (bl5) {
                System.out.print(" and");
            }
        }
        if (bl5) {
            System.out.print(" class");
        }
        System.out.print(" values");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n2 = 20;
        int n3 = 20;
        int n4 = 2;
        return this.runBasicTest(bl, bl2, bl3, n, bl4, bl5, n2, n3, n4, fastVector);
    }

    protected boolean updatingEquality(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        int n = 20;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        Instances instances = null;
        Instances instances2 = null;
        Classifier[] classifierArray = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        boolean bl6 = false;
        try {
            instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl4, bl5);
                this.addMissing(instances2, Math.min(n4, 50), bl4, bl5);
            }
            classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            classifierArray[0].buildClassifier(instances);
            this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            classifierArray[1].buildClassifier(new Instances(instances, 0));
            for (int i = 0; i < instances.numInstances(); ++i) {
                ((UpdateableClassifier)((Object)classifierArray[1])).updateClassifier(instances.instance(i));
            }
            bl6 = true;
            this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
            if (!evaluation.equals(evaluation2)) {
                System.out.println("no");
                if (this.m_Debug) {
                    System.out.println("\n=== Full Report ===");
                    System.out.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    System.out.println("Here are the results:\n");
                    System.out.println(evaluation.toSummaryString("\nbatch built results\n", true));
                    System.out.println(evaluation2.toSummaryString("\nincrementally built results\n", true));
                    System.out.println("Here are the datasets:\n");
                    System.out.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                    System.out.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                }
                return false;
            }
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            System.out.print("Problem during");
            if (bl6) {
                System.out.print(" testing");
            } else {
                System.out.print(" training");
            }
            System.out.println(": " + exception.getMessage() + "\n");
            return false;
        }
    }

    protected boolean doesntUseTestClassVal(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("classifier ignores test instance class vals");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        int n = 40;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        Instances instances = null;
        Instances instances2 = null;
        Classifier[] classifierArray = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        boolean bl6 = false;
        try {
            instances = this.makeTestDataset(43, n, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            instances2 = this.makeTestDataset(24, n2, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl4, bl5);
                this.addMissing(instances2, Math.min(n4, 50), bl4, bl5);
            }
            classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            classifierArray[0].buildClassifier(instances);
            classifierArray[1].buildClassifier(instances);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance = instances2.instance(i);
                Instance instance2 = (Instance)instance.copy();
                instance2.setDataset(instances2);
                instance2.setClassMissing();
                double[] dArray = classifierArray[0].distributionForInstance(instance);
                double[] dArray2 = classifierArray[1].distributionForInstance(instance2);
                for (int j = 0; j < dArray.length; ++j) {
                    if (dArray[j] == dArray2[j]) continue;
                    throw new Exception("Prediction different for instance " + (i + 1));
                }
            }
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            System.out.println("no");
            if (this.m_Debug) {
                System.out.println("\n=== Full Report ===");
                if (bl6) {
                    System.out.println("Results differ between non-missing and missing test class values.");
                } else {
                    System.out.print("Problem during testing");
                    System.out.println(": " + exception.getMessage() + "\n");
                }
                System.out.println("Here are the datasets:\n");
                System.out.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                System.out.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    System.out.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                System.out.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                System.out.println("(test weights all 1.0\n");
            }
            return false;
        }
    }

    protected boolean instanceWeights(boolean bl, boolean bl2, boolean bl3) {
        System.out.print("classifier uses instance weights");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        int n = 40;
        int n2 = 20;
        int n3 = 2;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        Instances instances = null;
        Instances instances2 = null;
        Classifier[] classifierArray = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        boolean bl6 = false;
        boolean bl7 = false;
        try {
            instances = this.makeTestDataset(43, n, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            instances2 = this.makeTestDataset(24, n2, bl ? 3 : 0, bl2 ? 2 : 0, n3, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl4, bl5);
                this.addMissing(instances2, Math.min(n4, 50), bl4, bl5);
            }
            classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            classifierArray[0].buildClassifier(instances);
            this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            for (int i = 0; i < instances.numInstances(); ++i) {
                instances.instance(i).setWeight(0.0);
            }
            Random random = new Random(1L);
            for (int i = 0; i < instances.numInstances() / 2; ++i) {
                int n5 = Math.abs(random.nextInt()) % instances.numInstances();
                int n6 = Math.abs(random.nextInt()) % 10 + 1;
                instances.instance(n5).setWeight(n6);
            }
            classifierArray[1].buildClassifier(instances);
            bl6 = true;
            this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
            if (evaluation.equals(evaluation2)) {
                bl7 = true;
                throw new Exception("evalFail");
            }
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            System.out.println("no");
            if (this.m_Debug) {
                System.out.println("\n=== Full Report ===");
                if (bl7) {
                    System.out.println("Results don't differ between non-weighted and weighted instance models.");
                    System.out.println("Here are the results:\n");
                    System.out.println(evaluation.toSummaryString("\nboth methods\n", true));
                } else {
                    System.out.print("Problem during");
                    if (bl6) {
                        System.out.print(" testing");
                    } else {
                        System.out.print(" training");
                    }
                    System.out.println(": " + exception.getMessage() + "\n");
                }
                System.out.println("Here are the datasets:\n");
                System.out.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                System.out.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    System.out.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                System.out.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                System.out.println("(test weights all 1.0\n");
            }
            return false;
        }
    }

    protected boolean datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        System.out.print("classifier doesn't alter original datasets");
        this.printAttributeSummary(bl, bl2, bl3);
        System.out.print("...");
        int n = 20;
        int n2 = 20;
        int n3 = 2;
        int n4 = 20;
        Instances instances = null;
        Instances instances2 = null;
        Classifier classifier = null;
        Evaluation evaluation = null;
        boolean bl6 = false;
        try {
            instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, n3, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl4, bl5);
                this.addMissing(instances2, Math.min(n4, 50), bl4, bl5);
            }
            classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
            evaluation = new Evaluation(instances);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            Instances instances3 = new Instances(instances);
            Instances instances4 = new Instances(instances2);
            classifier.buildClassifier(instances3);
            this.compareDatasets(instances, instances3);
            bl6 = true;
            this.testWRTZeroR(classifier, evaluation, instances3, instances4);
            this.compareDatasets(instances2, instances4);
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            System.out.println("no");
            if (this.m_Debug) {
                System.out.println("\n=== Full Report ===");
                System.out.print("Problem during");
                if (bl6) {
                    System.out.print(" testing");
                } else {
                    System.out.print(" training");
                }
                System.out.println(": " + exception.getMessage() + "\n");
                System.out.println("Here are the datasets:\n");
                System.out.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                System.out.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
            return false;
        }
    }

    protected boolean runBasicTest(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, boolean bl5, int n2, int n3, int n4, FastVector fastVector) {
        Instances instances = null;
        Instances instances2 = null;
        Classifier classifier = null;
        Evaluation evaluation = null;
        boolean bl6 = false;
        try {
            instances = this.makeTestDataset(42, n2, bl ? 2 : 0, bl2 ? 1 : 0, n4, bl3);
            instances2 = this.makeTestDataset(24, n3, bl ? 2 : 0, bl2 ? 1 : 0, n4, bl3);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n > 0) {
                this.addMissing(instances, n, bl4, bl5);
                this.addMissing(instances2, Math.min(n, 50), bl4, bl5);
            }
            classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
            evaluation = new Evaluation(instances);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            classifier.buildClassifier(instances);
            bl6 = true;
            if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)) {
                throw new Exception("Scheme performs worse than ZeroR");
            }
            System.out.println("yes");
            return true;
        }
        catch (Exception exception) {
            int n5;
            boolean bl7 = false;
            String string = exception.getMessage().toLowerCase();
            if (string.indexOf("worse than zeror") >= 0) {
                System.out.println("warning: performs worse than ZeroR");
            } else {
                for (n5 = 0; n5 < fastVector.size(); ++n5) {
                    if (string.indexOf((String)fastVector.elementAt(n5)) < 0) continue;
                    bl7 = true;
                }
                System.out.println("no" + (bl7 ? " (OK error message)" : ""));
            }
            if (this.m_Debug) {
                System.out.println("\n=== Full Report ===");
                System.out.print("Problem during");
                if (bl6) {
                    System.out.print(" testing");
                } else {
                    System.out.print(" training");
                }
                System.out.println(": " + exception.getMessage() + "\n");
                if (!bl7) {
                    if (fastVector.size() > 0) {
                        System.out.print("Error message doesn't mention ");
                        for (n5 = 0; n5 < fastVector.size(); ++n5) {
                            if (n5 != 0) {
                                System.out.print(" or ");
                            }
                            System.out.print('\"' + (String)fastVector.elementAt(n5) + '\"');
                        }
                    }
                    System.out.println("here are the datasets:\n");
                    System.out.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                    System.out.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                }
            }
            return false;
        }
    }

    protected boolean testWRTZeroR(Classifier classifier, Evaluation evaluation, Instances instances, Instances instances2) throws Exception {
        evaluation.evaluateModel(classifier, instances2);
        try {
            ZeroR zeroR = new ZeroR();
            ((Classifier)zeroR).buildClassifier(instances);
            Evaluation evaluation2 = new Evaluation(instances);
            evaluation2.evaluateModel(zeroR, instances2);
            return Utils.grOrEq(evaluation2.errorRate(), evaluation.errorRate());
        }
        catch (Exception exception) {
            throw new Error("Problem determining ZeroR performance: " + exception.getMessage());
        }
    }

    protected void compareDatasets(Instances instances, Instances instances2) throws Exception {
        if (!instances2.equalHeaders(instances)) {
            throw new Exception("header has been modified");
        }
        if (instances2.numInstances() != instances.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Instance instance2 = instances2.instance(i);
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j) ? !instance2.isMissing(j) : instance.value(j) != instance2.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (instance.weight() == instance2.weight()) continue;
                throw new Exception("instance weights have changed");
            }
        }
    }

    protected void addMissing(Instances instances, int n, boolean bl, boolean bl2) {
        int n2 = instances.classIndex();
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if ((j != n2 || !bl2) && (j == n2 || !bl) || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, boolean bl) throws Exception {
        int n6;
        int n7 = n3 + n4 + 1;
        Random random = new Random(n);
        FastVector fastVector = new FastVector(n7);
        for (n6 = 0; n6 < n3; ++n6) {
            FastVector fastVector2 = new FastVector(n6 + 1);
            for (int i = 0; i <= n6; ++i) {
                fastVector2.addElement("a" + (n6 + 1) + "l" + (i + 1));
            }
            fastVector.addElement(new Attribute("Nominal" + (n6 + 1), fastVector2));
        }
        for (n6 = 0; n6 < n4; ++n6) {
            fastVector.addElement(new Attribute("Numeric" + (n6 + 1)));
        }
        if (bl) {
            fastVector.addElement(new Attribute("Class"));
        } else {
            FastVector fastVector3 = new FastVector();
            for (int i = 0; i < n5; ++i) {
                fastVector3.addElement("cl" + (i + 1));
            }
            fastVector.addElement(new Attribute("Class", fastVector3));
        }
        Instances instances = new Instances("CheckSet", fastVector, n2);
        instances.setClassIndex(instances.numAttributes() - 1);
        for (int i = 0; i < n2; ++i) {
            Instance instance = new Instance(n7);
            instance.setDataset(instances);
            if (bl) {
                instance.setClassValue((double)random.nextFloat() * 0.25 + (double)(Math.abs(random.nextInt()) % Math.max(2, n3)));
            } else {
                instance.setClassValue(Math.abs(random.nextInt()) % instances.numClasses());
            }
            double d = instance.classValue();
            double d2 = 0.0;
            block10: for (int j = 0; j < n7 - 1; ++j) {
                switch (instances.attribute(j).type()) {
                    case 0: {
                        d2 = d * 4.0 + (double)(random.nextFloat() * 1.0f) - 0.5;
                        instance.setValue(j, d2);
                        continue block10;
                    }
                    case 1: {
                        d2 = (double)random.nextFloat() < 0.2 ? (double)(Math.abs(random.nextInt()) % instances.attribute(j).numValues()) : (double)((int)d % instances.attribute(j).numValues());
                        instance.setValue(j, d2);
                        continue block10;
                    }
                    case 2: {
                        System.err.println("Huh? this bit isn't implemented yet");
                    }
                }
            }
            instances.add(instance);
        }
        return instances;
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            System.out.print(" (numeric class,");
        } else {
            System.out.print(" (nominal class,");
        }
        if (bl2) {
            System.out.print(" numeric");
            if (bl) {
                System.out.print(" &");
            }
        }
        if (bl) {
            System.out.print(" nominal");
        }
        System.out.print(" predictors)");
    }
}

