/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Vector;
import sun.tools.java.BinaryClass;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.javap.JavaPBinaryCode;
import sun.tools.javap.JavaPEnvironment;

class JavaPClassPrinter
implements Constants {
    private BinaryClass cdef;
    private JavaPEnvironment env;
    private PrintWriter output;
    private Vector codesVec;
    private int depth;

    JavaPClassPrinter(BinaryClass binaryClass, JavaPEnvironment javaPEnvironment, int n) {
        this.cdef = binaryClass;
        this.env = javaPEnvironment;
        this.output = javaPEnvironment.output;
        this.depth = n;
    }

    JavaPClassPrinter(BinaryClass binaryClass, JavaPEnvironment javaPEnvironment) {
        this(binaryClass, javaPEnvironment, 0);
    }

    JavaPBinaryCode codeFor(MemberDefinition memberDefinition) {
        byte[] byArray = ((BinaryMember)memberDefinition).getAttribute(JavaPEnvironment.idCode);
        if (byArray != null) {
            BinaryConstantPool binaryConstantPool = this.cdef.getConstants();
            return new JavaPBinaryCode(byArray, binaryConstantPool, this.env, memberDefinition);
        }
        return null;
    }

    public void printClassHeader() {
        ClassDeclaration[] classDeclarationArray;
        String string;
        boolean bl = !this.cdef.isInterface();
        int n = this.cdef.getModifiers() & 0xFFFFFFDF;
        if (!bl) {
            n &= 0xFFFFFBFF;
        }
        if ((string = Modifier.toString(n)).length() > 0) {
            this.output.print(string + " ");
        }
        if (bl) {
            this.output.print("class ");
        }
        this.output.print(this.cdef.getName() + " ");
        if (bl && this.cdef.getSuperClass() != null) {
            this.output.print("extends " + this.cdef.getSuperClass().getName() + " ");
        }
        if ((classDeclarationArray = this.cdef.getInterfaces()).length > 0) {
            this.output.print(bl ? "implements " : "extends ");
            int n2 = 0;
            while (n2 < classDeclarationArray.length) {
                if (n2 > 0) {
                    this.output.print(", ");
                }
                this.output.print(classDeclarationArray[n2].getName());
                ++n2;
            }
            this.output.print(" ");
        }
        if (this.env.showBackwardCompatible && (this.cdef.getModifiers() & 0x20) != 0) {
            this.output.println();
            this.output.println("    /* ACC_SUPER bit set */");
        }
        if ((this.cdef.getModifiers() & 0x20) == 0) {
            this.output.println();
            this.output.println("    /* ACC_SUPER bit NOT set */");
        }
    }

    public void printMemberDefinition(MemberDefinition memberDefinition) {
        ClassDeclaration[] classDeclarationArray;
        String string = Modifier.toString(memberDefinition.getModifiers());
        if (string.length() > 0) {
            this.output.print(string + " ");
        }
        this.output.print(this.convertMemberDefinition(memberDefinition));
        if (!this.env.showBackwardCompatible && (classDeclarationArray = memberDefinition.getExceptions(this.env)) != null && classDeclarationArray.length > 0) {
            this.output.print(" throws ");
            int n = 0;
            while (n < classDeclarationArray.length) {
                if (n != 0) {
                    this.output.print(", ");
                }
                this.output.print(classDeclarationArray[n].getName());
                ++n;
            }
        }
        this.output.println(";");
    }

    public String convertMemberDefinition(MemberDefinition memberDefinition) {
        if (memberDefinition.isConstructor()) {
            Identifier identifier = memberDefinition.getDefiningClassDeclaration().getName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Identifier.lookup(identifier.getQualifier(), identifier.getFlatName()));
            stringBuffer.append('(');
            Type[] typeArray = memberDefinition.getType().getArgumentTypes();
            int n = 0;
            while (n < typeArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (memberDefinition.isInitializer()) {
            return "{}";
        }
        return memberDefinition.toString();
    }

    private void printIndent(int n) {
        int n2 = n;
        while (n2 >= 0) {
            this.output.print("    ");
            --n2;
        }
    }

    public void printMembers() throws IOException {
        MemberDefinition memberDefinition = this.cdef.getFirstMember();
        while (memberDefinition != null) {
            if (this.env.showAccess.checkMember(memberDefinition)) {
                Constants constants;
                this.printIndent(this.depth);
                if (memberDefinition.isInnerClass()) {
                    constants = (BinaryClass)memberDefinition.getInnerClass();
                    JavaPClassPrinter javaPClassPrinter = new JavaPClassPrinter((BinaryClass)constants, this.env, this.depth + 1);
                    javaPClassPrinter.print();
                } else {
                    this.printMemberDefinition(memberDefinition);
                    if (this.env.showInternalSigs) {
                        this.output.println("\t/*   " + memberDefinition.getType().getTypeSignature() + "   */");
                    }
                    if (this.env.showVerbose && (constants = this.codeFor(memberDefinition)) != null) {
                        ((JavaPBinaryCode)constants).printVerboseHeader();
                    }
                }
            }
            memberDefinition = memberDefinition.getNextMember();
        }
    }

    public void print() throws IOException {
        Object object = this.cdef.getSource();
        if (this.depth == 0) {
            if (object == null) {
                this.output.print("No source");
            } else {
                this.output.print("Compiled from ");
                this.output.println((String)object);
            }
        }
        this.printClassHeader();
        this.output.println("{");
        this.printMembers();
        if (this.env.showBackwardCompatible) {
            JavaPBinaryCode javaPBinaryCode;
            Codes codes;
            if (this.env.showDisassembled) {
                codes = new Codes();
                while ((javaPBinaryCode = codes.next()) != null) {
                    javaPBinaryCode.printCodeSequence();
                    javaPBinaryCode.printExceptionTable();
                }
            }
            if (this.env.showLineAndLocal) {
                this.output.println();
                codes = new Codes();
                while ((javaPBinaryCode = codes.next()) != null) {
                    javaPBinaryCode.printLineNumberTable();
                }
                this.output.println();
                Codes codes2 = new Codes();
                while ((javaPBinaryCode = codes2.next()) != null) {
                    javaPBinaryCode.printLocalVariableTable();
                }
            }
            this.output.println();
            this.printIndent(this.depth - 1);
            this.output.println("}");
        } else {
            this.printIndent(this.depth - 1);
            this.output.println("}");
            if (this.env.showDisassembled || this.env.showLineAndLocal) {
                JavaPBinaryCode javaPBinaryCode;
                Codes codes = new Codes();
                while ((javaPBinaryCode = codes.next()) != null) {
                    if (this.env.showDisassembled) {
                        javaPBinaryCode.printCodeSequence();
                        javaPBinaryCode.printExceptionTable();
                    }
                    if (!this.env.showLineAndLocal) continue;
                    javaPBinaryCode.printLineNumberTable();
                    javaPBinaryCode.printLocalVariableTable();
                }
            }
        }
    }

    private class Codes {
        private int index;

        Codes() {
            if (JavaPClassPrinter.this.codesVec == null) {
                JavaPClassPrinter.this.codesVec = new Vector();
                MemberDefinition memberDefinition = JavaPClassPrinter.this.cdef.getFirstMember();
                while (memberDefinition != null) {
                    JavaPBinaryCode javaPBinaryCode = JavaPClassPrinter.this.codeFor(memberDefinition);
                    if (javaPBinaryCode != null) {
                        JavaPClassPrinter.this.codesVec.addElement(javaPBinaryCode);
                    }
                    memberDefinition = memberDefinition.getNextMember();
                }
            }
            this.index = 0;
        }

        JavaPBinaryCode next() {
            if (this.index < JavaPClassPrinter.this.codesVec.size()) {
                return (JavaPBinaryCode)JavaPClassPrinter.this.codesVec.elementAt(this.index++);
            }
            return null;
        }
    }
}

