/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Mirror;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.Collection;
import java.util.Iterator;

abstract class MirrorImpl
implements Mirror {
    protected VirtualMachineImpl vm;

    MirrorImpl(VirtualMachine virtualMachine) {
        this.vm = (VirtualMachineImpl)virtualMachine;
    }

    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Mirror) {
            Mirror mirror = (Mirror)object;
            return this.vm.equals(mirror.virtualMachine());
        }
        return false;
    }

    public int hashCode() {
        return this.vm.hashCode();
    }

    void validateMirror(Mirror mirror) {
        if (!this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrorOrNull(Mirror mirror) {
        if (mirror != null && !this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrors(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MirrorImpl mirrorImpl = (MirrorImpl)iterator.next();
            if (this.vm.equals(mirrorImpl.vm)) continue;
            throw new VMMismatchException(mirrorImpl.toString());
        }
    }

    void validateMirrorsOrNulls(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MirrorImpl mirrorImpl = (MirrorImpl)iterator.next();
            if (mirrorImpl == null || this.vm.equals(mirrorImpl.vm)) continue;
            throw new VMMismatchException(mirrorImpl.toString());
        }
    }
}

