/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlStandardWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allclasses-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allclasses-noframe.html";
    protected IndexBuilder indexbuilder;

    public AllClassesFrameWriter(ConfigurationStandard configurationStandard, String string, IndexBuilder indexBuilder) throws IOException {
        super(configurationStandard, string);
        this.indexbuilder = indexBuilder;
    }

    public static void generate(ConfigurationStandard configurationStandard, IndexBuilder indexBuilder) {
        String string = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllClassesFrameWriter allClassesFrameWriter = new AllClassesFrameWriter(configurationStandard, string, indexBuilder);
            allClassesFrameWriter.generateAllClassesFile(true);
            allClassesFrameWriter.close();
            string = OUTPUT_FILE_NAME_NOFRAMES;
            allClassesFrameWriter = new AllClassesFrameWriter(configurationStandard, string, indexBuilder);
            allClassesFrameWriter.generateAllClassesFile(false);
            allClassesFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateAllClassesFile(boolean bl) throws IOException {
        String string = this.getText("doclet.All_Classes");
        this.printHeader(string);
        this.printAllClassesTableHeader();
        this.printAllClasses(bl);
        this.printAllClassesTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllClasses(boolean bl) {
        int n = 0;
        while (n < this.indexbuilder.elements().length) {
            Character c = (Character)this.indexbuilder.elements()[n];
            this.generateContents(this.indexbuilder.getMemberList(c), bl);
            ++n;
        }
    }

    protected void generateContents(List list, boolean bl) {
        int n = 0;
        while (n < list.size()) {
            ClassDoc classDoc = (ClassDoc)list.get(n);
            if (Util.isCoreClass(classDoc)) {
                String string = this.italicsClassName(classDoc, false);
                if (bl) {
                    this.printTargetHyperLink(this.pathToClass(classDoc), "classFrame", string);
                } else {
                    this.printTargetHyperLink(this.pathToClass(classDoc), "", string);
                }
                this.br();
            }
            ++n;
        }
    }

    protected void printAllClassesTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Classes");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllClassesTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

