/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.MessageRetriever;
import com.sun.tools.doclets.Taglet;
import com.sun.tools.doclets.standard.tags.DocRootTaglet;
import com.sun.tools.doclets.standard.tags.InheritDocTaglet;
import com.sun.tools.doclets.standard.tags.ParamTaglet;
import com.sun.tools.doclets.standard.tags.ReturnTaglet;
import com.sun.tools.doclets.standard.tags.SeeTaglet;
import com.sun.tools.doclets.standard.tags.SimpleTaglet;
import com.sun.tools.doclets.standard.tags.ThrowsTaglet;
import com.sun.tools.doclets.standard.tags.ValueTaglet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TagletManager {
    private LinkedHashMap customTags;
    private Taglet[] packageTags;
    private Taglet[] typeTags;
    private Taglet[] fieldTags;
    private Taglet[] constructorTags;
    private Taglet[] methodTags;
    private Taglet[] overviewTags;
    private Taglet[] inlineTags;
    private MessageRetriever message;
    private Set standardTags;
    private Set standardTagsLowercase;
    private Set overridenStandardTags = new HashSet();
    private Set potentiallyConflictingTags = new HashSet();
    private Set unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;

    public TagletManager(boolean bl, boolean bl2, boolean bl3, MessageRetriever messageRetriever) {
        this.standardTags = new HashSet();
        this.standardTagsLowercase = new HashSet();
        this.unseenCustomTags = new HashSet();
        this.customTags = new LinkedHashMap();
        this.nosince = bl;
        this.showversion = bl2;
        this.showauthor = bl3;
        this.message = messageRetriever;
        this.initStandardTags();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet taglet) {
        if (taglet != null) {
            String string = taglet.getName();
            if (this.customTags.containsKey(string)) {
                this.customTags.remove(string);
            }
            this.customTags.put(string, taglet);
            this.checkTagName(string);
        }
    }

    public void addCustomTag(String string, String string2) {
        block3: {
            try {
                Taglet taglet;
                Class<?> clazz = null;
                String string3 = null;
                string3 = this.appendPath(System.getProperty("env.class.path"), string3);
                string3 = this.appendPath(System.getProperty("java.class.path"), string3);
                string3 = this.appendPath(string2, string3);
                URLClassLoader uRLClassLoader = new URLClassLoader(TagletManager.pathToURLs(string3));
                clazz = uRLClassLoader.loadClass(string);
                Method method = clazz.getMethod("register", Class.forName("java.util.Map"));
                Object[] objectArray = this.customTags.values().toArray();
                Taglet taglet2 = objectArray != null && objectArray.length > 0 ? (Taglet)objectArray[objectArray.length - 1] : null;
                int n = this.customTags.size();
                method.invoke(null, this.customTags);
                objectArray = this.customTags.values().toArray();
                Taglet taglet3 = taglet = objectArray != null && objectArray.length > 0 ? (Taglet)objectArray[objectArray.length - 1] : null;
                if (taglet2 == taglet) break block3;
                this.message.notice("doclet.Notice_taglet_registered", string);
                if (taglet != null) {
                    this.checkTagName(taglet.getName());
                }
            }
            catch (Exception exception) {
                this.message.error("doclet.Error_taglet_not_registered", exception.getClass().getName(), string);
            }
        }
    }

    private String appendPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null ? "." : string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    private static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = TagletManager.fileToURL(new File(stringTokenizer.nextToken()));
            if (object == null) continue;
            uRLArray[n++] = object;
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    public void addNewSimpleCustomTag(String string, String string2, String string3) {
        if (string == null || string3 == null) {
            return;
        }
        Taglet taglet = (Taglet)this.customTags.get(string);
        string3 = string3.toLowerCase();
        if (taglet == null || string2 != null) {
            this.customTags.remove(string);
            this.customTags.put(string, new SimpleTaglet(string, string2, string3));
            if (string3 != null && string3.indexOf(120) == -1) {
                this.checkTagName(string);
            }
        } else {
            this.customTags.remove(string);
            this.customTags.put(string, taglet);
        }
    }

    private void checkTagName(String string) {
        if (this.standardTags.contains(string)) {
            this.overridenStandardTags.add(string);
        } else {
            if (string.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(string);
            }
            this.unseenCustomTags.add(string);
        }
    }

    public void seenCustomTag(String string) {
        this.unseenCustomTags.remove(string);
    }

    public void checkTags(Doc doc, Tag[] tagArray, boolean bl) {
        if (tagArray == null) {
            return;
        }
        int n = 0;
        while (n < tagArray.length) {
            String string = tagArray[n].name();
            if (string.length() > 0 && string.charAt(0) == '@') {
                string = string.substring(1, string.length());
            }
            if (!this.standardTags.contains(string) && !this.customTags.containsKey(string)) {
                if (this.standardTagsLowercase.contains(string.toLowerCase())) {
                    this.message.warning(tagArray[n].position(), "doclet.UnknownTagLowercase", tagArray[n].name());
                } else {
                    this.message.warning(tagArray[n].position(), "doclet.UnknownTag", tagArray[n].name());
                }
            } else {
                Taglet taglet = (Taglet)this.customTags.get(string);
                if (taglet != null) {
                    if (bl) {
                        if (!taglet.isInlineTag()) {
                            this.printTagMisuseWarn(taglet, tagArray[n], "inline");
                        }
                    } else if (doc instanceof RootDoc && !taglet.inOverview()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "overview");
                    } else if (doc instanceof PackageDoc && !taglet.inPackage()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "package");
                    } else if (doc instanceof ClassDoc && !taglet.inType()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "class");
                    } else if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "constructor");
                    } else if (doc instanceof FieldDoc && !taglet.inField()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "field");
                    } else if (doc instanceof MethodDoc && !taglet.inMethod()) {
                        this.printTagMisuseWarn(taglet, tagArray[n], "method");
                    }
                }
            }
            ++n;
        }
    }

    private void printTagMisuseWarn(Taglet taglet, Tag tag, String string) {
        String[] stringArray;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            linkedHashSet.add("overview");
        }
        if (taglet.inPackage()) {
            linkedHashSet.add("package");
        }
        if (taglet.inType()) {
            linkedHashSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            linkedHashSet.add("constructor");
        }
        if (taglet.inField()) {
            linkedHashSet.add("field");
        }
        if (taglet.inMethod()) {
            linkedHashSet.add("method");
        }
        if (taglet.isInlineTag()) {
            linkedHashSet.add("inline text");
        }
        if ((stringArray = linkedHashSet.toArray(new String[0])) == null || stringArray.length == 0) {
            return;
        }
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[n];
            ++n;
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), string, string2);
    }

    public Taglet[] getPackageCustomTags() {
        if (this.packageTags == null) {
            this.initCustomTagArrays();
        }
        return this.packageTags;
    }

    public Taglet[] getTypeCustomTags() {
        if (this.typeTags == null) {
            this.initCustomTagArrays();
        }
        return this.typeTags;
    }

    public Taglet[] getInlineCustomTags() {
        if (this.inlineTags == null) {
            this.initCustomTagArrays();
        }
        return this.inlineTags;
    }

    public Taglet[] getFieldCustomTags() {
        if (this.fieldTags == null) {
            this.initCustomTagArrays();
        }
        return this.fieldTags;
    }

    public Taglet[] getConstructorCustomTags() {
        if (this.constructorTags == null) {
            this.initCustomTagArrays();
        }
        return this.constructorTags;
    }

    public Taglet[] getMethodCustomTags() {
        if (this.methodTags == null) {
            this.initCustomTagArrays();
        }
        return this.methodTags;
    }

    public Taglet[] getOverviewCustomTags() {
        if (this.overviewTags == null) {
            this.initCustomTagArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagArrays() {
        Iterator iterator = this.customTags.values().iterator();
        Vector<Taglet> vector = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector2 = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector3 = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector4 = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector5 = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector6 = new Vector<Taglet>(this.customTags.size());
        Vector<Taglet> vector7 = new Vector<Taglet>(this.customTags.size());
        while (iterator.hasNext()) {
            Taglet taglet = (Taglet)iterator.next();
            if (taglet.inPackage()) {
                vector.add(taglet);
            }
            if (taglet.inType()) {
                vector2.add(taglet);
            }
            if (taglet.inField()) {
                vector3.add(taglet);
            }
            if (taglet.inConstructor()) {
                vector4.add(taglet);
            }
            if (taglet.inMethod()) {
                vector5.add(taglet);
            }
            if (taglet.isInlineTag()) {
                vector6.add(taglet);
            }
            if (!taglet.inOverview()) continue;
            vector7.add(taglet);
        }
        this.packageTags = vector.toArray(new Taglet[0]);
        this.typeTags = vector2.toArray(new Taglet[0]);
        this.fieldTags = vector3.toArray(new Taglet[0]);
        this.constructorTags = vector4.toArray(new Taglet[0]);
        this.methodTags = vector5.toArray(new Taglet[0]);
        this.overviewTags = vector7.toArray(new Taglet[0]);
        this.inlineTags = vector6.toArray(new Taglet[0]);
    }

    private void initStandardTags() {
        Taglet taglet = new ParamTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ReturnTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ThrowsTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("exception", null, "mc");
        this.customTags.put(taglet.getName(), taglet);
        if (!this.nosince) {
            taglet = new SimpleTaglet("since", this.message.getText("doclet.Since"), "a");
            this.customTags.put(taglet.getName(), taglet);
        }
        if (this.showversion) {
            taglet = new SimpleTaglet("version", this.message.getText("doclet.Version"), "pto");
            this.customTags.put(taglet.getName(), taglet);
        }
        if (this.showauthor) {
            taglet = new SimpleTaglet("author", this.message.getText("doclet.Author"), "pto");
            this.customTags.put(taglet.getName(), taglet);
        }
        taglet = new SeeTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new DocRootTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new InheritDocTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ValueTaglet();
        this.customTags.put(taglet.getName(), taglet);
        this.standardTags.add("param");
        this.standardTags.add("return");
        this.standardTags.add("throws");
        this.standardTags.add("exception");
        this.standardTags.add("since");
        this.standardTags.add("version");
        this.standardTags.add("author");
        this.standardTags.add("see");
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("inheritDoc");
        this.standardTags.add("docRoot");
        this.standardTags.add("value");
        this.standardTags.add("serial");
        this.standardTags.add("serialData");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
    }

    private void initStandardTagsLowercase() {
        Iterator iterator = this.standardTags.iterator();
        while (iterator.hasNext()) {
            this.standardTagsLowercase.add(((String)iterator.next()).toLowerCase());
        }
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String string, Set set) {
        if (set.size() > 0) {
            String[] stringArray = set.toArray(new String[0]);
            String string2 = " ";
            int n = 0;
            while (n < stringArray.length) {
                string2 = string2 + "@" + stringArray[n];
                if (n + 1 < stringArray.length) {
                    string2 = string2 + ", ";
                }
                ++n;
            }
            this.message.notice(string, string2);
        }
    }
}

