/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueBoxGen
implements com.sun.tools.corba.se.idl.ValueBoxGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected ValueBoxEntry v = null;
    protected PrintWriter stream = null;

    public void generate(Hashtable hashtable, ValueBoxEntry valueBoxEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.v = valueBoxEntry;
        TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
        SymtabEntry symtabEntry = typedefEntry.type();
        if (symtabEntry instanceof PrimitiveEntry) {
            this.openStream();
            if (this.stream == null) {
                return;
            }
            this.writeHeading();
            this.writeBody();
            this.writeClosing();
            this.closeStream();
        } else {
            Enumeration enumeration = valueBoxEntry.contained().elements();
            while (enumeration.hasMoreElements()) {
                SymtabEntry symtabEntry2 = (SymtabEntry)enumeration.nextElement();
                if (symtabEntry2.type() == null) continue;
                symtabEntry2.type().generate(hashtable, this.stream);
            }
        }
        this.generateHelper();
        this.generateHolder();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        this.stream.println("public class " + this.v.name() + " implements org.omg.CORBA.portable.ValueBase");
        this.stream.println("{");
    }

    protected void writeBody() {
        InterfaceState interfaceState = (InterfaceState)this.v.state().elementAt(0);
        TypedefEntry typedefEntry = interfaceState.entry;
        Util.fillInfo(typedefEntry);
        if (typedefEntry.comment() != null) {
            typedefEntry.comment().generate(" ", this.stream);
        }
        this.stream.println("  public " + Util.javaName(typedefEntry) + " value;");
        this.stream.println("  public " + this.v.name() + " (" + Util.javaName(typedefEntry) + " initial)");
        this.stream.println("  {");
        this.stream.println("    value = initial;");
        this.stream.println("  }");
        this.stream.println();
        this.writeTruncatable();
    }

    protected void writeTruncatable() {
        this.stream.println("  public String[] _truncatable_ids() {");
        this.stream.println("      return " + Util.helperName(this.v, true) + ".get_instance().get_truncatable_base_ids();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.v.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.streamableRead("this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        ValueEntry valueEntry = (ValueEntry)symtabEntry;
        TypedefEntry typedefEntry = ((InterfaceState)valueEntry.state().elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = Util.typeOf(typedefEntry);
        n = ((JavaGenerator)((Object)symtabEntry2.generator())).type(n, string, tCOffsets, string2, symtabEntry2, printWriter);
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_value_box_tc (" + "_id, " + '\"' + symtabEntry.name() + "\", " + string2 + ");");
        return n;
    }

    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        return n;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    return (" + string + ") ((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (get_instance());");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public java.io.Serializable read_value (org.omg.CORBA.portable.InputStream istream)");
        printWriter.println("  {");
        String string2 = "    ";
        Vector vector = ((ValueBoxEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
            printWriter.println(string2 + Util.javaName(symtabEntry2) + " tmp;");
            ((JavaGenerator)((Object)typedefEntry.generator())).read(0, string2, "tmp", typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
            printWriter.println(string2 + Util.javaQualifiedName(symtabEntry2) + " tmp = (" + Util.javaQualifiedName(symtabEntry2) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, true) + ".get_instance ());");
        } else {
            printWriter.println(string2 + Util.javaName(symtabEntry2) + " tmp = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
        if (symtabEntry2 instanceof PrimitiveEntry) {
            printWriter.println(string2 + "return new " + string + " (tmp);");
        } else {
            printWriter.println(string2 + "return tmp;");
        }
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, get_instance());");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public void write_value (org.omg.CORBA.portable.OutputStream ostream, java.io.Serializable obj)");
        printWriter.println("  {");
        String string = Util.javaName(symtabEntry);
        printWriter.println("    " + string + " value  = (" + string + ") obj;");
        this.write(0, "    ", "value", symtabEntry, printWriter);
    }

    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Vector vector = ((ValueEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || !typedefEntry.arrayInfo().isEmpty()) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2 + ".value", typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry || !typedefEntry.arrayInfo().isEmpty()) {
            n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2, typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
            printWriter.println(string + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value ((java.io.Serializable) value, " + Util.helperName(symtabEntry2, true) + ".get_instance ());");
        } else {
            printWriter.println(string + Util.helperName(symtabEntry2, true) + ".write (ostream, " + string2 + ");");
        }
        return n;
    }

    protected void writeAbstract() {
    }

    protected void streamableRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Vector vector = ((ValueBoxEntry)symtabEntry).state();
        TypedefEntry typedefEntry = ((InterfaceState)vector.elementAt((int)0)).entry;
        SymtabEntry symtabEntry2 = typedefEntry.type();
        if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
            TypedefEntry typedefEntry2 = ((InterfaceState)vector.elementAt((int)0)).entry;
            ((JavaGenerator)((Object)typedefEntry.generator())).read(0, "    ", string + ".value", typedefEntry, printWriter);
        } else if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
            printWriter.println("    " + string + ".value = (" + Util.javaQualifiedName(symtabEntry2) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, true) + ".get_instance ());");
        } else {
            printWriter.println("    " + string + ".value = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
    }
}

