/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDTextStream;
import org.pdfbox.pdmodel.fdf.FDFField;
import org.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDFieldFactory;

public abstract class PDField
implements COSObjectable {
    public static final int FLAG_READ_ONLY = 1;
    public static final int FLAG_REQUIRED = 2;
    public static final int FLAG_NO_EXPORT = 4;
    private PDAcroForm acroForm;
    private COSDictionary dictionary;

    public PDField(PDAcroForm theAcroForm) {
        this.acroForm = theAcroForm;
        this.dictionary = new COSDictionary();
    }

    public PDField(PDAcroForm theAcroForm, COSDictionary field) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
    }

    public String getName() {
        return ((COSString)this.getDictionary().getDictionaryObject(COSName.getPDFName("T"))).getString();
    }

    public void setName(String name) {
        this.getDictionary().setItem(COSName.getPDFName("T"), (COSBase)new COSString(name));
    }

    public String getFieldType() {
        return this.getDictionary().getNameAsString("FT");
    }

    public String findFieldType() {
        return this.findFieldType(this.getDictionary());
    }

    private String findFieldType(COSDictionary dic) {
        COSDictionary parent;
        String retval = dic.getNameAsString("FT");
        if (retval == null && (parent = (COSDictionary)dic.getDictionaryObject("Parent")) != null) {
            retval = this.findFieldType(parent);
        }
        return retval;
    }

    public abstract void setValue(String var1) throws IOException;

    public abstract String getValue() throws IOException;

    public void setReadonly(boolean readonly) {
        this.setFfFlag(1, readonly);
    }

    public boolean isReadonly() {
        return this.getFfFlag(1);
    }

    public void setRequired(boolean required) {
        this.setFfFlag(2, required);
    }

    public boolean isRequired() {
        return this.getFfFlag(2);
    }

    public void setNoExport(boolean noExport) {
        this.setFfFlag(4, noExport);
    }

    public boolean isNoExport() {
        return this.getFfFlag(4);
    }

    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getDictionary().getDictionaryObject(COSName.getPDFName("Ff"));
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(int flags) {
        COSInteger ff = new COSInteger(flags);
        this.getDictionary().setItem(COSName.getPDFName("Ff"), (COSBase)ff);
    }

    protected void setFfFlag(int bitFlag, boolean value) {
        int ffval = this.getFieldFlags();
        ffval = value ? (ffval |= bitFlag) : (ffval ^= bitFlag);
        this.getDictionary().setInt("Ff", ffval);
    }

    protected boolean getFfFlag(int bitFlag) {
        int ff = this.getFieldFlags();
        return (ff & bitFlag) == bitFlag;
    }

    public void importFDF(FDFField fdfField) throws IOException {
        Integer ff;
        Object fieldValue = fdfField.getValue();
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.setValue((String)fieldValue);
            } else if (fieldValue instanceof PDTextStream) {
                this.setValue(((PDTextStream)fieldValue).getAsString());
            } else {
                throw new IOException("Unknown field type:" + fieldValue.getClass().getName());
            }
        }
        if ((ff = fdfField.getFieldFlags()) != null) {
            this.setFieldFlags(ff);
        } else {
            Integer clrFf;
            Integer setFf = fdfField.getSetFieldFlags();
            if (setFf != null) {
                int setFfInt = setFf;
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = fdfField.getClearFieldFlags()) != null) {
                int clrFfValue = clrFf;
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        PDWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null && widget != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
    }

    public PDWidget getWidget() throws IOException {
        Object firstKid;
        PDWidget retval = null;
        List kids = this.getKids();
        retval = kids == null ? new PDWidget(this.getDictionary()) : (kids.size() > 0 ? ((firstKid = kids.get(0)) instanceof PDWidget ? (PDWidget)firstKid : ((PDField)firstKid).getWidget()) : null);
        return retval;
    }

    public PDField getParent() throws IOException {
        PDField parent = null;
        COSDictionary parentDic = (COSDictionary)this.getDictionary().getDictionaryObject("Parent");
        if (parentDic != null) {
            parent = PDFieldFactory.createField(this.getAcroForm(), parentDic);
        }
        return parent;
    }

    public void setParent(PDField parent) {
        this.getDictionary().setItem("Parent", (COSObjectable)parent);
    }

    public List getKids() throws IOException {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<COSObjectable> kidsList = new ArrayList<COSObjectable>();
            for (int i = 0; i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                COSDictionary parent = (COSDictionary)kidDictionary.getDictionaryObject("Parent");
                if (kidDictionary.getDictionaryObject("FT") != null || parent != null && parent.getDictionaryObject("FT") != null) {
                    kidsList.add(PDFieldFactory.createField(this.acroForm, kidDictionary));
                    continue;
                }
                if ("Widget".equals(kidDictionary.getNameAsString("Subtype"))) {
                    kidsList.add(new PDWidget(kidDictionary));
                    continue;
                }
                kidsList.add(PDFieldFactory.createField(this.acroForm, kidDictionary));
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(kids);
        this.getDictionary().setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(COSName.getPDFName("V"));
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm value) {
        this.acroForm = value;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public PDFormFieldAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.dictionary.getDictionaryObject("AA");
        PDFormFieldAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDFormFieldAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.dictionary.setItem("AA", (COSObjectable)actions);
    }
}

