/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.pdfbox.pdmodel.graphics.color.PDLab;
import org.pdfbox.pdmodel.graphics.color.PDPattern;
import org.pdfbox.pdmodel.graphics.color.PDSeparation;

public final class PDColorSpaceFactory {
    private PDColorSpaceFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PDColorSpace createColorSpace(COSBase colorSpace) throws IOException {
        PDColorSpace retval = null;
        if (colorSpace instanceof COSName) {
            return PDColorSpaceFactory.createColorSpace(((COSName)colorSpace).getName());
        }
        if (!(colorSpace instanceof COSArray)) throw new IOException("Unknown colorspace type:" + colorSpace);
        COSArray array = (COSArray)colorSpace;
        COSName type = (COSName)array.getObject(0);
        if (type.getName().equals("CalGray")) {
            return new PDCalGray(array);
        }
        if (type.getName().equals("CalRGB")) {
            return new PDCalRGB(array);
        }
        if (type.getName().equals("DeviceN")) {
            return new PDDeviceN(array);
        }
        if (type.getName().equals("Indexed")) return new PDIndexed(array);
        if (type.getName().equals("I")) {
            return new PDIndexed(array);
        }
        if (type.getName().equals("Lab")) {
            return new PDLab(array);
        }
        if (type.getName().equals("Separation")) {
            return new PDSeparation(array);
        }
        if (type.getName().equals("ICCBased")) {
            return new PDICCBased(array);
        }
        if (!type.getName().equals("Pattern")) throw new IOException("Unknown colorspace array type:" + type);
        return new PDPattern(array);
    }

    public static PDColorSpace createColorSpace(String colorSpaceName) throws IOException {
        PDColorSpace cs = null;
        if (colorSpaceName.equals("DeviceCMYK") || colorSpaceName.equals("CMYK")) {
            cs = new PDDeviceCMYK();
        } else if (colorSpaceName.equals("DeviceRGB") || colorSpaceName.equals("RGB")) {
            cs = PDDeviceRGB.INSTANCE;
        } else if (colorSpaceName.equals("DeviceGray") || colorSpaceName.equals("G")) {
            cs = new PDDeviceGray();
        } else if (colorSpaceName.equals("Lab")) {
            cs = new PDLab();
        } else if (colorSpaceName.equals("Pattern")) {
            cs = new PDPattern();
        } else {
            throw new IOException("Error: Unknown colorspace '" + colorSpaceName + "'");
        }
        return cs;
    }
}

