/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.persistence.util.COSHEXTable;

public final class COSName
extends COSBase
implements Comparable {
    private static Map nameMap = Collections.synchronizedMap(new HashMap());
    public static final COSName ACRO_FORM = new COSName("AcroForm");
    public static final COSName ASCII85_DECODE = new COSName("ASCII85Decode");
    public static final COSName ASCII_HEX_DECODE = new COSName("ASCIIHexDecode");
    public static final COSName ASCII_HEX_DECODE_ABBREVIATION = new COSName("AHx");
    public static final COSName BASE_ENCODING = new COSName("BaseEncoding");
    public static final COSName BASE_FONT = new COSName("BaseFont");
    public static final COSName CATALOG = new COSName("Catalog");
    public static final COSName CCITTFAX_DECODE = new COSName("CCITTFaxDecode");
    public static final COSName CCITTFAX_DECODE_ABBREVIATION = new COSName("CCF");
    public static final COSName CONTENTS = new COSName("Contents");
    public static final COSName COUNT = new COSName("Count");
    public static final COSName DIFFERENCES = new COSName("Differences");
    public static final COSName DCT_DECODE = new COSName("DCTDecode");
    public static final COSName DCT_DECODE_ABBREVIATION = new COSName("DCT");
    public static final COSName ENCODING = new COSName("Encoding");
    public static final COSName FILTER = new COSName("Filter");
    public static final COSName FIRSTCHAR = new COSName("FirstChar");
    public static final COSName FLATE_DECODE = new COSName("FlateDecode");
    public static final COSName FLATE_DECODE_ABBREVIATION = new COSName("Fl");
    public static final COSName FONT = new COSName("Font");
    public static final COSName IDENTITY_H = new COSName("Identity-H");
    public static final COSName IMAGE = new COSName("Image");
    public static final COSName JPX_DECODE = new COSName("JPXDecode");
    public static final COSName KIDS = new COSName("Kids");
    public static final COSName LASTCHAR = new COSName("LastChar");
    public static final COSName LENGTH = new COSName("Length");
    public static final COSName LZW_DECODE = new COSName("LZWDecode");
    public static final COSName LZW_DECODE_ABBREVIATION = new COSName("LZW");
    public static final COSName MAC_ROMAN_ENCODING = new COSName("MacRomanEncoding");
    public static final COSName PAGE = new COSName("Page");
    public static final COSName PAGES = new COSName("Pages");
    public static final COSName PARENT = new COSName("Parent");
    public static final COSName PDF_DOC_ENCODING = new COSName("PDFDocEncoding");
    public static final COSName PREV = new COSName("Prev");
    public static final COSName RESOURCES = new COSName("Resources");
    public static final COSName ROOT = new COSName("Root");
    public static final COSName RUN_LENGTH_DECODE = new COSName("RunLengthDecode");
    public static final COSName RUN_LENGTH_DECODE_ABBREVIATION = new COSName("RL");
    public static final COSName STANDARD_ENCODING = new COSName("StandardEncoding");
    public static final COSName SUBTYPE = new COSName("Subtype");
    public static final COSName TYPE = new COSName("Type");
    public static final COSName TO_UNICODE = new COSName("ToUnicode");
    public static final COSName WIDTHS = new COSName("Widths");
    public static final COSName WIN_ANSI_ENCODING = new COSName("WinAnsiEncoding");
    public static final byte[] NAME_PREFIX = new byte[]{47};
    public static final byte[] NAME_ESCAPE = new byte[]{35};
    private String name;
    private int hashCode;

    public static final COSName getPDFName(String aName) {
        COSName name = null;
        if (aName != null && (name = (COSName)nameMap.get(aName)) == null) {
            name = new COSName(aName);
            nameMap.put(aName, name);
        }
        return name;
    }

    private COSName(String aName) {
        this.name = aName;
        nameMap.put(aName, this);
        this.hashCode = this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "COSName{" + this.name + "}";
    }

    public boolean equals(Object o) {
        boolean retval;
        boolean bl = retval = this == o;
        if (!retval && o instanceof COSName) {
            COSName other = (COSName)o;
            retval = this.name == other.name || this.name.equals(other.name);
        }
        return retval;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object o) {
        COSName other = (COSName)o;
        return this.name.compareTo(other.name);
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromName(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(NAME_PREFIX);
        byte[] bytes = this.getName().getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            int current = (bytes[i] + 256) % 256;
            if (current <= 32 || current >= 127 || current == 40 || current == 41 || current == 91 || current == 93 || current == 47 || current == 37 || current == 60 || current == 62 || current == NAME_ESCAPE[0]) {
                output.write(NAME_ESCAPE);
                output.write(COSHEXTable.TABLE[current]);
                continue;
            }
            output.write(current);
        }
    }
}

