/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.TextPosition;

public class PDFTextStripper
extends PDFStreamEngine {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$util$PDFTextStripper == null ? (class$org$pdfbox$util$PDFTextStripper = PDFTextStripper.class$("org.pdfbox.util.PDFTextStripper")) : class$org$pdfbox$util$PDFTextStripper).getName());
    private static final int BUFFER_SIZE = 1024;
    private int currentPage = 0;
    private int startPage = 1;
    private int endPage = Integer.MAX_VALUE;
    private PDDocument document;
    private List charactersList = new ArrayList();
    private Writer output;
    private String lineSeparator = System.getProperty("line.separator");
    private String pageSeparator = System.getProperty("line.separator");
    static /* synthetic */ Class class$org$pdfbox$util$PDFTextStripper;

    public String getText(PDDocument doc) throws IOException {
        StringWriter outputStream = new StringWriter();
        this.writeText(doc, (Writer)outputStream);
        return outputStream.toString();
    }

    public String getText(COSDocument doc) throws IOException {
        PDDocument document = new PDDocument(doc);
        return this.getText(document);
    }

    public void writeText(COSDocument doc, Writer outputStream) throws IOException {
        PDDocument document = new PDDocument(doc);
        this.writeText(document, outputStream);
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        COSInteger p;
        long pVal;
        COSDictionary encrypted = doc.getDocument().getEncryptionDictionary();
        if (encrypted != null && ((pVal = (long)(p = (COSInteger)encrypted.getDictionaryObject(COSName.getPDFName("P"))).intValue()) & 0x10L) == 0L) {
            throw new IOException("You do not have permission to extract text");
        }
        this.currentPage = 0;
        this.document = null;
        this.document = doc;
        this.output = outputStream;
        if (this.document.isEncrypted()) {
            log.debug((Object)"Document is encrypted, decrypting with empty password");
            DecryptDocument decryptor = new DecryptDocument(this.document);
            try {
                decryptor.decryptDocument("");
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document, details: " + e.getMessage());
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: document is encrypted");
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
    }

    protected void processPages(List pages) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPages( " + pages + " )"));
        }
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage page = (PDPage)pageIter.next();
            COSBase contents = page.getCOSDictionary().getDictionaryObject(COSName.CONTENTS);
            if (contents == null) continue;
            if (contents instanceof COSStream) {
                this.processPage(page, (COSStream)contents);
                continue;
            }
            if (contents instanceof COSArray) {
                COSArray contentsArray = (COSArray)contents;
                byte[] buffer = new byte[1024];
                int amountRead = 0;
                if (contentsArray.size() <= 0) continue;
                COSObject first = (COSObject)contentsArray.get(0);
                COSStream firstStream = (COSStream)first.getObject();
                COSStream tmpStream = new COSStream(firstStream.getDictionary(), firstStream.getScratchFile());
                OutputStream output = tmpStream.createUnfilteredStream();
                for (int i = 0; i < contentsArray.size(); ++i) {
                    COSObject obj = (COSObject)contentsArray.get(i);
                    COSStream content = (COSStream)obj.getObject();
                    InputStream input = content.getUnfilteredStream();
                    while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
                        output.write(buffer, 0, amountRead);
                    }
                    output.write("\n".getBytes());
                }
                this.processPage(page, tmpStream);
                continue;
            }
            throw new IOException("Contents are unknown type:" + contents.getClass().getName());
        }
        log.debug((Object)"processPages() end");
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPage( " + page + ", " + content + " )"));
        }
        PDResources resources = page.findResources();
        Map fonts = null;
        if (resources != null) {
            fonts = resources.getFonts();
        }
        ++this.currentPage;
        if (this.currentPage >= this.startPage && this.currentPage <= this.endPage) {
            this.charactersList.clear();
            long startProcess = System.currentTimeMillis();
            this.processStream(content, fonts);
            long stopProcess = System.currentTimeMillis();
            long startFlush = System.currentTimeMillis();
            this.flushText();
            long stopFlush = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processStream time=" + (stopProcess - startProcess)));
                log.debug((Object)("flushText time=" + (stopFlush - startFlush)));
            }
        }
        long stop = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPage() end time=" + (stop - start)));
        }
    }

    protected void flushText() throws IOException {
        log.debug((Object)"flushText() start");
        float currentY = -1.0f;
        float lastBaselineFontSize = -1.0f;
        log.debug((Object)"<Starting text object list>");
        float endOfLastTextX = -1.0f;
        float startOfNextWordX = -1.0f;
        Iterator textIter = this.charactersList.iterator();
        while (textIter.hasNext()) {
            TextPosition position = (TextPosition)textIter.next();
            if (endOfLastTextX != -1.0f && position.getX() < endOfLastTextX && currentY != -1.0f && Math.abs(position.getY() - currentY) < 1.0f) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Suppressing text overwrite x: " + position.getX() + " endOfLastTextX: " + endOfLastTextX + " string: " + position.getString()));
                continue;
            }
            if (currentY != -1.0f && (position.getY() > currentY + lastBaselineFontSize * 0.9f || position.getY() < currentY - position.getFontSize() * 0.9f)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<newline currentY=" + currentY + ", y=" + position.getY() + ">"));
                }
                this.output.write(this.lineSeparator);
                endOfLastTextX = -1.0f;
                startOfNextWordX = -1.0f;
                currentY = -1.0f;
                lastBaselineFontSize = -1.0f;
            }
            if (startOfNextWordX != -1.0f && startOfNextWordX < position.getX()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<space startOfNextWordX=" + startOfNextWordX + ", x=" + position.getX() + ">"));
                }
                this.output.write(32);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("flushText x=" + position.getX() + " y=" + position.getY() + " width=" + position.getWidth() + " currentY=" + currentY + " endOfLastTextX=" + endOfLastTextX + " startOfNextWordX=" + startOfNextWordX + " fontSize=" + position.getFontSize() + " string=\"" + position.getString() + "\""));
            }
            if (currentY == -1.0f) {
                currentY = position.getY();
            }
            if (currentY == position.getY()) {
                lastBaselineFontSize = position.getFontSize();
            }
            float endX = position.getX() + position.getWidth();
            float textTrailingSpaceWidth = 0.0f;
            for (int n = position.getString().length() - 1; n >= 0 && position.getString().charAt(n) == ' '; --n) {
                textTrailingSpaceWidth += position.getWordSpacing();
            }
            endOfLastTextX = endX - Math.max(position.getPadding(), 0.0f) - textTrailingSpaceWidth - 0.4f * position.getLastCharWidth();
            startOfNextWordX = endX + position.getWordSpacing() * 0.3f;
            if (position.getString() == null) continue;
            this.output.write(position.getString());
        }
        log.debug((Object)"<newline endOfFlush=\"true\">");
        this.output.write(this.pageSeparator);
        this.output.flush();
    }

    private boolean within(float first, float second, float variance) {
        float firstMin = first - variance;
        float firstMax = first + variance;
        return second > firstMin && second < firstMax;
    }

    private boolean equals(float first, float second) {
        return this.within(first, second, 0.001f);
    }

    protected TextPosition showString(byte[] string) throws IOException {
        TextPosition position = super.showString(string);
        this.charactersList.add(position);
        return position;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

