/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

public class Matrix
implements Cloneable {
    private static final int MATRIX_SIZE = 3;
    private float[][] matrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};

    public void print() {
        for (int i = 0; i < 3; ++i) {
            System.out.print("[");
            for (int j = 0; j < 3; ++j) {
                System.out.print(this.matrix[i][j]);
                if (j >= 2) continue;
                System.out.print(",");
            }
            System.out.println("]");
        }
    }

    public float getValue(int row, int column) {
        return this.matrix[row][column];
    }

    public void setValue(int row, int column, float value) {
        this.matrix[row][column] = value;
    }

    public Matrix multiply(Matrix b) {
        Matrix result = new Matrix();
        float[][] bMatrix = b.matrix;
        float[][] resultMatrix = result.matrix;
        resultMatrix[0][0] = this.matrix[0][0] * bMatrix[0][0] + this.matrix[0][1] * bMatrix[1][0] + this.matrix[0][2] * bMatrix[2][0];
        resultMatrix[0][1] = this.matrix[0][0] * bMatrix[0][1] + this.matrix[0][1] * bMatrix[1][1] + this.matrix[0][2] * bMatrix[2][1];
        resultMatrix[0][2] = this.matrix[0][0] * bMatrix[0][2] + this.matrix[0][1] * bMatrix[1][2] + this.matrix[0][2] * bMatrix[2][2];
        resultMatrix[1][0] = this.matrix[1][0] * bMatrix[0][0] + this.matrix[1][1] * bMatrix[1][0] + this.matrix[1][2] * bMatrix[2][0];
        resultMatrix[1][1] = this.matrix[1][0] * bMatrix[0][1] + this.matrix[1][1] * bMatrix[1][1] + this.matrix[1][2] * bMatrix[2][1];
        resultMatrix[1][2] = this.matrix[1][0] * bMatrix[0][2] + this.matrix[1][1] * bMatrix[1][2] + this.matrix[1][2] * bMatrix[2][2];
        resultMatrix[2][0] = this.matrix[2][0] * bMatrix[0][0] + this.matrix[2][1] * bMatrix[1][0] + this.matrix[2][2] * bMatrix[2][0];
        resultMatrix[2][1] = this.matrix[2][0] * bMatrix[0][1] + this.matrix[2][1] * bMatrix[1][1] + this.matrix[2][2] * bMatrix[2][1];
        resultMatrix[2][2] = this.matrix[2][0] * bMatrix[0][2] + this.matrix[2][1] * bMatrix[1][2] + this.matrix[2][2] * bMatrix[2][2];
        return result;
    }

    public Object clone() {
        Matrix clone = new Matrix();
        clone.matrix[0][0] = this.matrix[0][0];
        clone.matrix[0][1] = this.matrix[0][1];
        clone.matrix[0][2] = this.matrix[0][2];
        clone.matrix[1][0] = this.matrix[1][0];
        clone.matrix[1][1] = this.matrix[1][1];
        clone.matrix[1][2] = this.matrix[1][2];
        clone.matrix[2][0] = this.matrix[2][0];
        clone.matrix[2][1] = this.matrix[2][1];
        clone.matrix[2][2] = this.matrix[2][2];
        return clone;
    }

    public Matrix copy() {
        return (Matrix)this.clone();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < 3; ++i) {
            result.append("[");
            for (int j = 0; j < 3; ++j) {
                result.append("" + this.matrix[i][j] + " ");
            }
            result.append("] ");
        }
        return result.toString();
    }
}

