/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.searchengine.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.util.PDFTextStripper;

public final class LucenePDFDocument {
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);

    private LucenePDFDocument() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(File file) throws IOException {
        Document document = new Document();
        document.add(Field.UnIndexed((String)"path", (String)file.getPath()));
        document.add(Field.UnIndexed((String)"url", (String)file.getPath().replace(FILE_SEPARATOR, '/')));
        document.add(Field.Keyword((String)"modified", (String)DateField.timeToString((long)file.lastModified())));
        String uid = file.getPath().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + DateField.timeToString((long)file.lastModified());
        document.add(new Field("uid", uid, false, true, false));
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            LucenePDFDocument.addContent(document, input, file.getPath());
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(URL url) throws IOException {
        Document document = new Document();
        URLConnection connection = url.openConnection();
        connection.connect();
        document.add(Field.UnIndexed((String)"url", (String)url.toExternalForm()));
        document.add(Field.Keyword((String)"modified", (String)DateField.timeToString((long)connection.getLastModified())));
        String uid = url.toExternalForm().replace(FILE_SEPARATOR, '\u0000') + "\u0000" + DateField.timeToString((long)connection.getLastModified());
        document.add(new Field("uid", uid, false, true, false));
        InputStream input = null;
        try {
            input = connection.getInputStream();
            LucenePDFDocument.addContent(document, input, url.toExternalForm());
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return document;
    }

    private static void addContent(Document document, InputStream is, String documentLocation) throws IOException {
        PDDocument pdfDocument = null;
        try {
            Date date;
            PDFParser parser = new PDFParser(is);
            parser.parse();
            pdfDocument = parser.getPDDocument();
            if (pdfDocument.isEncrypted()) {
                DecryptDocument decryptor = new DecryptDocument(pdfDocument);
                decryptor.decryptDocument("");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.writeText(pdfDocument.getDocument(), (Writer)writer);
            writer.close();
            byte[] contents = out.toByteArray();
            InputStreamReader input = new InputStreamReader(new ByteArrayInputStream(contents));
            document.add(Field.Text((String)"contents", (Reader)input));
            PDDocumentInformation info = pdfDocument.getDocumentInformation();
            if (info.getAuthor() != null) {
                document.add(Field.Text((String)"Author", (String)info.getAuthor()));
            }
            if (info.getCreationDate() != null && (date = info.getCreationDate().getTime()).getTime() >= 0L) {
                document.add(Field.Text((String)"CreationDate", (String)DateField.dateToString((Date)date)));
            }
            if (info.getCreator() != null) {
                document.add(Field.Text((String)"Creator", (String)info.getCreator()));
            }
            if (info.getKeywords() != null) {
                document.add(Field.Text((String)"Keywords", (String)info.getKeywords()));
            }
            if (info.getModificationDate() != null && (date = info.getModificationDate().getTime()).getTime() >= 0L) {
                document.add(Field.Text((String)"ModificationDate", (String)DateField.dateToString((Date)date)));
            }
            if (info.getProducer() != null) {
                document.add(Field.Text((String)"Producer", (String)info.getProducer()));
            }
            if (info.getSubject() != null) {
                document.add(Field.Text((String)"Subject", (String)info.getSubject()));
            }
            if (info.getTitle() != null) {
                document.add(Field.Text((String)"Title", (String)info.getTitle()));
            }
            if (info.getTrapped() != null) {
                document.add(Field.Text((String)"Trapped", (String)info.getTrapped()));
            }
            int summarySize = Math.min(contents.length, 500);
            document.add(Field.UnIndexed((String)"summary", (String)new String(contents, 0, summarySize)));
        }
        catch (CryptographyException e) {
            throw new IOException("Error decrypting document(" + documentLocation + "): " + e);
        }
        catch (InvalidPasswordException e) {
            throw new IOException("Error: The document(" + documentLocation + ") is encrypted and will not be indexed.");
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("usage: java org.pdfbox.searchengine.lucene.LucenePDFDocument <pdf-document>");
            System.exit(1);
        }
        System.out.println("Document=" + LucenePDFDocument.getDocument(new File(args[0])));
    }
}

