/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDAppearance;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class PDTextbox
extends PDField {
    private COSInteger ff;
    private COSDictionary ap;
    private COSString da;
    private PDAppearance appearance;
    private PDAcroForm acroForm;

    public PDTextbox(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
        this.ff = (COSInteger)field.getDictionaryObject(COSName.getPDFName("Ff"));
        COSArray kids = (COSArray)field.getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            COSDictionary cd = (COSDictionary)kids.getObject(0);
            this.ap = (COSDictionary)cd.getDictionaryObject(COSName.getPDFName("AP"));
        } else {
            this.ap = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("AP"));
        }
        this.da = (COSString)field.getDictionaryObject(COSName.getPDFName("DA"));
    }

    public void setValue(String value) throws IOException {
        COSString fieldValue = new COSString(value);
        this.getDictionary().setItem(COSName.getPDFName("V"), fieldValue);
        if (this.appearance == null) {
            this.appearance = new PDAppearance(this.getAcroForm(), this);
        }
        this.appearance.setAppearanceValue(value);
    }

    public void setReadonly() {
        this.setFfFlag(1, true);
    }

    public boolean isReadonly() {
        return this.getFfFlag(1);
    }

    public boolean isMultiline() {
        boolean ml = this.getFfFlag(13);
        return ml;
    }

    protected COSString getDefaultAppearance() {
        return this.da;
    }
}

