/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDTextbox;

public class PDAppearance {
    private PDTextbox parent;
    private PDAppearanceDictionary appearance;
    private PDAppearanceStream appearanceStream;
    private COSString defaultAppearance;
    private PDRectangle boundingBox = null;
    private float lineWidth;
    private String stream;
    private String value;
    private String font;
    private float fontSize;
    private PDAcroForm acroForm;

    public PDAppearance(PDAcroForm theAcroForm, PDTextbox field) {
        this.acroForm = theAcroForm;
        this.parent = field;
        PDWidget fieldWidget = field.getWidget();
        this.appearance = fieldWidget.getAppearance();
        if (this.appearance != null) {
            Map normalAppearance = this.appearance.getNormalAppearance();
            this.appearanceStream = (PDAppearanceStream)normalAppearance.get("default");
            this.boundingBox = this.appearanceStream.getBoundingBox();
        }
        this.defaultAppearance = this.getDefaultAppearance();
        if (this.boundingBox == null) {
            PDRectangle boxLocation = fieldWidget.getRectangle();
            this.boundingBox = new PDRectangle();
            this.boundingBox.setUpperRightX(this.boundingBox.getUpperRightX() - this.boundingBox.getLowerLeftX());
            this.boundingBox.setUpperRightY(this.boundingBox.getUpperRightY() - this.boundingBox.getLowerLeftY());
        }
        this.stream = this.getOriginalStream();
        this.lineWidth = this.getLineWidth();
    }

    private COSString getDefaultAppearance() {
        COSString dap = this.parent.getDefaultAppearance();
        if (dap == null) {
            dap = (COSString)this.acroForm.getDictionary().getDictionaryObject(COSName.getPDFName("DA"));
        }
        return dap;
    }

    private COSBase getFontReference(String fontname) {
        COSDictionary dr = (COSDictionary)this.acroForm.getDictionary().getDictionaryObject(COSName.getPDFName("DR"));
        COSDictionary font = (COSDictionary)dr.getDictionaryObject(COSName.FONT);
        return font.getDictionaryObject(COSName.getPDFName(fontname));
    }

    private static float floatValue(COSBase item) {
        float r = 0.0f;
        if (item instanceof COSInteger) {
            r = ((COSInteger)item).floatValue();
        } else if (item instanceof COSFloat) {
            r = ((COSFloat)item).floatValue();
        }
        return r;
    }

    private String getOriginalStream() {
        String retval = null;
        if (this.appearanceStream != null) {
            byte[] b = null;
            try {
                InputStream is = this.appearanceStream.getStream().getUnfilteredStream();
                b = new byte[is.available()];
                is.read(b);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            retval = new String(b);
        }
        return retval;
    }

    public boolean containsContent() {
        return this.stream != null && this.stream.indexOf("BMC") > -1;
    }

    public void setAppearanceValue(String value) throws IOException {
        if (this.parent.isMultiline() && value.indexOf(10) != -1) {
            value = this.convertToMultiLine(value);
        }
        this.value = value;
        if (!this.containsContent()) {
            StringBuffer sb = null;
            sb = this.stream != null ? new StringBuffer(this.stream) : new StringBuffer(100);
            sb.append(" /Tx BMC q ");
            sb.append(this.getInnerX() + " ").append(this.getInnerY() + " ");
            sb.append(this.getAvailableWidth() + " ").append(this.getAvailableHeight() + " ");
            sb.append("re W n ");
            sb.append(this.getTextColor());
            sb.append(" BT\n");
            sb.append(this.getFont() + "\n");
            sb.append(this.getTextPosition() + "\n");
            sb.append("0 TL\n");
            sb.append("(" + value + ") Tj\n");
            sb.append("ET Q EMC");
            this.stream = sb.toString();
            this.writeToStream();
            this.setFontReference();
        } else if (this.stream != null) {
            int i1 = this.stream.indexOf("(");
            int i2 = this.stream.indexOf(")");
            if (i1 > -1 && i2 > -1) {
                this.stream = this.stream.substring(0, i1 + 1) + value + this.stream.substring(i2);
                this.writeToStream();
            }
        }
    }

    private String convertToMultiLine(String value) {
        int currIdx = 0;
        int lastIdx = 0;
        StringBuffer result = new StringBuffer(value.length() + 64);
        while ((currIdx = value.indexOf(10, lastIdx)) > -1) {
            result.append(value.substring(lastIdx, currIdx));
            result.append(" ) Tj\n0 -13 Td\n(");
            lastIdx = currIdx + 1;
        }
        result.append(value.substring(lastIdx));
        return result.toString();
    }

    private void writeToStream() throws IOException {
        if (this.appearanceStream == null) {
            this.appearanceStream = new PDAppearanceStream(new COSStream(new COSDictionary(), this.acroForm.getDocument().getDocument().getScratchFile()));
        }
        if (this.appearance == null) {
            this.appearance = new PDAppearanceDictionary();
        }
        HashMap<String, PDAppearanceStream> appearances = new HashMap<String, PDAppearanceStream>();
        appearances.put("default", this.appearanceStream);
        this.appearance.setNormalAppearance(appearances);
        OutputStream out = this.appearanceStream.getStream().createUnfilteredStream();
        out.write(this.stream.getBytes());
    }

    private void setFontReference() {
        COSDictionary resources = (COSDictionary)this.appearanceStream.getStream().getDictionaryObject(COSName.RESOURCES);
        COSArray ar = (COSArray)resources.getDictionaryObject(COSName.getPDFName("ProcSet"));
        ar.add(COSName.getPDFName("Text"));
        COSDictionary fontDescriptor = new COSDictionary();
        String fontname = this.getFontName();
        COSBase fontref = this.getFontReference(fontname);
        Object a = null;
        fontDescriptor.setItem(COSName.getPDFName(fontname), fontref);
        resources.setItem(COSName.FONT, fontDescriptor);
    }

    private float getLineWidth() {
        float retval = 0.0f;
        if (this.stream != null) {
            int w = this.stream.indexOf("w");
            String fl = "";
            for (int i = w - 2; i > 0 && i < this.stream.length() && (Character.isDigit(this.stream.charAt(i)) || this.stream.charAt(i) == '.'); --i) {
                fl = this.stream.charAt(i) + fl;
            }
            try {
                retval = Float.parseFloat(fl);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return retval;
    }

    private float getInnerX() {
        return this.boundingBox.getLowerLeftX() + this.lineWidth;
    }

    private float getInnerY() {
        return this.boundingBox.getLowerLeftY() + this.lineWidth;
    }

    private float getAvailableWidth() {
        return this.boundingBox.getWidth() - 2.0f * this.lineWidth;
    }

    private float getAvailableHeight() {
        return this.boundingBox.getHeight() - 2.0f * this.lineWidth;
    }

    private String getTextColor() {
        if (this.defaultAppearance != null) {
            String color = this.defaultAppearance.getString();
            color = color.substring(color.indexOf("Tf") + 2);
            return color;
        }
        return "0 g";
    }

    private String getFont() {
        if (this.font == null) {
            if (this.defaultAppearance != null) {
                this.font = this.defaultAppearance.getString();
                this.font = this.font.substring(0, this.font.indexOf("Tf") + 2);
                String fontsize = this.font.substring(this.font.indexOf(" ") + 1, this.font.lastIndexOf(" "));
                int indexOfZero = this.font.indexOf(48);
                if (fontsize.equals("0") && indexOfZero >= 0) {
                    this.font = this.font.substring(0, indexOfZero) + Float.toString(this.calculateFontSize()) + this.font.substring(indexOfZero + 1, this.font.length());
                }
            } else {
                this.font = "/Helv " + this.calculateFontSize() + " Tf";
            }
        }
        return this.font;
    }

    private String getFontName() {
        String fontname = null;
        if (this.defaultAppearance != null) {
            fontname = this.defaultAppearance.getString();
            fontname = fontname.substring(fontname.indexOf("/") + 1, fontname.indexOf(" "));
        } else {
            fontname = "Helv";
        }
        return fontname;
    }

    private float getFontSize() {
        if (this.fontSize == 0.0f) {
            if (this.defaultAppearance == null) {
                this.fontSize = this.calculateFontSize();
            } else {
                if (this.font == null) {
                    this.getFont();
                }
                int s1 = this.font.indexOf(" ");
                int s2 = this.font.indexOf(" ", s1 + 1);
                String s = this.font.substring(s1, s2);
                this.fontSize = Float.parseFloat(s);
            }
        }
        return this.fontSize;
    }

    private float calculateFontSize() {
        float fsByHeight = this.getAvailableHeight() - 2.0f * this.lineWidth;
        if (this.value != null) {
            if (this.value.length() == 0) {
                return fsByHeight;
            }
            float length = Float.parseFloat(Integer.toString(this.value.length()));
            float fs = this.getAvailableWidth() / length * 2.0f;
            if (fs > fsByHeight) {
                fs = fsByHeight;
            }
            return fs;
        }
        return fsByHeight;
    }

    private String getTextPosition() {
        if (this.fontSize == 0.0f) {
            this.getFontSize();
        }
        float pos = 0.0f;
        if (this.parent.isMultiline()) {
            int rows = (int)(this.getAvailableHeight() / (float)((int)this.fontSize));
            pos = (float)rows * this.fontSize - this.fontSize;
        } else {
            pos = this.fontSize * 0.4f;
            pos = this.boundingBox.getHeight() - this.fontSize - this.getLineWidth();
        }
        return "2 " + pos + " Td";
    }
}

