/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDFieldFactory;

public class PDAcroForm {
    private COSDictionary acroForm;
    private PDDocument document;
    private Map fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.acroForm = new COSDictionary();
        COSArray fields = new COSArray();
        this.acroForm.setItem(COSName.getPDFName("Fields"), fields);
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.acroForm = form;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public COSDictionary getDictionary() {
        return this.acroForm;
    }

    public List getFields() {
        COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
        ArrayList<PDField> retval = new ArrayList<PDField>();
        for (int i = 0; i < fields.size(); ++i) {
            COSDictionary element = (COSDictionary)fields.getObject(i);
            if (element == null) continue;
            PDField field = PDFieldFactory.createField(this, element);
            retval.add(field);
        }
        return retval;
    }

    public void setCacheFields(boolean cache) {
        if (cache) {
            this.fieldCache = new HashMap();
            List fields = this.getFields();
            Iterator fieldIter = fields.iterator();
            while (fieldIter.hasNext()) {
                PDField next = (PDField)fieldIter.next();
                this.fieldCache.put(next.getName(), next);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String name) {
        PDField retval = null;
        if (this.fieldCache != null) {
            retval = (PDField)this.fieldCache.get(name);
        } else {
            COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
            for (int i = 0; i < fields.size() && retval == null; ++i) {
                COSString fieldName;
                COSDictionary element = (COSDictionary)fields.getObject(i);
                if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.getPDFName("T"))).getString().equals(name)) continue;
                retval = PDFieldFactory.createField(this, element);
            }
        }
        return retval;
    }
}

