/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.graphics.image.PDInlinedImage;
import org.pdfbox.util.BoundingBox;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.PDFStreamEngine;

public class Type3StreamParser
extends PDFStreamEngine {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$util$PDFStreamEngine == null ? (class$org$pdfbox$util$PDFStreamEngine = Type3StreamParser.class$("org.pdfbox.util.PDFStreamEngine")) : class$org$pdfbox$util$PDFStreamEngine).getName());
    private Graphics2D graphics;
    private GeneralPath linePath = new GeneralPath();
    private int width;
    private int height;
    private PDInlinedImage image = null;
    private BoundingBox box = null;
    static /* synthetic */ Class class$org$pdfbox$util$PDFStreamEngine;

    public Image createImage(COSStream type3Stream) throws IOException {
        this.processStream(type3Stream, null);
        return this.image.getImage();
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        COSNumber verticalWidth;
        COSNumber horizontalWidth;
        super.processOperator(operator, arguments);
        String operation = operator.getOperation();
        if (operation.equals("BI")) {
            COSDictionary params = operator.getImageParameters();
            this.image = new PDInlinedImage();
            Iterator iter = params.keyList().iterator();
            while (iter.hasNext()) {
                COSName key = (COSName)iter.next();
                COSBase value = params.getDictionaryObject(key);
                if (key.getName().equals("BPC") || key.getName().equals("BitsPerComponent")) {
                    this.image.setBitsPerComponent(((COSNumber)value).intValue());
                    continue;
                }
                if (key.getName().equals("CS") || key.getName().equals("ColorSpace")) {
                    ArrayList<COSBase> colorSpaces = new ArrayList<COSBase>();
                    this.image.setColorSpaces(colorSpaces);
                    if (value instanceof COSName) {
                        colorSpaces.add(value);
                        continue;
                    }
                    if (!(value instanceof COSArray)) continue;
                    COSArray array = (COSArray)value;
                    for (int i = 0; i < array.size(); ++i) {
                        colorSpaces.add(array.getObject(i));
                    }
                    continue;
                }
                if (key.getName().equals("H") || key.getName().equals("Height")) {
                    this.image.setHeight(((COSNumber)value).intValue());
                    continue;
                }
                if (key.getName().equals("IM") || key.getName().equals("ImageMask")) {
                    this.image.setImageMask(((COSBoolean)value).getValue());
                    continue;
                }
                if (key.getName().equals("Intent")) {
                    this.image.setIntent(((COSName)value).getName());
                    continue;
                }
                if (key.getName().equals("I") || key.getName().equals("Interpolate")) {
                    this.image.setInterpolate(((COSBoolean)value).getValue());
                    continue;
                }
                if (key.getName().equals("W") || key.getName().equals("Width")) {
                    this.image.setWidth(((COSNumber)value).intValue());
                    continue;
                }
                throw new RuntimeException("Unknown inlined parameter " + key + "=" + value);
            }
            this.image.setImageData(operator.getImageData());
        }
        if (operation.equals("d0")) {
            horizontalWidth = (COSNumber)arguments.get(0);
            verticalWidth = (COSNumber)arguments.get(1);
            this.width = horizontalWidth.intValue();
            this.height = verticalWidth.intValue();
        } else if (operation.equals("d1")) {
            horizontalWidth = (COSNumber)arguments.get(0);
            verticalWidth = (COSNumber)arguments.get(1);
            COSNumber llx = (COSNumber)arguments.get(2);
            COSNumber lly = (COSNumber)arguments.get(3);
            COSNumber urx = (COSNumber)arguments.get(4);
            COSNumber ury = (COSNumber)arguments.get(5);
            this.width = horizontalWidth.intValue();
            this.height = verticalWidth.intValue();
            this.box = new BoundingBox();
            this.box.setLowerLeftX(llx.floatValue());
            this.box.setLowerLeftY(lly.floatValue());
            this.box.setUpperRightX(urx.floatValue());
            this.box.setUpperRightY(ury.floatValue());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

