/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.Calendar;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.util.DateConverter;

public class PDDocumentInformation {
    private static final COSName TITLE = COSName.getPDFName("Title");
    private static final COSName AUTHOR = COSName.getPDFName("Author");
    private static final COSName SUBJECT = COSName.getPDFName("Subject");
    private static final COSName KEYWORDS = COSName.getPDFName("Keywords");
    private static final COSName CREATOR = COSName.getPDFName("Creator");
    private static final COSName PRODUCER = COSName.getPDFName("Producer");
    private static final COSName CREATION_DATE = COSName.getPDFName("CreationDate");
    private static final COSName MODIFICATION_DATE = COSName.getPDFName("ModDate");
    private static final COSName TRAPPED = COSName.getPDFName("Trapped");
    private COSDictionary info;

    public PDDocumentInformation(COSDictionary dic) {
        this.info = dic;
    }

    public COSDictionary getDictionary() {
        return this.info;
    }

    public String getTitle() {
        return this.getStringItem(TITLE);
    }

    public void setTitle(String title) {
        this.setStringItem(TITLE, title);
    }

    public String getAuthor() {
        return this.getStringItem(AUTHOR);
    }

    public void setAuthor(String author) {
        this.setStringItem(AUTHOR, author);
    }

    public String getSubject() {
        return this.getStringItem(SUBJECT);
    }

    public void setSubject(String subject) {
        this.setStringItem(SUBJECT, subject);
    }

    public String getKeywords() {
        return this.getStringItem(KEYWORDS);
    }

    public void setKeywords(String keywords) {
        this.setStringItem(KEYWORDS, keywords);
    }

    public String getCreator() {
        return this.getStringItem(CREATOR);
    }

    public void setCreator(String creator) {
        this.setStringItem(CREATOR, creator);
    }

    public String getProducer() {
        return this.getStringItem(PRODUCER);
    }

    public void setProducer(String producer) {
        this.setStringItem(PRODUCER, producer);
    }

    public Calendar getCreationDate() {
        return this.getDateItem(CREATION_DATE);
    }

    public void setCreationDate(Calendar date) {
        this.setDateItem(CREATION_DATE, date);
    }

    public Calendar getModificationDate() {
        return this.getDateItem(MODIFICATION_DATE);
    }

    public void setModificationDate(Calendar date) {
        this.setDateItem(MODIFICATION_DATE, date);
    }

    public String getTrapped() {
        return this.getNameItem(TRAPPED);
    }

    public void setTrapped(String value) {
        if (!(value == null || value.equals("True") || value.equals("False") || value.equals("Unknown"))) {
            throw new RuntimeException("Valid values for trapped are 'True', 'False', or 'Unknown'");
        }
        this.setNameItem(TRAPPED, value);
    }

    private String getStringItem(COSName key) {
        String retval = null;
        COSString value = (COSString)this.info.getDictionaryObject(key);
        if (value != null) {
            retval = value.getString();
        }
        return retval;
    }

    private void setStringItem(COSName key, String value) {
        if (value == null) {
            this.info.removeItem(key);
        } else {
            this.info.setItem(key, new COSString(value));
        }
    }

    private Calendar getDateItem(COSName key) {
        Calendar retval = null;
        COSString value = (COSString)this.info.getDictionaryObject(key);
        if (value != null) {
            String strValue = value.getString();
            int index = 0;
            if (strValue.startsWith("D:")) {
                index = 2;
            }
            boolean validDate = true;
            for (int i = index; i < strValue.length(); ++i) {
                validDate = validDate && Character.isDigit(strValue.charAt(i));
            }
            if (validDate) {
                DateConverter converter = new DateConverter();
                try {
                    retval = converter.toCalendar(value.getString());
                }
                catch (IOException e) {
                    retval = null;
                }
            }
        }
        return retval;
    }

    private void setDateItem(COSName key, Calendar value) {
        if (value == null) {
            this.info.removeItem(key);
        } else {
            DateConverter converter = new DateConverter();
            this.info.setItem(key, new COSString(converter.toString(value)));
        }
    }

    private String getNameItem(COSName key) {
        String retval = null;
        COSName value = (COSName)this.info.getDictionaryObject(key);
        if (value != null) {
            retval = value.getName();
        }
        return retval;
    }

    private void setNameItem(COSName key, String value) {
        if (value == null) {
            this.info.removeItem(key);
        } else {
            this.info.setItem(key, COSName.getPDFName(value));
        }
    }
}

