/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfparser.BaseParser;
import org.pdfbox.util.PDFOperator;

public class PDFStreamParser
extends BaseParser {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$pdfparser$PDFStreamParser == null ? (class$org$pdfbox$pdfparser$PDFStreamParser = PDFStreamParser.class$("org.pdfbox.pdfparser.PDFStreamParser")) : class$org$pdfbox$pdfparser$PDFStreamParser).getName());
    private List streamObjects = new ArrayList(100);
    private RandomAccessFile file;
    static /* synthetic */ Class class$org$pdfbox$pdfparser$PDFStreamParser;

    public PDFStreamParser(InputStream stream, RandomAccessFile raf) throws IOException {
        super(stream);
        this.file = raf;
    }

    public PDFStreamParser(COSStream stream) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile());
    }

    public void parse() throws IOException {
        log.debug((Object)"parse() start");
        try {
            Object token = null;
            while ((token = this.parseNextToken()) != null) {
                this.streamObjects.add(token);
            }
        }
        catch (IOException io) {
            System.out.println("" + this.pdfSource);
            throw io;
        }
        finally {
            this.pdfSource.close();
        }
        log.debug((Object)"parse() end");
    }

    public List getTokens() {
        return this.streamObjects;
    }

    private Object parseNextToken() throws IOException {
        log.debug((Object)"parseNextToken() start");
        Object retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        if ((byte)nextByte == -1) {
            return null;
        }
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    COSDictionary pod = this.parseCOSDictionary();
                    this.skipSpaces();
                    if ((char)this.pdfSource.peek() == 's') {
                        retval = this.parseCOSStream(pod, this.file);
                        break;
                    }
                    retval = pod;
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    retval = COSNull.NULL;
                    break;
                }
                retval = PDFOperator.getOperator(nullString);
                break;
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                if (next.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                retval = PDFOperator.getOperator(next);
                break;
            }
            case 'R': {
                String line = this.readString();
                if (line.equals("R")) {
                    retval = new COSObject(null);
                    break;
                }
                retval = PDFOperator.getOperator(line);
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                    StringBuffer buf = new StringBuffer();
                    while (Character.isDigit(c = (char)this.pdfSource.peek()) || c == '-' || c == '+' || c == '.') {
                        buf.append(c);
                        this.pdfSource.read();
                    }
                    retval = COSNumber.get(buf.toString());
                    break;
                }
                throw new IOException("Unknown dir object c='" + c + "' peek='" + (char)this.pdfSource.peek() + "' " + this.pdfSource);
            }
            case 'B': {
                String next = this.readString();
                PDFOperator biOperator = PDFOperator.getOperator(next);
                retval = biOperator;
                if (!next.equals("BI")) break;
                Object nextToken = null;
                while ((nextToken = this.parseNextToken()) instanceof COSName) {
                    Object value = this.parseNextToken();
                    biOperator.getImageParameters().setItem((COSName)nextToken, (COSBase)value);
                }
                PDFOperator imageData = (PDFOperator)nextToken;
                biOperator.setImageData(imageData.getImageData());
                break;
            }
            case 'I': {
                String id = "" + (char)this.pdfSource.read() + (char)this.pdfSource.read();
                if (!id.equals("ID")) {
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "'");
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                boolean foundEnd = false;
                if (this.isWhitespace()) {
                    this.pdfSource.read();
                }
                int twoBytesAgo = 0;
                int lastByte = this.pdfSource.read();
                int currentByte = this.pdfSource.read();
                boolean count = false;
                while (!(this.isWhitespace(twoBytesAgo) && lastByte == 69 && currentByte == 73 && this.isWhitespace() || this.pdfSource.isEOF())) {
                    imageData.write(lastByte);
                    twoBytesAgo = lastByte;
                    lastByte = currentByte;
                    currentByte = this.pdfSource.read();
                }
                this.pdfSource.unread(73);
                this.pdfSource.unread(69);
                retval = PDFOperator.getOperator("ID");
                ((PDFOperator)retval).setImageData(imageData.toByteArray());
                break;
            }
            case ']': {
                this.pdfSource.read();
                retval = COSNull.NULL;
                break;
            }
            default: {
                String operator = this.readOperator();
                retval = operator.trim().length() == 0 ? null : PDFOperator.getOperator(operator);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseNextToken() retval=" + retval + " peek=" + (char)this.pdfSource.peek() + " end"));
        }
        return retval;
    }

    protected String readOperator() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(4);
        while (!(this.isWhitespace() || this.isClosing() || this.pdfSource.isEOF() || this.pdfSource.peek() == 91 || this.pdfSource.peek() == 60 || this.pdfSource.peek() == 40 || this.pdfSource.peek() == 47 || this.pdfSource.peek() >= 48 && this.pdfSource.peek() <= 57)) {
            buffer.append((char)this.pdfSource.read());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

