/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSObject;
import org.pdfbox.pdfparser.BaseParser;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.persistence.util.COSObjectKey;

public class PDFParser
extends BaseParser {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdfparser$PDFParser == null ? (class$org$pdfbox$pdfparser$PDFParser = PDFParser.class$("org.pdfbox.pdfparser.PDFParser")) : class$org$pdfbox$pdfparser$PDFParser));
    private static final String PDF_HEADER = "%PDF-";
    private COSDocument document;
    private File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
    static /* synthetic */ Class class$org$pdfbox$pdfparser$PDFParser;

    public PDFParser(InputStream input) throws IOException {
        super(input);
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    public void parse() throws IOException {
        block17: {
            try {
                this.document = new COSDocument(this.tempDirectory);
                String header = this.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Header=" + header));
                }
                if (header.length() < PDF_HEADER.length() + 1) {
                    throw new IOException("Error: Header is corrupt '" + header + "'");
                }
                int headerStart = header.indexOf(PDF_HEADER);
                if (headerStart > 0) {
                    header = header.substring(headerStart, header.length());
                }
                try {
                    float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), header.length()));
                    this.document.setVersion(pdfVersion);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Error getting pdf version:" + e);
                }
                this.skipHeaderFillBytes();
                boolean wasLastParsedObjectAnXref = false;
                try {
                    Object nextObject;
                    while ((nextObject = this.parseObject()) != null) {
                        if (nextObject instanceof COSObject) {
                            COSObject pdfObj = (COSObject)nextObject;
                            this.document.addObject(pdfObj);
                            wasLastParsedObjectAnXref = false;
                        } else {
                            PDFXref xref = (PDFXref)nextObject;
                            this.addXref((PDFXref)nextObject);
                            wasLastParsedObjectAnXref = true;
                        }
                        this.skipSpaces();
                    }
                }
                catch (IOException e) {
                    if (wasLastParsedObjectAnXref) {
                        break block17;
                    }
                    throw e;
                }
            }
            catch (IOException io) {
                if (this.document != null) {
                    this.document.close();
                }
                throw io;
            }
            finally {
                this.pdfSource.close();
            }
        }
    }

    protected void skipHeaderFillBytes() throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.peek();
        if (c >= 128) {
            this.readLine();
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument());
    }

    private Object parseObject() throws IOException {
        Object object = null;
        char peekedChar = (char)this.pdfSource.peek();
        if (log.isDebugEnabled()) {
            log.debug((Object)("PDFParser.parseObject() peek='" + peekedChar + "'"));
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x' || peekedChar == 't') {
                String eof;
                String xref = null;
                int number = 0;
                int genNumber = 0;
                if (peekedChar == 'x') {
                    xref = this.readLine();
                    number = this.readInt();
                    genNumber = this.readInt();
                }
                String nextLine = this.readString();
                while (!nextLine.equals("trailer") && !this.pdfSource.isEOF()) {
                    nextLine = this.readString();
                }
                this.skipSpaces();
                COSDictionary parsedTrailer = this.parseCOSDictionary();
                COSDictionary docTrailer = this.document.getTrailer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parsedTrailer=" + parsedTrailer));
                    log.debug((Object)("docTrailer=" + docTrailer));
                }
                if (docTrailer == null) {
                    this.document.setTrailer(parsedTrailer);
                } else {
                    docTrailer.addAll(parsedTrailer);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Final trailer=" + docTrailer));
                }
                object = new PDFXref(number, genNumber);
                if (peekedChar == 'x') {
                    this.skipSpaces();
                    String startxref = this.readString();
                    if (!startxref.equals("startxref")) {
                        throw new IOException("expected='startxref' actual='" + startxref + "' " + this.pdfSource);
                    }
                    this.skipSpaces();
                    int someInt = this.readInt();
                }
                if ((eof = this.readExpectedString("%%EOF")).indexOf("%%EOF") == -1 && !this.pdfSource.isEOF()) {
                    throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
                }
                if (!this.pdfSource.isEOF() && this.pdfSource.available() < 1000) {
                    byte[] data = new byte[1000];
                    int amountRead = this.pdfSource.read(data);
                    if (amountRead != -1) {
                        this.pdfSource.unread(data, 0, amountRead);
                    }
                    boolean atEndOfFile = true;
                    for (int i = 0; i < amountRead - 3 && atEndOfFile; ++i) {
                        atEndOfFile = data[i] != 69 || data[i + 1] != 79 || data[i + 2] != 70;
                    }
                    if (atEndOfFile) {
                        while (this.pdfSource.read(data, 0, data.length) != -1) {
                        }
                    }
                }
            } else {
                int number;
                String objectKey = null;
                try {
                    number = this.readInt();
                }
                catch (IOException e) {
                    number = this.readInt();
                }
                int genNum = this.readInt();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing object (" + number + "," + genNum + ")"));
                }
                if (!(objectKey = this.readString(3)).equals("obj")) {
                    throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    this.pdfSource.unread(endObjectKey.getBytes());
                    this.pdfSource.unread(32);
                    if (!(pb instanceof COSDictionary)) {
                        throw new IOException("stream not preceded by dictionary");
                    }
                    pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                    endObjectKey = this.readString();
                }
                object = this.getObjectFromPool(new COSObjectKey(number, genNum));
                COSObject pdfObject = (COSObject)object;
                pdfObject.setObject(pb);
                pdfObject.setObjectNumber(new COSInteger(number));
                pdfObject.setGenerationNumber(new COSInteger(genNum));
                if (!(endObjectKey.equals("endobj") || this.pdfSource.isEOF() || (endObjectKey = this.readString()).equals("endobj"))) {
                    throw new IOException("expected='endobj' actual='" + endObjectKey + "' " + this.pdfSource);
                }
                this.skipSpaces();
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

