/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfwriter.COSWriter;

public class HelloWorldDoc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String file, String message) throws IOException, COSVisitorException {
        COSDocument doc = null;
        OutputStream os = null;
        COSWriter writer = null;
        try {
            doc = new COSDocument();
            COSDictionary pages = new COSDictionary();
            pages.setItem(COSName.TYPE, COSName.PAGES);
            COSArray pagesArray = new COSArray();
            COSDictionary page = new COSDictionary();
            page.setItem(COSName.TYPE, COSName.PAGE);
            page.setItem(COSName.PARENT, pages);
            COSArray mediaBox = new COSArray();
            mediaBox.add(new COSInteger(0));
            mediaBox.add(new COSInteger(0));
            mediaBox.add(new COSInteger(612));
            mediaBox.add(new COSInteger(792));
            page.setItem(COSName.getPDFName("MediaBox"), mediaBox);
            byte[] bytes = ("BT /F1 24 Tf 100 100 Td (" + message + ") Tj ET").getBytes();
            COSDictionary streamDict = new COSDictionary();
            streamDict.setItem(COSName.LENGTH, new COSInteger(bytes.length));
            COSStream contents = new COSStream(streamDict, doc.getScratchFile());
            OutputStream output = contents.createUnfilteredStream();
            output.write(bytes);
            output.close();
            page.setItem(COSName.CONTENTS, contents);
            COSDictionary resources = new COSDictionary();
            COSArray procSet = new COSArray();
            procSet.add(COSName.getPDFName("PDF"));
            procSet.add(COSName.getPDFName("Text"));
            resources.setItem(COSName.getPDFName("ProcSet"), procSet);
            COSDictionary font = new COSDictionary();
            font.setItem(COSName.TYPE, COSName.FONT);
            font.setItem(COSName.SUBTYPE, COSName.getPDFName("Type1"));
            font.setItem(COSName.getPDFName("Name"), COSName.getPDFName("F1"));
            font.setItem(COSName.getPDFName("BaseFont"), COSName.getPDFName("Helvetica"));
            COSDictionary fontDict = new COSDictionary();
            fontDict.setItem(COSName.getPDFName("F1"), font);
            resources.setItem(COSName.getPDFName("Font"), fontDict);
            page.setItem(COSName.RESOURCES, resources);
            pagesArray.add(page);
            pages.setItem(COSName.KIDS, pagesArray);
            pages.setItem(COSName.COUNT, new COSInteger(pagesArray.size()));
            COSDictionary catalog = new COSDictionary();
            catalog.setItem(COSName.TYPE, COSName.CATALOG);
            catalog.setItem(COSName.PAGES, pages);
            COSDictionary trailer = new COSDictionary();
            trailer.setItem(COSName.ROOT, catalog);
            doc.setTrailer(trailer);
            os = new FileOutputStream(file);
            writer = new COSWriter(os);
            writer.write(doc);
        }
        finally {
            doc.close();
            os.close();
            writer.close();
        }
    }

    public static void main(String[] args) {
        HelloWorldDoc app = new HelloWorldDoc();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file> <Message>");
    }
}

