/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;

public class AppendDoc {
    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        COSBase form;
        COSName acroForm;
        COSBase open;
        COSDictionary destTrailer = destination.getDocument().getTrailer();
        COSDictionary destRoot = (COSDictionary)destTrailer.getDictionaryObject(COSName.ROOT);
        COSDictionary srcTrailer = source.getDocument().getTrailer();
        COSDictionary srcRoot = (COSDictionary)srcTrailer.getDictionaryObject(COSName.ROOT);
        COSName openAction = COSName.getPDFName("OpenAction");
        if (destRoot.getDictionaryObject(openAction) == null && (open = srcRoot.getDictionaryObject(openAction)) != null) {
            destRoot.setItem(openAction, open);
        }
        if (destRoot.getDictionaryObject(acroForm = COSName.getPDFName("AcroForm")) == null && (form = srcRoot.getDictionaryObject(acroForm)) != null) {
            destRoot.setItem(acroForm, form);
        }
        COSName threads = COSName.getPDFName("Threads");
        COSArray destThreads = (COSArray)destRoot.getDictionaryObject(threads);
        COSArray srcThreads = (COSArray)srcRoot.getDictionaryObject(threads);
        if (srcThreads != null) {
            if (destThreads == null) {
                destRoot.setItem(threads, srcThreads);
            } else {
                destThreads.addAll(srcThreads);
            }
        }
        COSName names = COSName.getPDFName("Names");
        COSDictionary destNames = (COSDictionary)destRoot.getDictionaryObject(names);
        COSDictionary srcNames = (COSDictionary)srcRoot.getDictionaryObject(names);
        if (srcNames != null) {
            if (destNames == null) {
                destRoot.setItem(names, srcNames);
            } else {
                destNames.addAll(srcNames);
            }
        }
        COSName pageLabels = COSName.getPDFName("PageLabels");
        COSDictionary destLabels = (COSDictionary)destRoot.getDictionaryObject(pageLabels);
        COSDictionary srcLabels = (COSDictionary)srcRoot.getDictionaryObject(pageLabels);
        if (srcLabels != null) {
            int destPageCount = destination.getPageCount();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.getPDFName("Nums"), destNums);
                destRoot.setItem(pageLabels, destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            for (int i = 0; i < srcNums.size(); i += 2) {
                COSNumber labelIndex = (COSNumber)srcNums.get(i);
                long labelIndexValue = labelIndex.intValue();
                destNums.add(new COSInteger(labelIndexValue + (long)destPageCount));
                destNums.add(srcNums.get(i + 1));
            }
        }
        List pages = source.getDocumentCatalog().getAllPages();
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage page = (PDPage)pageIter.next();
            COSDictionary pageDictionary = page.getCOSDictionary();
            destination.addPage(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in1, String in2, String out) throws IOException, COSVisitorException {
        FileInputStream is1 = null;
        PDDocument doc1 = null;
        FileInputStream is2 = null;
        PDDocument doc2 = null;
        FileOutputStream os = null;
        COSWriter writer = null;
        try {
            is1 = new FileInputStream(in1);
            PDFParser parser1 = new PDFParser(is1);
            parser1.parse();
            doc1 = parser1.getPDDocument();
            is2 = new FileInputStream(in2);
            PDFParser parser2 = new PDFParser(is2);
            parser2.parse();
            doc2 = parser2.getPDDocument();
            this.appendDocument(doc1, doc2);
            os = new FileOutputStream(out);
            writer = new COSWriter(os);
            writer.write(doc1);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.close(is1);
            this.close(doc1);
            this.close(is2);
            this.close(doc2);
            this.close(writer);
            this.close(os);
            throw throwable;
        }
        this.close(is1);
        this.close(doc1);
        this.close(is2);
        this.close(doc2);
        this.close(writer);
        this.close(os);
    }

    private void close(InputStream is) throws IOException {
        if (is != null) {
            is.close();
        }
    }

    private void close(OutputStream os) throws IOException {
        if (os != null) {
            os.close();
        }
    }

    private void close(COSWriter writer) throws IOException {
        if (writer != null) {
            writer.close();
        }
    }

    private void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public static void main(String[] args) {
        AppendDoc app = new AppendDoc();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file1> <input-file2> <output-file>");
    }
}

