/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.fdf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.examples.AbstractExample;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class ImportFDF
extends AbstractExample {
    public void importFDF(PDDocument pdfDocument, COSDocument fdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        acroForm.setCacheFields(true);
        COSDictionary trailer = fdfDocument.getTrailer();
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        COSDictionary fdf = (COSDictionary)root.getDictionaryObject(COSName.getPDFName("FDF"));
        if (fdf != null) {
            COSArray fields = (COSArray)fdf.getDictionaryObject(COSName.getPDFName("Fields"));
            for (int i = 0; i < fields.size(); ++i) {
                COSDictionary fdfField = (COSDictionary)fields.getObject(i);
                COSString fieldName = (COSString)fdfField.getDictionaryObject(COSName.getPDFName("T"));
                System.out.println("Processing " + fieldName);
                PDField docField = acroForm.getField(fieldName.getString());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PDDocument pdf = null;
        COSDocument fdf = null;
        FileInputStream pdfStream = null;
        FileInputStream fdfStream = null;
        FileOutputStream output = null;
        PDFParser pdfParser = null;
        PDFParser fdfParser = null;
        COSWriter writer = null;
        try {
            if (args.length != 3) {
                ImportFDF.usage();
            } else {
                ImportFDF importer = new ImportFDF();
                pdfStream = new FileInputStream(args[0]);
                fdfStream = new FileInputStream(args[1]);
                output = new FileOutputStream(args[2]);
                pdfParser = new PDFParser(pdfStream);
                fdfParser = new PDFParser(fdfStream);
                pdfParser.parse();
                fdfParser.parse();
                pdf = pdfParser.getPDDocument();
                fdf = fdfParser.getDocument();
                importer.importFDF(pdf, fdf);
                writer = new COSWriter(output);
                writer.write(pdf);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ImportFDF.close(fdf);
            ImportFDF.close(pdf);
            ImportFDF.close(pdfStream);
            ImportFDF.close(fdfStream);
            ImportFDF.close(output);
            ImportFDF.close(writer);
            throw throwable;
        }
        ImportFDF.close(fdf);
        ImportFDF.close(pdf);
        ImportFDF.close(pdfStream);
        ImportFDF.close(fdfStream);
        ImportFDF.close(output);
        ImportFDF.close(writer);
    }

    private static void usage() {
        System.err.println("usage: org.pdfbox.examples.fdf.ImportFDF <pdf-file> <fdf-file> <output-file>");
    }
}

