/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.log4j.Category;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.io.RandomAccessFileInputStream;
import org.pdfbox.io.RandomAccessFileOutputStream;
import org.pdfbox.pdfparser.PDFStreamParser;

public class COSStream
extends COSBase {
    private static Category log = Category.getInstance((String)(class$org$pdfbox$cos$COSStream == null ? (class$org$pdfbox$cos$COSStream = COSStream.class$("org.pdfbox.cos.COSStream")) : class$org$pdfbox$cos$COSStream).getName());
    private COSDictionary dic;
    private RandomAccessFile file;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    static /* synthetic */ Class class$org$pdfbox$cos$COSStream;

    public COSStream(COSDictionary dictionary, RandomAccessFile storage) {
        this.dic = dictionary;
        this.file = storage;
    }

    public RandomAccessFile getScratchFile() {
        return this.file;
    }

    public COSBase getItem(COSName key) {
        COSBase retval = this.dic.getItem(key);
        return retval;
    }

    public void setItem(COSName key, COSBase value) {
        this.dic.setItem(key, value);
    }

    public COSBase getDictionaryObject(COSName key) {
        COSBase retval = this.dic.getDictionaryObject(key);
        return retval;
    }

    public String toString() {
        String result = "COSStream{}";
        return result;
    }

    public List getStreamTokens() throws IOException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public COSDictionary getDictionary() {
        return this.dic;
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLength();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input);
    }

    public InputStream getUnfilteredStream() throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input);
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromStream(this);
    }

    protected void addTo(COSDocument doc) {
        super.addTo(doc);
        this.getDictionary().addTo(doc);
    }

    private void doDecode() throws IOException {
        log.debug((Object)"doDecode() start");
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters == null) {
            log.debug((Object)"doDecode() - No filter to apply");
        } else if (filters instanceof COSName) {
            log.debug((Object)"doDecode( COSName )");
            this.doDecode((COSName)filters);
        } else if (filters instanceof COSArray) {
            log.debug((Object)"doDecode( COSArray )");
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName);
            }
        }
        log.debug((Object)"doDecode() end");
    }

    private void doDecode(COSName filterName) throws IOException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDecode( " + filterName.getName() + " ) dic=" + this.dic + " read.length=" + this.unFilteredStream.getLength()));
        }
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        for (int tryCount = 0; !done && tryCount < 5; ++tryCount) {
            try {
                RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
                this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                filter.decode(input, this.unFilteredStream, this.dic);
                done = true;
                continue;
            }
            catch (IOException io) {
                --length;
                exception = io;
            }
        }
        if (!done) {
            throw exception;
        }
        long stop = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doDecode( " + filterName.getName() + " ) done time=" + (stop - start)));
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doEncode((COSName)filters);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = filterArray.size() - 1; i >= 0; --i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doEncode(filterName);
                }
            }
        }
    }

    private void doEncode(COSName filterName) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, this.filteredStream.getPosition(), this.filteredStream.getLength());
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        filter.encode(input, this.filteredStream, this.dic);
    }

    public COSBase getFilters() {
        return this.dic.getItem(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.unFilteredStream = null;
        return this.filteredStream;
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream.setExpectedLength(expectedLength);
        this.unFilteredStream = null;
        return this.filteredStream;
    }

    public void setFilters(COSBase filters) throws IOException {
        this.dic.setItem(COSName.FILTER, filters);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream = null;
        return this.unFilteredStream;
    }

    private static void printHexString(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int nextByte = (data[i] + 256) % 256;
            String hexString = Integer.toHexString(nextByte);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            System.out.print(hexString);
            if (i != 0 && (i + 1) % 2 == 0) {
                System.out.print(" ");
            }
            if (i == 0 || i % 20 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

