/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSFloat
extends COSNumber {
    private float value;

    public COSFloat(float aFloat) {
        this.value = aFloat;
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.value = Float.parseFloat(aFloat);
        }
        catch (NumberFormatException e) {
            this.value = 0.0f;
        }
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value) == Float.floatToIntBits(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "COSFloat{" + this.value + "}";
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromFloat(this);
    }
}

