/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSDictionary
extends COSBase {
    private Map items = new HashMap();
    private List keys = new ArrayList();

    public COSDictionary() {
    }

    public COSDictionary(COSDictionary dict) {
        this.items = new HashMap(dict.items);
        this.keys = new ArrayList(dict.keys);
    }

    public int size() {
        return this.keys.size();
    }

    public void clear() {
        this.items.clear();
        this.keys.clear();
    }

    public COSBase getDictionaryObject(COSName key) {
        COSBase retval = (COSBase)this.items.get(key);
        if (retval instanceof COSObject) {
            retval = ((COSObject)retval).getObject();
        }
        return retval;
    }

    public void setItem(COSName key, COSBase value) {
        if (value == null) {
            this.removeItem(key);
        } else {
            if (!this.items.containsKey(key)) {
                this.keys.add(key);
            }
            this.items.put(key, value);
        }
    }

    public void removeItem(COSName key) {
        this.keys.remove(key);
        this.items.remove(key);
    }

    public COSBase getItem(COSName key) {
        return (COSBase)this.items.get(key);
    }

    public List keyList() {
        return this.keys;
    }

    public Collection getValues() {
        return this.items.values();
    }

    public String toString() {
        return "COSDictionary" + this.items;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDictionary(this);
    }

    protected void addTo(COSDocument doc) {
        super.addTo(doc);
        Iterator i = this.items.values().iterator();
        while (i.hasNext()) {
            COSBase contained = (COSBase)i.next();
            contained.addTo(doc);
        }
    }

    public void addAll(COSDictionary dic) {
        Iterator keys = dic.keyList().iterator();
        while (keys.hasNext()) {
            COSName key = (COSName)keys.next();
            COSBase value = dic.getItem(key);
            this.setItem(key, value);
        }
    }
}

