/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.spider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexDemo {
    RegexDemo() {
    }

    public static void main(String[] args) {
        Pattern p;
        try {
            p = Pattern.compile(".ox");
        }
        catch (PatternSyntaxException e) {
            System.err.println("Regex syntax error: " + e.getMessage());
            System.err.println("Error description: " + e.getDescription());
            System.err.println("Error index: " + e.getIndex());
            System.err.println("Erroneous pattern: " + e.getPattern());
            return;
        }
        String s = "The quick brown fox jumps over the lazy ox.";
        Matcher m = p.matcher(s);
        System.out.println("Regex = .ox");
        System.out.println("Text = " + s);
        System.out.println();
        while (m.find()) {
            System.out.println("Found " + m.group());
            System.out.println("  starting at index " + m.start() + " and ending at index " + m.end());
            System.out.println();
        }
    }

    static String cvtLineTerminators(String s) {
        int newindex;
        StringBuffer sb = new StringBuffer(80);
        int oldindex = 0;
        while ((newindex = s.indexOf("\\n", oldindex)) != -1) {
            sb.append(s.substring(oldindex, newindex));
            oldindex = newindex + 2;
            sb.append('\n');
        }
        sb.append(s.substring(oldindex));
        s = sb.toString();
        sb = new StringBuffer(80);
        oldindex = 0;
        while ((newindex = s.indexOf("\\r", oldindex)) != -1) {
            sb.append(s.substring(oldindex, newindex));
            oldindex = newindex + 2;
            sb.append('\r');
        }
        sb.append(s.substring(oldindex));
        return sb.toString();
    }
}

