/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.spider;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.neoref.config.Config;
import org.neoref.spider.ISpiderReportable;
import org.neoref.spider.Spider;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class CheckLinks
extends JFrame
implements Runnable,
ISpiderReportable {
    boolean frameSizeAdjusted = false;
    JLabel label1 = new JLabel();
    JButton begin = new JButton();
    JTextField url = new JTextField();
    JScrollPane errorScroll = new JScrollPane();
    JTextArea errors = new JTextArea();
    JLabel current = new JLabel();
    JLabel goodLinksLabel = new JLabel();
    JLabel badLinksLabel = new JLabel();
    protected Thread backgroundThread;
    protected Spider spider;
    protected URL base;
    protected int badLinksCount = 0;
    protected int goodLinksCount = 0;

    public CheckLinks() {
        this.setTitle("Find Broken Links");
        this.getContentPane().setLayout(null);
        this.setSize(405, 288);
        this.setVisible(false);
        this.label1.setText("Enter a URL:");
        this.getContentPane().add(this.label1);
        this.label1.setBounds(12, 12, 84, 12);
        this.begin.setText("Begin");
        this.begin.setActionCommand("Begin");
        this.getContentPane().add(this.begin);
        this.begin.setBounds(12, 36, 84, 24);
        this.getContentPane().add(this.url);
        this.url.setBounds(108, 36, 288, 24);
        this.errorScroll.setAutoscrolls(true);
        this.errorScroll.setHorizontalScrollBarPolicy(32);
        this.errorScroll.setVerticalScrollBarPolicy(22);
        this.errorScroll.setOpaque(true);
        this.getContentPane().add(this.errorScroll);
        this.errorScroll.setBounds(12, 120, 384, 156);
        this.errors.setEditable(false);
        this.errorScroll.getViewport().add(this.errors);
        this.errors.setBounds(0, 0, 366, 138);
        this.current.setText("Currently Processing: ");
        this.getContentPane().add(this.current);
        this.current.setBounds(12, 72, 384, 12);
        this.goodLinksLabel.setText("Good Links: 0");
        this.getContentPane().add(this.goodLinksLabel);
        this.goodLinksLabel.setBounds(12, 96, 192, 12);
        this.badLinksLabel.setText("Bad Links: 0");
        this.getContentPane().add(this.badLinksLabel);
        this.badLinksLabel.setBounds(216, 96, 96, 12);
        SymAction lSymAction = new SymAction();
        this.begin.addActionListener(lSymAction);
    }

    public static void main(String[] args) {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            new CheckLinks().setVisible(true);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    void begin_actionPerformed(ActionEvent event) {
        if (this.backgroundThread == null) {
            this.begin.setLabel("Cancel");
            this.backgroundThread = new Thread(this);
            this.backgroundThread.start();
            this.goodLinksCount = 0;
            this.badLinksCount = 0;
        } else {
            this.spider.cancel();
        }
    }

    public void run() {
        try {
            this.errors.setText("");
            this.spider = new Spider(this);
            this.spider.clear();
            this.base = new URL(this.url.getText());
            this.spider.addURL(this.base);
            this.spider.begin();
            Runnable doLater = new Runnable(){

                public void run() {
                    CheckLinks.this.begin.setText("Begin");
                }
            };
            SwingUtilities.invokeLater(doLater);
            this.backgroundThread = null;
        }
        catch (MalformedURLException e) {
            UpdateErrors err = new UpdateErrors();
            err.msg = "Bad address.";
            SwingUtilities.invokeLater(err);
        }
    }

    public boolean spiderFoundURL(URL base, URL url) {
        UpdateCurrentStats cs = new UpdateCurrentStats();
        cs.msg = url.toString();
        SwingUtilities.invokeLater(cs);
        if (!this.checkLink(url)) {
            UpdateErrors err = new UpdateErrors();
            err.msg = url + "(on page " + base + ")\n";
            SwingUtilities.invokeLater(err);
            ++this.badLinksCount;
            return false;
        }
        ++this.goodLinksCount;
        return url.getHost().equalsIgnoreCase(base.getHost());
    }

    public void spiderURLError(URL url) {
    }

    protected boolean checkLink(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.connect();
            if (connection.getContentType().equalsIgnoreCase("application/pdf")) {
                PDFTextStripper stripper = new PDFTextStripper();
                InputStream is = connection.getInputStream();
                PDFParser parser = new PDFParser(is);
                parser.parse();
                PDDocument document = parser.getPDDocument();
                String txtStr = stripper.getText(document).replace('\n', ' ');
                Connection dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
                Statement st = dbConn.createStatement();
                String urlStr = connection.getURL().toString();
                int pos = urlStr.indexOf("artid=");
                String urlSubStr = urlStr.substring(pos);
                ResultSet rs = st.executeQuery("select * from metadata where identifier like '%" + urlSubStr + "'");
                if (rs.next()) {
                    System.out.println("Replace an existing record");
                    st.executeUpdate("delete from metadata where id = " + rs.getInt("id"));
                    st.executeUpdate("insert into metadata (title, subject, creator, source, relation, contributor, format, identifier, language, coverage, rights, publisher, date, description, type, fulltxt) values ('" + rs.getString("title") + "','" + rs.getString("subject") + "','" + rs.getString("creator") + "','" + rs.getString("source") + "','" + rs.getString("relation") + "','" + rs.getString("contributor") + "','" + rs.getString("format") + "','" + rs.getString("identifier") + "','" + rs.getString("language") + "','" + rs.getString("coverage") + "','" + rs.getString("rights") + "','" + rs.getString("publisher") + "','" + rs.getString("date") + "','" + rs.getString("description") + "','" + rs.getString("type") + "','" + txtStr + "')");
                } else {
                    System.out.println("Add a new record");
                    st.executeUpdate("insert into metadata (title, subject, creator, source, relation, contributor, format, identifier, language, coverage, rights, publisher, date, description, type, fulltxt) values (' ', ' ', ' ', ' ', ' ', ' ', ' ', '" + urlStr + "', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '" + txtStr + "')");
                }
                document.close();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error:" + e.getMessage());
            return false;
        }
    }

    public void spiderFoundEMail(String email) {
    }

    class UpdateCurrentStats
    implements Runnable {
        public String msg;

        UpdateCurrentStats() {
        }

        public void run() {
            CheckLinks.this.current.setText("Currently Processing: " + this.msg);
            CheckLinks.this.goodLinksLabel.setText("Good Links: " + CheckLinks.this.goodLinksCount);
            CheckLinks.this.badLinksLabel.setText("Bad Links: " + CheckLinks.this.badLinksCount);
        }
    }

    class UpdateErrors
    implements Runnable {
        public String msg;

        UpdateErrors() {
        }

        public void run() {
            CheckLinks.this.errors.append(this.msg);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CheckLinks.this.begin) {
                CheckLinks.this.begin_actionPerformed(event);
            }
        }
    }
}

