/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.snp;

import java.sql.ResultSet;
import java.util.ArrayList;
import org.neoref.snp.RecTAMAL;

public class ResultSetTAMAL
extends ArrayList {
    public static int ID = 1;
    public static int CHROM = 2;
    public static int SNPID = 3;
    public static int CHROMEND = 4;
    public static int HTSNPGAB_CEU = 5;
    public static int HTSNPGAB_HCB = 6;
    public static int HTSNPGAB_JPT = 7;
    public static int HTSNPGAB_YRI = 8;
    public static int HTSNPTAG_CEU = 9;
    public static int HTSNPTAG_HCB = 10;
    public static int HTSNPTAG_JPT = 11;
    public static int HTSNPTAG_YRI = 12;
    public static int NONSYNON = 13;
    public static int SPLICE = 14;
    public static int SYNON = 15;
    public static int INTRON = 16;
    public static int PROMOTER = 17;
    public static int P99 = 18;
    public static int REGPOT = 19;
    public static int TFBS = 20;
    public static int HTSNP_GAB = 21;
    public static int HTSNP_TAG = 22;
    public static int NUMCOL = 22;
    public static int INITIAL_SIZE = 1000000;
    private int cursor;
    private int size;

    public ResultSetTAMAL(ResultSet rs) throws Exception {
        super(INITIAL_SIZE);
        rs.beforeFirst();
        while (rs.next()) {
            RecTAMAL rec = new RecTAMAL(rs.getString(ID), rs.getString(CHROM), rs.getString(SNPID), rs.getInt(CHROMEND), rs.getString(HTSNPGAB_CEU), rs.getString(HTSNPGAB_HCB), rs.getString(HTSNPGAB_JPT), rs.getString(HTSNPGAB_YRI), rs.getString(HTSNPTAG_CEU), rs.getString(HTSNPTAG_HCB), rs.getString(HTSNPTAG_JPT), rs.getString(HTSNPTAG_YRI), rs.getString(NONSYNON), rs.getString(SPLICE), rs.getString(SYNON), rs.getString(INTRON), rs.getString(PROMOTER), rs.getString(P99), rs.getString(REGPOT), rs.getString(TFBS), rs.getString(HTSNP_GAB), rs.getString(HTSNP_TAG));
            this.add(rec);
        }
        this.cursor = 0;
        this.size = this.size();
    }

    public void beforeFirst() {
        this.cursor = 0;
    }

    public boolean next() {
        ++this.cursor;
        return this.cursor < this.size;
    }

    public RecTAMAL getRec() {
        return (RecTAMAL)this.get(this.cursor);
    }

    public int getInt(String col) {
        RecTAMAL rec = (RecTAMAL)this.get(this.cursor);
        if (col.equals("chromEnd")) {
            return rec.getChromEnd();
        }
        return -1;
    }

    public String getString(String col) {
        RecTAMAL rec = (RecTAMAL)this.get(this.cursor);
        int flags = rec.getFlags();
        if (col.equals("id")) {
            return rec.getId();
        }
        if (col.equals("chrom")) {
            return rec.getChrom();
        }
        if (col.equals("snpid")) {
            return rec.getSnpid();
        }
        if (col.equals("chromEnd")) {
            return Integer.toString(rec.getChromEnd());
        }
        flags = rec.getFlags();
        if (col.equals("htSNPgab_CEU")) {
            if ((flags & RecTAMAL.HTSNPGAB_CEU_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPgab_HCB")) {
            if ((flags & RecTAMAL.HTSNPGAB_HCB_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPgab_JPT")) {
            if ((flags & RecTAMAL.HTSNPGAB_JPT_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPgab_YRI")) {
            if ((flags & RecTAMAL.HTSNPGAB_YRI_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPtag_CEU")) {
            if ((flags & RecTAMAL.HTSNPTAG_HCB_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPtag_HCB")) {
            if ((flags & RecTAMAL.HTSNPTAG_HCB_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPtag_JPT")) {
            if ((flags & RecTAMAL.HTSNPTAG_JPT_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htSNPtag_YRI")) {
            if ((flags & RecTAMAL.HTSNPTAG_YRI_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("nonsynon")) {
            if ((flags & RecTAMAL.NONSYNON_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("splice")) {
            if ((flags & RecTAMAL.SPLICE_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("synon")) {
            if ((flags & RecTAMAL.SYNON_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("intron")) {
            if ((flags & RecTAMAL.INTRON_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("promoter")) {
            if ((flags & RecTAMAL.PROMOTER_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("p99")) {
            if ((flags & RecTAMAL.P99_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("regpot")) {
            if ((flags & RecTAMAL.REGPOT_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("tfbs")) {
            if ((flags & RecTAMAL.TFBS_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htsnp_gab")) {
            if ((flags & RecTAMAL.HTSNP_GAB_FG) > 0) {
                return "1";
            }
            return "0";
        }
        if (col.equals("htsnp_tag")) {
            if ((flags & RecTAMAL.HTSNP_TAG_FG) > 0) {
                return "1";
            }
            return "0";
        }
        return null;
    }
}

