/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.snp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.snp.GeneInfo;
import org.neoref.snp.GeneMatrix;
import org.neoref.snp.RecTAMAL;
import org.neoref.snp.ResultSetTAMAL;

public class QuerySNPServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger((Class)(class$org$neoref$snp$QuerySNPServlet == null ? (class$org$neoref$snp$QuerySNPServlet = QuerySNPServlet.class$("org.neoref.snp.QuerySNPServlet")) : class$org$neoref$snp$QuerySNPServlet));
    private static String PRESENT = "1000";
    private static String ABSENT = "200";
    private static String FIELDS = "id, chrom, snpid, chromEnd, htSNPgab_CEU, htSNPgab_HCB, htSNPgab_JPT, htSNPgab_YRI, htSNPtag_CEU, htSNPtag_HCB, htSNPtag_JPT, htSNPtag_YRI, nonsynon, splice, synon, intron, promoter, p99, regpot, tfbs, htsnp_gab, htsnp_tag ";
    static /* synthetic */ Class class$org$neoref$snp$QuerySNPServlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized long readCounter(File file) {
        String value = null;
        String tmpValue = null;
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(file));
        while ((tmpValue = in.readLine()) != null) {
            value = tmpValue;
        }
        Object var6_4 = null;
        try {
            in.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return Long.parseLong(value == null ? "0" : value);
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var6_5 = null;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return Long.parseLong(value == null ? "0" : value);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                in.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return Long.parseLong(value == null ? "0" : value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized long incrementCounter(File file) {
        BufferedWriter buffer = null;
        PrintWriter out = null;
        long counter = QuerySNPServlet.readCounter(file);
        buffer = new BufferedWriter(new FileWriter(file));
        out = new PrintWriter(buffer);
        out.flush();
        out.print(counter + 1L);
        Object var7_4 = null;
        try {
            out.close();
            buffer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return counter;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var7_5 = null;
                try {
                    out.close();
                    buffer.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return counter;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                out.close();
                buffer.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return counter;
        }
    }

    Statement createStreamStatement(Connection dbConn) throws Exception {
        Statement stmt = dbConn.createStatement(1003, 1007);
        stmt.setFetchSize(50);
        return stmt;
    }

    int toBasepos(String str) {
        return Integer.parseInt(str.substring(2, 5)) * 1000000;
    }

    String toCbin(String chrom, int basepos) {
        String xx = chrom.substring(3, 5);
        String yyy = Integer.toString(basepos / 1000000);
        while (yyy.length() < 3) {
            yyy = "0" + yyy;
        }
        return xx + yyy;
    }

    boolean inRange(ResultSetTAMAL rst, String chrom, int dnaStart, int dnaEnd) throws Exception {
        int chromEnd;
        if (!chrom.equals(rst.getString("chrom"))) {
            return false;
        }
        int basepos = chromEnd = rst.getInt("chromEnd");
        if (chromEnd == -1) {
            chromEnd = basepos + 1;
        }
        return basepos > dnaStart && chromEnd < dnaEnd;
    }

    private Vector getIDs(ResultSetTAMAL rst) throws Exception {
        Vector<Integer> ids = new Vector<Integer>();
        rst.beforeFirst();
        while (rst.next()) {
            ids.add(new Integer(rst.getInt("id")));
        }
        return ids;
    }

    private void createTrack(String field, String desc, int cnt, BufferedWriter out) throws Exception {
        String line = "track name=" + field + " description='" + desc + " (" + cnt + ")' color=0,0,0 useScore=1 visibility=1\n";
        out.write(line);
    }

    private void createTrack(String field, BufferedWriter out) throws Exception {
        String line = "track name=" + field + " description='' color=0,0,0 useScore=1 visibility=1\n";
        out.write(line);
    }

    private void createTrackLine(String chrom, int dnaStart, int dnaEnd, String present, String absent, Vector ids, ResultSetTAMAL rst, BufferedWriter out) throws Exception {
        rst.beforeFirst();
        while (rst.next()) {
            int chromEnd;
            if (!chrom.equals(rst.getString("chrom"))) continue;
            int basepos = chromEnd = rst.getInt("chromEnd");
            if (chromEnd == -1) {
                chromEnd = basepos + 1;
            }
            if (basepos < dnaStart || chromEnd > dnaEnd) continue;
            String line = "";
            line = line + rst.getString("chrom") + "\t";
            line = line + basepos + "\t";
            line = line + chromEnd + "\t";
            line = line + rst.getString("snpid") + "\t";
            line = ids.contains(new Integer(rst.getInt("id"))) ? line + present : line + absent;
            out.write(line);
            out.newLine();
        }
        out.newLine();
    }

    private void createTrackLineCombined(String chrom, int dnaStart, int dnaEnd, String field, String flag, String subflag, String present, String absent, ResultSetTAMAL rst, BufferedWriter out) throws Exception {
        rst.beforeFirst();
        while (rst.next()) {
            int chromEnd;
            if (!chrom.equals(rst.getString("chrom"))) continue;
            int basepos = chromEnd = rst.getInt("chromEnd");
            if (chromEnd == -1) {
                chromEnd = basepos + 1;
            }
            if (basepos < dnaStart || chromEnd > dnaEnd || !rst.getString(field).equals("1")) continue;
            String line = "";
            line = line + rst.getString("chrom") + "\t";
            line = line + basepos + "\t";
            line = line + chromEnd + "\t";
            line = line + rst.getString("snpid") + "\t";
            line = flag != null && subflag != null && subflag.equals("1") ? line + present : line + absent;
            out.write(line);
            out.newLine();
        }
        out.newLine();
    }

    private void createTrackLine(String chrom, int dnaStart, int dnaEnd, String field, String flag, String pattern, String present, String absent, ResultSetTAMAL rst, BufferedWriter out) throws Exception {
        rst.beforeFirst();
        while (rst.next()) {
            int chromEnd;
            if (!chrom.equals(rst.getString("chrom"))) continue;
            int basepos = chromEnd = rst.getInt("chromEnd");
            if (chromEnd == -1) {
                chromEnd = basepos + 1;
            }
            if (basepos < dnaStart || chromEnd > dnaEnd || !rst.getString(field).equals(pattern)) continue;
            String line = "";
            line = line + rst.getString("chrom") + "\t";
            line = line + basepos + "\t";
            line = line + chromEnd + "\t";
            line = line + rst.getString("snpid") + "\t";
            line = flag != null && flag.equals("1") ? line + present : line + absent;
            out.write(line);
            out.newLine();
        }
        out.newLine();
    }

    private void createTrackFile(String ucscQuery, String chrom, int dnaStart, int dnaEnd, String gabrielMthd, String taggerMthd, String ceu, String hcb, String jpt, String yri, String synon, String nonsynon, String splice, String intron, String promoter, String regpot, String tfbs, String p99, ResultSetTAMAL rst, ResultSetTAMAL rsFiltered) throws Exception {
        String path = "/fs1/neoref/nrschizophrenia/jsp/snp/data/Track_" + ucscQuery.toUpperCase() + ".txt";
        int cnt = 0;
        int tagCnt = 0;
        int gabCnt = 0;
        int codingCnt = 0;
        int otherCnt = 0;
        log.debug((Object)"[TAMAL] creating track file");
        BufferedWriter out = new BufferedWriter(new FileWriter(path));
        String line = "browser position " + chrom + ":" + dnaStart + "-" + dnaEnd;
        out.write(line);
        out.newLine();
        line = "browser hide stsMap gap knownGene ensGene acembly genscan intronEst mm3Hg15L";
        out.write(line);
        out.newLine();
        line = "browser full refGene cytoband";
        out.write(line);
        out.newLine();
        line = "browser dense mRNA gcPercent";
        out.write(line);
        out.newLine();
        out.newLine();
        rst.beforeFirst();
        while (rst.next()) {
            if (!this.inRange(rst, chrom, dnaStart, dnaEnd)) continue;
            ++cnt;
        }
        rsFiltered.beforeFirst();
        while (rsFiltered.next()) {
            if (!this.inRange(rsFiltered, chrom, dnaStart, dnaEnd)) continue;
            int curFlags = rsFiltered.getRec().getFlags();
            if ((curFlags & RecTAMAL.HTSNPTAG_CEU_FG) > 0 || (curFlags & RecTAMAL.HTSNPTAG_HCB_FG) > 0 || (curFlags & RecTAMAL.HTSNPTAG_JPT_FG) > 0 || (curFlags & RecTAMAL.HTSNPTAG_YRI_FG) > 0) {
                ++tagCnt;
            }
            if ((curFlags & RecTAMAL.HTSNPGAB_CEU_FG) > 0 || (curFlags & RecTAMAL.HTSNPGAB_HCB_FG) > 0 || (curFlags & RecTAMAL.HTSNPGAB_JPT_FG) > 0 || (curFlags & RecTAMAL.HTSNPGAB_YRI_FG) > 0) {
                ++gabCnt;
            }
            if ((curFlags & RecTAMAL.SYNON_FG) > 0 || (curFlags & RecTAMAL.NONSYNON_FG) > 0 || (curFlags & RecTAMAL.SPLICE_FG) > 0 || (curFlags & RecTAMAL.INTRON_FG) > 0) {
                ++codingCnt;
            }
            if ((curFlags & RecTAMAL.PROMOTER_FG) <= 0 && (curFlags & RecTAMAL.REGPOT_FG) <= 0 && (curFlags & RecTAMAL.TFBS_FG) <= 0 && (curFlags & RecTAMAL.P99_FG) <= 0) continue;
            ++otherCnt;
        }
        this.createTrack("dbSNP", "All dbSNP Entries", cnt, out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, PRESENT, ABSENT, this.getIDs(rsFiltered), rst, out);
        this.createTrack("htSNPtag_CEU", "htSNPs Tagger Method", tagCnt, out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPtag_CEU", taggerMthd, ceu, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPtag_HCB", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPtag_HCB", taggerMthd, hcb, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPtag_JPT", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPtag_JPT", taggerMthd, jpt, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPtag_YRI", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPtag_YRI", taggerMthd, yri, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPgab_CEU", "htSNPs Gabriel Method", gabCnt, out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPgab_CEU", gabrielMthd, ceu, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPgab_HCB", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPgab_HCB", gabrielMthd, hcb, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPgab_JPT", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPgab_JPT", gabrielMthd, jpt, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("htSNPgab_YRI", out);
        this.createTrackLineCombined(chrom, dnaStart, dnaEnd, "htSNPgab_YRI", gabrielMthd, yri, PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("synon", "Coding", codingCnt, out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "synon", synon, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("nonsynon", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "nonsynon", nonsynon, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("splice", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "splice", splice, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("intron", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "intron", intron, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("promoter", "Other", otherCnt, out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "promoter", promoter, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("regpot", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "regpot", regpot, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("tfbs", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "tfbs", tfbs, "1", PRESENT, ABSENT, rsFiltered, out);
        this.createTrack("p99", out);
        this.createTrackLine(chrom, dnaStart, dnaEnd, "p99", p99, "1", PRESENT, ABSENT, rsFiltered, out);
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            long end;
            long begin;
            int txsmax;
            int txsmin;
            Connection dbConn = null;
            ResultSet rs = null;
            ResultSet tamalSchema = null;
            ResultSet readmeSchema = null;
            ResultSet readmeRs = null;
            ResultSet vardefSchema = null;
            ResultSet vardefRs = null;
            ResultSetTAMAL rst = null;
            String query = null;
            String queryType = null;
            String lastQuery = null;
            String gene = null;
            String temp = null;
            String gabrielMthd = null;
            String taggerMthd = null;
            String ceu = "1";
            String hcb = "1";
            String jpt = "1";
            String yri = "1";
            String synon = "1";
            String nonsynon = "1";
            String splice = "1";
            String intron = "0";
            String promoter = "1";
            String regpot = "1";
            String tfbs = "1";
            String p99 = "1";
            String download = null;
            String sql = null;
            String lastSql = null;
            float hitCnt = 0.0f;
            float filteredHitCnt = 0.0f;
            GeneMatrix geneMatrix = null;
            GeneInfo geneInfo = null;
            String chrom = null;
            String chromTmp = null;
            String ucscQuery = null;
            int dnaStart = 0;
            int dnaEnd = 0;
            int gend = 20000;
            int ceuCnt = 0;
            int hcbCnt = 0;
            int jptCnt = 0;
            int yriCnt = 0;
            int synonCnt = 0;
            int nonsynonCnt = 0;
            int spliceCnt = 0;
            int intronCnt = 0;
            int promoterCnt = 0;
            int regpotCnt = 0;
            int tfbsCnt = 0;
            int p99Cnt = 0;
            int basepos = 0;
            int chromEnd = 0;
            Perl5Util util = new Perl5Util();
            byte[] buf = new byte[1024];
            if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
                DiskFileUpload upload = new DiskFileUpload();
                List items = upload.parseRequest(request);
                Iterator iter = items.iterator();
                query = "";
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) {
                        if (item.getFieldName().equals("query")) {
                            query = query + item.getString().trim();
                        }
                        if (item.getFieldName().equals("queryType")) {
                            queryType = item.getString();
                        }
                        if (item.getFieldName().equals("gabrielMthd")) {
                            gabrielMthd = item.getString();
                        }
                        if (item.getFieldName().equals("taggerMthd")) {
                            taggerMthd = item.getString();
                        }
                        if (item.getFieldName().equals("ceu")) {
                            ceu = item.getString();
                        }
                        if (item.getFieldName().equals("hcb")) {
                            hcb = item.getString();
                        }
                        if (item.getFieldName().equals("jpt")) {
                            jpt = item.getString();
                        }
                        if (item.getFieldName().equals("yri")) {
                            yri = item.getString();
                        }
                        if (item.getFieldName().equals("synon")) {
                            synon = item.getString();
                        }
                        if (item.getFieldName().equals("nonsynon")) {
                            nonsynon = item.getString();
                        }
                        if (item.getFieldName().equals("splice")) {
                            splice = item.getString();
                        }
                        if (item.getFieldName().equals("intron")) {
                            intron = item.getString();
                        }
                        if (item.getFieldName().equals("promoter")) {
                            promoter = item.getString();
                        }
                        if (item.getFieldName().equals("regpot")) {
                            regpot = item.getString();
                        }
                        if (item.getFieldName().equals("tfbs")) {
                            tfbs = item.getString();
                        }
                        if (!item.getFieldName().equals("p99")) continue;
                        p99 = item.getString();
                        continue;
                    }
                    String uploadedQuery = "";
                    InputStream uploadedStream = item.getInputStream();
                    while (uploadedStream.read(buf) != -1) {
                        uploadedQuery = uploadedQuery + new String(buf);
                    }
                    uploadedStream.close();
                    query = query + uploadedQuery.trim();
                }
                query = util.substitute("s/\\s/;/g", query);
                query = util.substitute("s/;;/;/g", query);
                log.debug((Object)("[TAMAL] query terms: " + query));
                lastQuery = query;
                File qcFile = new File("/fs1/neoref/nrschizophrenia/jsp/snp/data/qcounter.txt");
                if (!qcFile.exists()) {
                    qcFile.createNewFile();
                }
                log.debug((Object)("[TAMAL] query count: " + QuerySNPServlet.incrementCounter(qcFile)));
            } else {
                queryType = request.getParameter("queryType");
                lastQuery = request.getParameter("lastQuery");
                lastSql = request.getParameter("lastSql");
                String reset = request.getParameter("reset");
                if (reset != null) {
                    query = lastQuery;
                    taggerMthd = "1";
                    gend = 20000;
                } else {
                    gend = Integer.parseInt(request.getParameter("gend"));
                    gabrielMthd = request.getParameter("gabrielMthd");
                    taggerMthd = request.getParameter("taggerMthd");
                    ceu = request.getParameter("ceu");
                    hcb = request.getParameter("hcb");
                    jpt = request.getParameter("jpt");
                    yri = request.getParameter("yri");
                    synon = request.getParameter("synon");
                    nonsynon = request.getParameter("nonsynon");
                    splice = request.getParameter("splice");
                    intron = request.getParameter("intron");
                    promoter = request.getParameter("promoter");
                    regpot = request.getParameter("regpot");
                    tfbs = request.getParameter("tfbs");
                    p99 = request.getParameter("p99");
                }
                download = request.getParameter("download");
                if (download != null) {
                    log.debug((Object)"[TAMAL] download mode");
                    queryType = download.equals("Download XML") ? "xml" : "excel";
                }
                ucscQuery = request.getParameter("ucscQuery");
                log.debug((Object)("[TAMAL] ucscQuery: " + ucscQuery));
                if (ucscQuery != null && ucscQuery.length() > 0) {
                    queryType = "ucsc";
                }
            }
            HttpSession session = request.getSession(true);
            geneMatrix = (GeneMatrix)session.getAttribute("geneMatrix");
            if (query == null && download == null && !queryType.equals("ucsc")) {
                rst = (ResultSetTAMAL)session.getAttribute("resultSetTAMAL");
            } else {
                StringTokenizer stk;
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
                Statement stmt = dbConn.createStatement();
                if (download == null && !queryType.equals("ucsc")) {
                    String strand;
                    int multimap;
                    geneMatrix = new GeneMatrix();
                    stk = new StringTokenizer(query, ";");
                    gene = stk.nextToken().toUpperCase();
                    sql = "SELECT strand, chrom, txsmin, txsmax, multimap ";
                    sql = sql + "FROM REFFLAT_ISOFORM WHERE rfname='";
                    rs = stmt.executeQuery(sql = sql + gene + "'");
                    if (rs.next() && ((multimap = rs.getInt("multimap")) == 0 || multimap == 3 || multimap == 5)) {
                        strand = rs.getString("strand");
                        chrom = rs.getString("chrom");
                        txsmin = rs.getInt("txsmin");
                        txsmax = rs.getInt("txsmax");
                        geneMatrix.put(gene, new GeneInfo(strand, chrom, txsmin, txsmax, "Mapping okay", 0, 0));
                        temp = "chrom='" + chrom + "'";
                    }
                    if (!geneMatrix.containsKey(gene)) {
                        geneMatrix.put(gene, new GeneInfo("n/a", "n/a", 0, 0, "n/a", 0, 0));
                    }
                    while (stk.hasMoreTokens()) {
                        gene = stk.nextToken().toUpperCase();
                        sql = "SELECT strand, chrom, txsmin, txsmax, multimap ";
                        sql = sql + "FROM REFFLAT_ISOFORM WHERE rfname='";
                        rs = stmt.executeQuery(sql = sql + gene + "'");
                        if (rs.next() && ((multimap = rs.getInt("multimap")) == 0 || multimap == 3 || multimap == 5)) {
                            strand = rs.getString("strand");
                            chrom = rs.getString("chrom");
                            txsmin = rs.getInt("txsmin");
                            txsmax = rs.getInt("txsmax");
                            geneMatrix.put(gene, new GeneInfo(strand, chrom, txsmin, txsmax, "Mapping okay", 0, 0));
                            if (temp.indexOf("'" + chrom + "'") == -1) {
                                temp = temp + " OR chrom='" + chrom + "'";
                            }
                        }
                        if (geneMatrix.containsKey(gene)) continue;
                        geneMatrix.put(gene, new GeneInfo("n/a", "n/a", 0, 0, "n/a", 0, 0));
                    }
                    sql = "SELECT " + FIELDS + " FROM TAMAL WHERE " + temp;
                    log.debug((Object)("[TAMAL] sql: " + sql));
                    begin = System.currentTimeMillis();
                    stmt.setFetchDirection(1000);
                    rs = stmt.executeQuery(sql);
                    end = System.currentTimeMillis();
                    log.debug((Object)("[TAMAL] Query Elapsed Time: " + (end - begin) + "ms"));
                    begin = System.currentTimeMillis();
                    rst = new ResultSetTAMAL(rs);
                    rs.close();
                    lastSql = sql;
                    end = System.currentTimeMillis();
                    log.debug((Object)("[TAMAL] Memory Elapsed Time: " + (end - begin) + "ms"));
                } else {
                    Statement tamalSchemaStmt = dbConn.createStatement();
                    Statement readmeSchemaStmt = dbConn.createStatement();
                    Statement readmeRsStmt = dbConn.createStatement();
                    Statement vardefSchemaStmt = dbConn.createStatement();
                    Statement vardefRsStmt = dbConn.createStatement();
                    tamalSchema = tamalSchemaStmt.executeQuery("DESCRIBE TAMAL");
                    readmeSchema = readmeSchemaStmt.executeQuery("DESCRIBE README");
                    readmeRs = readmeRsStmt.executeQuery("SELECT * FROM README");
                    vardefSchema = vardefSchemaStmt.executeQuery("DESCRIBE VARDEF");
                    vardefRs = vardefRsStmt.executeQuery("SELECT * FROM VARDEF");
                    stk = new StringTokenizer(lastQuery, ";");
                    gene = stk.nextToken().toUpperCase();
                    geneInfo = (GeneInfo)geneMatrix.get(gene);
                    chrom = geneInfo.getChrom();
                    if (geneInfo != null) {
                        temp = "(";
                        temp = temp + "chrom='" + chrom + "' AND ";
                        temp = temp + "chromEnd > " + (geneInfo.getTxsmin() - gend) + " AND ";
                        temp = temp + "chromEnd < " + (geneInfo.getTxsmax() + gend);
                        temp = temp + ")";
                    }
                    while (stk.hasMoreTokens()) {
                        gene = stk.nextToken().toUpperCase();
                        geneInfo = (GeneInfo)geneMatrix.get(gene);
                        chrom = geneInfo.getChrom();
                        if (geneInfo == null) continue;
                        temp = temp + " OR (";
                        temp = temp + "chrom='" + chrom + "' AND ";
                        temp = temp + "chromEnd > " + (geneInfo.getTxsmin() - gend) + " AND ";
                        temp = temp + "chromEnd < " + (geneInfo.getTxsmax() + gend);
                        temp = temp + ")";
                    }
                    sql = queryType.equals("ucsc") ? "SELECT " + FIELDS + " FROM TAMAL WHERE (" + temp + ")" : "SELECT * FROM TAMAL WHERE (" + temp + ")";
                    sql = sql + " AND (";
                    if (synon != null) {
                        sql = sql + " synon='" + synon + "' OR";
                    }
                    if (nonsynon != null) {
                        sql = sql + " nonsynon='" + nonsynon + "' OR";
                    }
                    if (splice != null) {
                        sql = sql + " splice='" + splice + "' OR";
                    }
                    if (intron != null) {
                        sql = sql + " intron='" + intron + "' OR";
                    }
                    if (promoter != null) {
                        sql = sql + " promoter='" + promoter + "' OR";
                    }
                    if (regpot != null) {
                        sql = sql + " regpot='" + regpot + "' OR";
                    }
                    if (tfbs != null) {
                        sql = sql + " tfbs='" + tfbs + "' OR";
                    }
                    if (p99 != null) {
                        sql = sql + " p99='" + p99 + "' OR";
                    }
                    if (gabrielMthd != null) {
                        if (ceu != null) {
                            sql = sql + " htSNPgab_CEU='" + ceu + "' OR";
                        }
                        if (hcb != null) {
                            sql = sql + " htSNPgab_HCB='" + hcb + "' OR";
                        }
                        if (jpt != null) {
                            sql = sql + " htSNPgab_JPT='" + jpt + "' OR";
                        }
                        if (yri != null) {
                            sql = sql + " htSNPgab_YRI='" + yri + "' OR";
                        }
                    }
                    if (taggerMthd != null) {
                        if (ceu != null) {
                            sql = sql + " htSNPtag_CEU='" + ceu + "' OR";
                        }
                        if (hcb != null) {
                            sql = sql + " htSNPtag_HCB='" + hcb + "' OR";
                        }
                        if (jpt != null) {
                            sql = sql + " htSNPtag_JPT='" + jpt + "' OR";
                        }
                        if (yri != null) {
                            sql = sql + " htSNPtag_YRI='" + yri + "' OR";
                        }
                    }
                    sql = sql.endsWith("AND ( ") ? sql.substring(0, sql.length() - 6) : sql.substring(0, sql.length() - 2);
                    sql = sql + " )";
                    log.debug((Object)("[TAMAL] sql: " + sql));
                    begin = System.currentTimeMillis();
                    rs = stmt.executeQuery(sql);
                    if (queryType.equals("ucsc")) {
                        rst = new ResultSetTAMAL(rs);
                        rs.close();
                    }
                    lastSql = sql;
                    end = System.currentTimeMillis();
                    log.debug((Object)("[TAMAL] Query Elapsed Time: " + (end - begin) + "ms"));
                }
            }
            if (queryType.equals("interact")) {
                geneMatrix.reset();
                int flags = RecTAMAL.createFilterFlags(ceu, hcb, jpt, yri, nonsynon, splice, synon, intron, promoter, p99, regpot, tfbs, gabrielMthd, taggerMthd);
                begin = System.currentTimeMillis();
                rst.beforeFirst();
                while (rst.next()) {
                    boolean found = false;
                    int curFlags = rst.getRec().getFlags();
                    boolean includeRow = (curFlags & flags) != 0;
                    Enumeration genes = geneMatrix.keys();
                    basepos = chromEnd = rst.getInt("chromEnd");
                    chromTmp = rst.getString("chrom");
                    while (genes.hasMoreElements()) {
                        gene = (String)genes.nextElement();
                        geneInfo = (GeneInfo)geneMatrix.get(gene);
                        chrom = geneInfo.getChrom();
                        txsmin = geneInfo.getTxsmin();
                        txsmax = geneInfo.getTxsmax();
                        dnaStart = txsmin < 0 ? 0 : txsmin - gend;
                        dnaEnd = txsmax + gend;
                        if (!chrom.equals(chromTmp) || basepos <= dnaStart || chromEnd >= dnaEnd) continue;
                        found = true;
                        geneInfo.setAllKnownSNPs(geneInfo.getAllKnownSNPs() + 1);
                        if (includeRow) {
                            geneInfo.setSNPstoGenotype(geneInfo.getSNPstoGenotype() + 1);
                        }
                        geneMatrix.put(gene, geneInfo);
                    }
                    if (!found) continue;
                    hitCnt += 1.0f;
                    if (!includeRow) continue;
                    if (gabrielMthd != null && (curFlags & RecTAMAL.HTSNPGAB_CEU_FG) > 0 || taggerMthd != null && (curFlags & RecTAMAL.HTSNPTAG_CEU_FG) > 0) {
                        ++ceuCnt;
                    }
                    if (gabrielMthd != null && (curFlags & RecTAMAL.HTSNPGAB_HCB_FG) > 0 || taggerMthd != null && (curFlags & RecTAMAL.HTSNPTAG_HCB_FG) > 0) {
                        ++hcbCnt;
                    }
                    if (gabrielMthd != null && (curFlags & RecTAMAL.HTSNPGAB_JPT_FG) > 0 || taggerMthd != null && (curFlags & RecTAMAL.HTSNPTAG_JPT_FG) > 0) {
                        ++jptCnt;
                    }
                    if (gabrielMthd != null && (curFlags & RecTAMAL.HTSNPGAB_YRI_FG) > 0 || taggerMthd != null && (curFlags & RecTAMAL.HTSNPTAG_YRI_FG) > 0) {
                        ++yriCnt;
                    }
                    if ((curFlags & RecTAMAL.SYNON_FG) > 0) {
                        ++synonCnt;
                    }
                    if ((curFlags & RecTAMAL.NONSYNON_FG) > 0) {
                        ++nonsynonCnt;
                    }
                    if ((curFlags & RecTAMAL.SPLICE_FG) > 0) {
                        ++spliceCnt;
                    }
                    if ((curFlags & RecTAMAL.INTRON_FG) > 0) {
                        ++intronCnt;
                    }
                    if ((curFlags & RecTAMAL.PROMOTER_FG) > 0) {
                        ++promoterCnt;
                    }
                    if ((curFlags & RecTAMAL.REGPOT_FG) > 0) {
                        ++regpotCnt;
                    }
                    if ((curFlags & RecTAMAL.TFBS_FG) > 0) {
                        ++tfbsCnt;
                    }
                    if ((curFlags & RecTAMAL.P99_FG) > 0) {
                        ++p99Cnt;
                    }
                    filteredHitCnt += 1.0f;
                }
                end = System.currentTimeMillis();
                log.debug((Object)("[TAMAL] Filter Elapsed: " + (end - begin) + "ms"));
                if (query != null) {
                    session.setAttribute("resultSetTAMAL", (Object)rst);
                }
                log.debug((Object)("[TAMAL] hitCnt: " + hitCnt));
                log.debug((Object)("[TAMAL] filteredHitCnt: " + filteredHitCnt));
                request.setAttribute("hitCnt", (Object)new Float(hitCnt));
                request.setAttribute("filteredHitCnt", (Object)new Float(filteredHitCnt));
                request.setAttribute("gend", (Object)Integer.toString(gend));
                request.setAttribute("gabrielMthd", (Object)gabrielMthd);
                request.setAttribute("taggerMthd", (Object)taggerMthd);
                request.setAttribute("ceu", (Object)ceu);
                request.setAttribute("hcb", (Object)hcb);
                request.setAttribute("jpt", (Object)jpt);
                request.setAttribute("yri", (Object)yri);
                request.setAttribute("ceuCnt", (Object)new Integer(ceuCnt));
                request.setAttribute("hcbCnt", (Object)new Integer(hcbCnt));
                request.setAttribute("jptCnt", (Object)new Integer(jptCnt));
                request.setAttribute("yriCnt", (Object)new Integer(yriCnt));
                request.setAttribute("synon", (Object)synon);
                request.setAttribute("nonsynon", (Object)nonsynon);
                request.setAttribute("splice", (Object)splice);
                request.setAttribute("intron", (Object)intron);
                request.setAttribute("synonCnt", (Object)new Integer(synonCnt));
                request.setAttribute("nonsynonCnt", (Object)new Integer(nonsynonCnt));
                request.setAttribute("spliceCnt", (Object)new Integer(spliceCnt));
                request.setAttribute("intronCnt", (Object)new Integer(intronCnt));
                request.setAttribute("promoter", (Object)promoter);
                request.setAttribute("regpot", (Object)regpot);
                request.setAttribute("tfbs", (Object)tfbs);
                request.setAttribute("p99", (Object)p99);
                request.setAttribute("promoterCnt", (Object)new Integer(promoterCnt));
                request.setAttribute("regpotCnt", (Object)new Integer(regpotCnt));
                request.setAttribute("tfbsCnt", (Object)new Integer(tfbsCnt));
                request.setAttribute("p99Cnt", (Object)new Integer(p99Cnt));
            }
            request.setAttribute("lastQuery", (Object)lastQuery);
            request.setAttribute("lastSql", (Object)lastSql);
            session.setAttribute("geneMatrix", (Object)geneMatrix);
            if (download != null && !queryType.equals("ucsc")) {
                request.setAttribute("resultSet", rs);
                request.setAttribute("tamalSchema", (Object)tamalSchema);
                request.setAttribute("readmeSchema", (Object)readmeSchema);
                request.setAttribute("readmeRs", (Object)readmeRs);
                request.setAttribute("vardefSchema", (Object)vardefSchema);
                request.setAttribute("vardefRs", (Object)vardefRs);
            }
            log.debug((Object)("[TAMAL] queryType: " + queryType));
            if (queryType.equals("xml")) {
                this.jspForward(request, response, "/snp/review_xml.jsp");
            } else if (queryType.equals("excel")) {
                this.jspForward(request, response, "/snp/review_excel.jsp");
            } else if (queryType.equals("ucsc")) {
                request.setAttribute("ucscQuery", (Object)ucscQuery);
                geneInfo = (GeneInfo)geneMatrix.get(ucscQuery);
                chrom = geneInfo.getChrom();
                txsmin = geneInfo.getTxsmin();
                txsmax = geneInfo.getTxsmax();
                dnaStart = txsmin < 0 ? 0 : txsmin - gend;
                dnaEnd = txsmax + gend;
                begin = System.currentTimeMillis();
                this.createTrackFile(ucscQuery, chrom, dnaStart, dnaEnd, gabrielMthd, taggerMthd, ceu, hcb, jpt, yri, synon, nonsynon, splice, intron, promoter, regpot, tfbs, p99, (ResultSetTAMAL)session.getAttribute("resultSetTAMAL"), rst);
                end = System.currentTimeMillis();
                log.debug((Object)("[TAMAL] Track Elapsed: " + (end - begin) + "ms"));
                this.jspForward(request, response, "/snp/review_ucsc.jsp");
            } else {
                this.jspForward(request, response, "/snp/review_interact.jsp");
            }
        }
        catch (Exception e) {
            log.debug((Object)("[TAMAL] " + e.getMessage()));
        }
    }

    private void jspForward(HttpServletRequest req, HttpServletResponse resp, String url) throws ServletException, IOException {
        req.getRequestDispatcher(url).forward((ServletRequest)req, (ServletResponse)resp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

