/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.core.DC;

public class QueryArgs {
    private String query;
    private int start = 0;
    private int pageSize = 50;
    private int maxReturns = 1000;

    public void setQuery(String newQuery) {
        this.query = newQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setStart(int newStart) {
        this.start = newStart;
    }

    public int getStart() {
        return this.start;
    }

    public void setPageSize(int newSize) {
        this.pageSize = newSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getMaxReturns() {
        return this.maxReturns;
    }

    public String[] buildQuery(HttpServletRequest request, String advanced, String simplequery) {
        StringTokenizer st;
        String[] newquery = new String[DC.DCN_FT];
        if (!advanced.equals("true")) {
            newquery[0] = simplequery;
            for (int i = 1; i < DC.DCN_FT; ++i) {
                newquery[i] = simplequery;
            }
            return newquery;
        }
        newquery[0] = "(";
        boolean firstKeyword = true;
        for (int i = 1; i < DC.DCN_FT; ++i) {
            newquery[i] = request.getParameter(DC.dcName[i]);
            if (newquery[i] != null && newquery[i].length() > 0) {
                if (firstKeyword) {
                    firstKeyword = false;
                } else {
                    newquery[0] = newquery[0] + " AND ";
                }
                if (DC.dcName[i].equals("Date")) {
                    st = new StringTokenizer(newquery[i], "-");
                    newquery[i] = "";
                    if (st.hasMoreTokens()) {
                        int n = i;
                        newquery[n] = newquery[n] + st.nextToken();
                    }
                    while (st.hasMoreTokens()) {
                        int n = i;
                        newquery[n] = newquery[n] + "?";
                        int n2 = i;
                        newquery[n2] = newquery[n2] + st.nextToken();
                    }
                    newquery[0] = newquery[0] + "(Date:[" + newquery[i] + "])";
                    continue;
                }
                newquery[0] = newquery[0] + this.buildQueryPart(newquery[i], DC.dcName[i]);
                continue;
            }
            newquery[i] = "";
        }
        String dfrom = request.getParameter("Dfrom");
        String dto = request.getParameter("Dto");
        if (dfrom != null && dto != null && dfrom.length() > 0 && dto.length() > 0) {
            String dquery = "(Date:[" + dfrom + " TO " + dto + "])";
            st = new StringTokenizer(dquery, "-");
            dquery = "";
            if (st.hasMoreTokens()) {
                dquery = dquery + st.nextToken();
            }
            while (st.hasMoreTokens()) {
                dquery = dquery + "?";
                dquery = dquery + st.nextToken();
            }
            if (!firstKeyword) {
                newquery[0] = newquery[0] + " AND ";
            }
            newquery[DC.DC_DATE] = dfrom + " TO " + dto;
            newquery[0] = newquery[0] + dquery;
        }
        newquery[0] = newquery[0] + ")";
        return newquery;
    }

    private String buildQueryPart(String myquery, String myfield) {
        Perl5Util util = new Perl5Util();
        String newquery = "(";
        String pattern = "";
        if (!myfield.equals("Date")) {
            newquery = newquery + myfield + ":";
            if (!util.match("/\".*\"/", myquery = util.substitute("s/'(.*)'/\"$1\"/g", myquery))) {
                myquery = util.substitute("s/ / " + myfield + ":/g", myquery);
            }
        } else {
            newquery = newquery + myfield + ":" + myquery;
        }
        newquery = newquery + myquery + ")";
        return newquery;
    }

    public HashMap buildQueryHash(HttpServletRequest request) {
        HashMap<String, String> queryHash = new HashMap<String, String>();
        queryHash.put("query1", request.getParameter("query1") == null ? "" : request.getParameter("query1"));
        queryHash.put("query2", request.getParameter("query2") == null ? "" : request.getParameter("query2"));
        queryHash.put("query3", request.getParameter("query3") == null ? "" : request.getParameter("query3"));
        queryHash.put("field1", request.getParameter("field1") == null ? "ANY" : request.getParameter("field1"));
        queryHash.put("field2", request.getParameter("field2") == null ? "ANY" : request.getParameter("field2"));
        queryHash.put("field3", request.getParameter("field3") == null ? "ANY" : request.getParameter("field3"));
        queryHash.put("conjunction1", request.getParameter("conjunction1") == null ? "AND" : request.getParameter("conjunction1"));
        queryHash.put("conjunction2", request.getParameter("conjunction2") == null ? "AND" : request.getParameter("conjunction1"));
        return queryHash;
    }

    public String buildHTTPQuery(HttpServletRequest request) {
        String querystring = "";
        HashMap queryHash = this.buildQueryHash(request);
        Iterator i = queryHash.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)queryHash.get(key);
            querystring = querystring + "&" + key + "=" + value;
        }
        return querystring;
    }
}

