/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import com.google.soap.search.GoogleSearch;
import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;

public class GoogleAPIDemo {
    public static void main(String[] args) {
        String clientKey = "7atUvTpQFHLvN3UWrph0aNq/jPvrw1fN";
        if (args.length < 2) {
            GoogleAPIDemo.printUsageAndExit();
        }
        String directive = args[0];
        String directiveArg = args[1];
        System.out.println("Parameters:");
        System.out.println("Directive  = " + directive);
        System.out.println("Args       = " + directiveArg);
        GoogleSearch s = new GoogleSearch();
        s.setKey(clientKey);
        try {
            if (directive.equalsIgnoreCase("search")) {
                s.setQueryString(directiveArg);
                GoogleSearchResult r = s.doSearch();
                System.out.println("Google Search Results:");
                System.out.println("======================");
                System.out.println(r.toString());
            } else if (directive.equalsIgnoreCase("cached")) {
                System.out.println("Cached page:");
                System.out.println("============");
                byte[] cachedBytes = s.doGetCachedPage(directiveArg);
                String cachedString = new String(cachedBytes);
                System.out.println(cachedString);
            } else if (directive.equalsIgnoreCase("spell")) {
                System.out.println("Spelling suggestion:");
                String suggestion = s.doSpellingSuggestion(directiveArg);
                System.out.println(suggestion);
            } else {
                GoogleAPIDemo.printUsageAndExit();
            }
        }
        catch (GoogleSearchFault f) {
            System.out.println("The call to the Google Web APIs failed:");
            System.out.println(f.toString());
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: googleAPIDemo  (search <query> | cached <url> | spell <phrase>)");
        System.err.println("e.g., googleAPIDemo search carpel+factory");
        System.exit(1);
    }
}

