/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;

public class GeneSearchStat {
    public static int ftCnt = 0;
    public static int ftInstCnt = 0;
    public static int anyCnt = 0;
    public static int anyInstCnt = 0;
    public static int bothCnt = 0;
    public static int bothNotCnt = 0;
    public static int ftPnasCnt = 0;
    public static int ftAjpCnt = 0;
    public static int ftAgpCnt = 0;
    public static int ftAjhgCnt = 0;
    public static int ftOtherCnt = 0;
    public static int anyPnasCnt = 0;
    public static int anyAjpCnt = 0;
    public static int anyAgpCnt = 0;
    public static int anyAjhgCnt = 0;
    public static int anyOtherCnt = 0;
    public static int ftPcCnt = 0;
    public static int ftPpCnt = 0;
    public static int ftGdCnt = 0;
    public static int ftJebCnt = 0;
    public static int anyPcCnt = 0;
    public static int anyPpCnt = 0;
    public static int anyGdCnt = 0;
    public static int anyJebCnt = 0;

    public static void count(ResultSet rs, String gene) throws Exception {
        Vector<String> descriptions = new Vector<String>();
        String reg = ".\\W" + gene + "\\W";
        Pattern pattern = Pattern.compile(reg);
        ftCnt = 0;
        ftInstCnt = 0;
        anyCnt = 0;
        anyInstCnt = 0;
        bothCnt = 0;
        bothNotCnt = 0;
        ftPnasCnt = 0;
        ftAjpCnt = 0;
        ftAgpCnt = 0;
        ftAjhgCnt = 0;
        ftOtherCnt = 0;
        anyPnasCnt = 0;
        anyAjpCnt = 0;
        anyAgpCnt = 0;
        anyAjhgCnt = 0;
        anyOtherCnt = 0;
        ftPcCnt = 0;
        ftPpCnt = 0;
        ftGdCnt = 0;
        ftJebCnt = 0;
        anyPcCnt = 0;
        anyPpCnt = 0;
        anyGdCnt = 0;
        anyJebCnt = 0;
        rs.beforeFirst();
        while (rs.next()) {
            String title = rs.getString(1);
            Matcher titleMatcher = pattern.matcher(title);
            boolean matchTitle = titleMatcher.find();
            String description = rs.getString(2);
            Matcher descriptionMatcher = pattern.matcher(description);
            boolean matchDescription = descriptionMatcher.find();
            if (matchDescription && descriptions.contains(description)) continue;
            descriptions.add(description);
            String fulltxt = rs.getString(3);
            Matcher fulltxtMatcher = pattern.matcher(fulltxt);
            boolean matchFulltxt = fulltxtMatcher.find();
            String identifier = rs.getString(4);
            if (!matchTitle && !matchDescription && matchFulltxt) {
                ++ftCnt;
                fulltxtMatcher.reset();
                while (fulltxtMatcher.find()) {
                    ++ftInstCnt;
                }
                if (Config.GENE_TYPE.equals("human")) {
                    if (identifier.startsWith("http://www.pnas.org")) {
                        ++ftPnasCnt;
                    } else if (identifier.startsWith("http://ajp.psychiatryonline.org")) {
                        ++ftAjpCnt;
                    } else if (identifier.startsWith("http://archpsyc.ama-assn.org")) {
                        ++ftAgpCnt;
                    } else if (identifier.startsWith("http://www.journals.uchicago.edu")) {
                        ++ftAjhgCnt;
                    } else {
                        ++ftOtherCnt;
                    }
                } else if (identifier.startsWith("http://www.pnas.org")) {
                    ++ftPnasCnt;
                } else if (identifier.startsWith("http://www.plantcell.org")) {
                    ++ftPcCnt;
                } else if (identifier.startsWith("http://www.plantphysiol.org")) {
                    ++ftPpCnt;
                } else if (identifier.startsWith("http://www.genesdev.org")) {
                    ++ftGdCnt;
                } else if (identifier.startsWith("http://jxb.oupjournals.org")) {
                    ++ftJebCnt;
                } else {
                    ++ftOtherCnt;
                }
            }
            if (matchTitle || matchDescription || matchFulltxt) {
                ++anyCnt;
                titleMatcher.reset();
                descriptionMatcher.reset();
                fulltxtMatcher.reset();
                while (titleMatcher.find()) {
                    ++anyInstCnt;
                }
                while (descriptionMatcher.find()) {
                    ++anyInstCnt;
                }
                while (fulltxtMatcher.find()) {
                    ++anyInstCnt;
                }
                if (Config.GENE_TYPE.equals("human")) {
                    if (identifier.startsWith("http://www.pnas.org")) {
                        ++anyPnasCnt;
                    } else if (identifier.startsWith("http://ajp.psychiatryonline.org")) {
                        ++anyAjpCnt;
                    } else if (identifier.startsWith("http://archpsyc.ama-assn.org")) {
                        ++anyAgpCnt;
                    } else if (identifier.startsWith("http://www.journals.uchicago.edu")) {
                        ++anyAjhgCnt;
                    } else {
                        ++anyOtherCnt;
                    }
                } else if (identifier.startsWith("http://www.pnas.org")) {
                    ++anyPnasCnt;
                } else if (identifier.startsWith("http://www.plantcell.org")) {
                    ++anyPcCnt;
                } else if (identifier.startsWith("http://www.plantphysiol.org")) {
                    ++anyPpCnt;
                } else if (identifier.startsWith("http://www.genesdev.org")) {
                    ++anyGdCnt;
                } else if (identifier.startsWith("http://jxb.oupjournals.org")) {
                    ++anyJebCnt;
                } else {
                    ++anyOtherCnt;
                }
            }
            if ((matchTitle || matchDescription) && matchFulltxt) {
                ++bothCnt;
            }
            if (matchTitle || matchDescription || matchFulltxt) continue;
            ++bothNotCnt;
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String gene;
        ResultSet rs;
        String sql;
        Connection dbConn = null;
        Vector<String> genes = new Vector<String>();
        Perl5Util util = new Perl5Util();
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        if (args.length < 1) {
            sql = "SELECT DISTINCT geneSymbol FROM kgXref";
            rs = stmt.executeQuery(sql);
            rs.beforeFirst();
            while (rs.next()) {
                genes.add(rs.getString(1).toUpperCase());
            }
        } else {
            BufferedReader gIn = new BufferedReader(new FileReader(args[0]));
            while ((gene = gIn.readLine()) != null) {
                if (gene.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(gene);
                st.nextToken();
                gene = st.nextToken().toUpperCase();
                if (genes.contains(gene)) continue;
                genes.add(gene);
            }
        }
        for (int i = 0; i < genes.size(); ++i) {
            gene = (String)genes.get(i);
            if (gene.length() < 3 || !util.match("m/\\D/i", gene) || util.match("m/[({]/", gene)) continue;
            gene = util.substitute("s/'/\\\\'/g", gene);
            gene = util.substitute("s/[,:]/-/g", gene);
            gene = util.substitute("s/\\s/-/g", gene);
            sql = "SELECT title, description, fulltxt, identifier FROM " + Config.METADATA_STR + " WHERE";
            sql = sql + " MATCH (";
            sql = sql + "title, description, fulltxt";
            sql = sql + ") AGAINST ('+\"" + gene + "\"";
            sql = sql + "' IN BOOLEAN MODE)";
            sql = sql + " AND length(description) > 0";
            rs = stmt.executeQuery(sql);
            GeneSearchStat.count(rs, gene);
            System.out.print(gene + ": " + ftCnt + "," + anyCnt + "," + ftInstCnt + "," + anyInstCnt + ",");
            System.out.print(bothCnt + "," + bothNotCnt + ",");
            if (Config.GENE_TYPE.equals("human")) {
                System.out.print(ftPnasCnt + "," + anyPnasCnt + "," + ftAjpCnt + "," + anyAjpCnt + ",");
                System.out.print(ftAgpCnt + "," + anyAgpCnt + "," + ftAjhgCnt + "," + anyAjhgCnt + ",");
            } else {
                System.out.print(ftPnasCnt + "," + anyPnasCnt + "," + ftPcCnt + "," + anyPcCnt + ",");
                System.out.print(ftPpCnt + "," + anyPpCnt + "," + ftGdCnt + "," + anyGdCnt + ",");
                System.out.print(ftJebCnt + "," + anyJebCnt + ",");
            }
            System.out.println(ftOtherCnt + "," + anyOtherCnt);
        }
        System.out.println("Done with profiling!");
    }
}

