/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.neoref.config.Config;

public class DBProfilerPgReview
extends Thread {
    DBProfilerPgReview() {
    }

    public static int count(ResultSet rs, String gene, boolean ftOnly) throws Exception {
        gene = gene.toLowerCase();
        int cnt = 0;
        rs.beforeFirst();
        while (rs.next()) {
            if (ftOnly) {
                String title = rs.getString("title").toLowerCase();
                String description = rs.getString("description").toLowerCase();
                if (title.indexOf(gene) != -1 || description.indexOf(gene) != -1) continue;
            }
            ++cnt;
        }
        return cnt;
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String gene;
        Connection dbConn = null;
        ArrayList<String> genes = new ArrayList<String>();
        if (args.length < 1) {
            System.out.println("Usage: dbProfilePgReview gene_file");
            System.exit(-1);
        }
        BufferedReader gIn = new BufferedReader(new FileReader(args[0]));
        while ((gene = gIn.readLine()) != null) {
            genes.add(gene);
        }
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        for (int i = 0; i < genes.size(); ++i) {
            gene = (String)genes.get(i);
            String sql = "SELECT id, title, description FROM metadata WHERE";
            sql = sql + " MATCH (";
            sql = sql + "fulltxt";
            sql = sql + ") AGAINST ('+" + gene;
            sql = sql + "' IN BOOLEAN MODE)";
            sql = sql + " AND identifier REGEXP 'pdf'";
            ResultSet rs = stmt.executeQuery(sql);
            int ftCnt1 = DBProfilerPgReview.count(rs, gene, true);
            sql = "SELECT id, title, description FROM metadata WHERE";
            sql = sql + " MATCH (";
            sql = sql + "title, description, fulltxt";
            sql = sql + ") AGAINST ('+" + gene;
            sql = sql + "' IN BOOLEAN MODE)";
            sql = sql + " AND identifier REGEXP 'pdf'";
            rs = stmt.executeQuery(sql);
            int anyCnt1 = DBProfilerPgReview.count(rs, gene, false);
            System.out.println(gene + ": " + ftCnt1 + "," + anyCnt1);
        }
        System.out.println("Done with profiling!");
    }
}

