/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;

public class DBProfilerPgPaper {
    public static int ftCnt = 0;
    public static int ftInstCnt = 0;
    public static int anyCnt = 0;
    public static int anyInstCnt = 0;
    public static int ftPnasCnt = 0;
    public static int ftAjpCnt = 0;
    public static int ftAgpCnt = 0;
    public static int ftAjhgCnt = 0;
    public static int anyPnasCnt = 0;
    public static int anyAjpCnt = 0;
    public static int anyAgpCnt = 0;
    public static int anyAjhgCnt = 0;

    public static void count(ResultSet rs, String gene) throws Exception {
        Vector<String> descriptions = new Vector<String>();
        String reg = ".\\W" + gene + "\\W";
        Pattern pattern = Pattern.compile(reg, 2);
        ftCnt = 0;
        ftInstCnt = 0;
        anyCnt = 0;
        anyInstCnt = 0;
        ftPnasCnt = 0;
        ftAjpCnt = 0;
        ftAgpCnt = 0;
        ftAjhgCnt = 0;
        anyPnasCnt = 0;
        anyAjpCnt = 0;
        anyAgpCnt = 0;
        anyAjhgCnt = 0;
        rs.beforeFirst();
        while (rs.next()) {
            String title = rs.getString("title");
            Matcher titleMatcher = pattern.matcher(title);
            boolean matchTitle = titleMatcher.find();
            String description = rs.getString("description");
            Matcher descriptionMatcher = pattern.matcher(description);
            boolean matchDescription = descriptionMatcher.find();
            if (matchDescription && descriptions.contains(description)) continue;
            descriptions.add(description);
            String fulltxt = rs.getString("fulltxt");
            Matcher fulltxtMatcher = pattern.matcher(fulltxt);
            boolean matchFulltxt = fulltxtMatcher.find();
            String identifier = rs.getString("identifier");
            if (!matchTitle && !matchDescription && matchFulltxt) {
                ++ftCnt;
                fulltxtMatcher.reset();
                while (fulltxtMatcher.find()) {
                    ++ftInstCnt;
                }
                if (identifier.startsWith("http://www.pnas.org")) {
                    ++ftPnasCnt;
                } else if (identifier.startsWith("http://ajp.psychiatryonline.org")) {
                    ++ftAjpCnt;
                } else if (identifier.startsWith("http://archpsyc.ama-assn.org")) {
                    ++ftAgpCnt;
                } else if (identifier.startsWith("http://www.journals.uchicago.edu")) {
                    ++ftAjhgCnt;
                }
            }
            if (!matchTitle && !matchDescription && !matchFulltxt) continue;
            ++anyCnt;
            titleMatcher.reset();
            descriptionMatcher.reset();
            fulltxtMatcher.reset();
            while (titleMatcher.find()) {
                ++anyInstCnt;
            }
            while (descriptionMatcher.find()) {
                ++anyInstCnt;
            }
            while (fulltxtMatcher.find()) {
                ++anyInstCnt;
            }
            if (identifier.startsWith("http://www.pnas.org")) {
                ++anyPnasCnt;
                continue;
            }
            if (identifier.startsWith("http://ajp.psychiatryonline.org")) {
                ++anyAjpCnt;
                continue;
            }
            if (identifier.startsWith("http://archpsyc.ama-assn.org")) {
                ++anyAgpCnt;
                continue;
            }
            if (!identifier.startsWith("http://www.journals.uchicago.edu")) continue;
            ++anyAjhgCnt;
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        String gene;
        ResultSet rs;
        String sql;
        Connection dbConn = null;
        Vector<String> genes = new Vector<String>();
        Perl5Util util = new Perl5Util();
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        if (args.length < 1) {
            sql = "SELECT DISTINCT geneSymbol FROM kgXref";
            rs = stmt.executeQuery(sql);
            rs.beforeFirst();
            while (rs.next()) {
                genes.add(rs.getString("geneSymbol").toUpperCase());
            }
        } else {
            BufferedReader gIn = new BufferedReader(new FileReader(args[0]));
            while ((gene = gIn.readLine()) != null) {
                if (gene.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(gene);
                st.nextToken();
                gene = st.nextToken().toUpperCase();
                if (genes.contains(gene)) continue;
                genes.add(gene);
            }
        }
        for (int i = 0; i < genes.size(); ++i) {
            gene = (String)genes.get(i);
            if (gene.length() < 3 || !util.match("m/\\D/i", gene) || util.match("m/[({]/", gene)) continue;
            gene = util.substitute("s/'/\\\\'/g", gene);
            sql = "SELECT id, title, description, fulltxt, identifier FROM metadata WHERE";
            sql = sql + " MATCH (";
            sql = sql + "title, description, fulltxt";
            sql = sql + ") AGAINST ('+\"" + gene + "\"";
            sql = sql + "' IN BOOLEAN MODE)";
            sql = sql + " AND length(description) > 0";
            rs = stmt.executeQuery(sql);
            DBProfilerPgPaper.count(rs, gene);
            System.out.print(gene + ": " + ftCnt + "," + anyCnt + "," + ftInstCnt + "," + anyInstCnt + ",");
            System.out.print(ftPnasCnt + "," + anyPnasCnt + "," + ftAjpCnt + "," + anyAjpCnt + ",");
            System.out.println(ftAgpCnt + "," + anyAgpCnt + "," + ftAjhgCnt + "," + anyAjhgCnt);
        }
        System.out.println("Done with profiling!");
    }
}

