/*
 * Decompiled with CFR 0.152.
 */
package org.neoref.profile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;
import org.neoref.config.Config;
import org.neoref.core.DC;
import org.neoref.core.Meta;
import org.neoref.query.NRQuery;
import org.neoref.query.QueryArgs;
import org.neoref.query.QueryResults;

public class DBProfilerHg
extends Thread {
    public static int GENE_CNT = 12;
    public static final String[] geneSymbol = new String[GENE_CNT];
    String atStr;
    Vector atVec;
    int graph;

    DBProfilerHg(String atStr, Vector atVec, int graph) {
        this.atStr = atStr;
        this.atVec = atVec;
        this.graph = graph;
    }

    public static void init() {
        DBProfilerHg.geneSymbol[0] = "AKT1";
        DBProfilerHg.geneSymbol[1] = "COMT";
        DBProfilerHg.geneSymbol[2] = "DISC1";
        DBProfilerHg.geneSymbol[3] = "DRD3";
        DBProfilerHg.geneSymbol[4] = "DTNBP1";
        DBProfilerHg.geneSymbol[5] = "G30";
        DBProfilerHg.geneSymbol[6] = "HTR2A";
        DBProfilerHg.geneSymbol[7] = "NRG1";
        DBProfilerHg.geneSymbol[8] = "PRODH";
        DBProfilerHg.geneSymbol[9] = "RGS4";
        DBProfilerHg.geneSymbol[10] = "SLC6A4";
        DBProfilerHg.geneSymbol[11] = "ZDHHC8";
    }

    public void run() {
        try {
            String at;
            int m;
            int k;
            String field;
            int j;
            DC dc;
            int size;
            int i;
            int metaCount = 0;
            int ftCount = 0;
            int allCount = 0;
            QueryResults qResults = null;
            QueryArgs qArgs = new QueryArgs();
            String[] qArray = new String[DC.DCN_FT];
            Perl5Util util = new Perl5Util();
            DC.init();
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                if (i == DC.DC_FULLTXT || i == DC.DC_IDENTIFIER) continue;
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, true);
            List res = qResults.getAllHitIDs();
            metaCount = res.size();
            int metaInstCount = 0;
            for (i = 0; i < metaCount; ++i) {
                size = this.atVec.size();
                dc = Meta.getRecordFT(new Integer((String)res.get(i)));
                for (j = 1; j < DC.DCN_FT; ++j) {
                    if (j == DC.DC_FULLTXT || j == DC.DC_MESH || (field = ((String)dc.value.get(j)).toLowerCase()) == null || field.length() == 0) continue;
                    for (k = 0; k < size; ++k) {
                        m = 0;
                        at = ((String)this.atVec.elementAt(k)).toLowerCase();
                        while (m != -1) {
                            if ((m = field.indexOf(at, m + 1)) == -1) continue;
                            ++metaInstCount;
                        }
                    }
                }
            }
            qArray[0] = "(" + DC.dcName[DC.DC_FULLTXT].toLowerCase() + ":" + this.atStr + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, true);
            res = qResults.getAllHitIDs();
            ftCount = res.size();
            int ftInstCount = 0;
            for (i = 0; i < ftCount; ++i) {
                size = this.atVec.size();
                dc = Meta.getRecordFT(new Integer((String)res.get(i)));
                for (j = 1; j < DC.DCN_FT; ++j) {
                    if (j != DC.DC_FULLTXT || (field = ((String)dc.value.get(j)).toLowerCase()) == null || field.length() == 0) continue;
                    for (k = 0; k < size; ++k) {
                        m = 0;
                        at = ((String)this.atVec.elementAt(k)).toLowerCase();
                        while (m != -1) {
                            if ((m = field.indexOf(at, m + 1)) == -1) continue;
                            ++ftInstCount;
                        }
                    }
                }
            }
            qArray[0] = "((" + DC.dcName[0].toLowerCase() + ":" + this.atStr + ")";
            for (i = 1; i < DC.DCN_FT; ++i) {
                qArray[0] = qArray[0] + " OR (" + DC.dcName[i].toLowerCase() + ":" + this.atStr + ")";
            }
            qArray[0] = qArray[0] + ")";
            qArgs.setQuery(qArray[0]);
            qArgs.setStart(0);
            qResults = NRQuery.doQuery(qArgs, true);
            allCount = qResults.getHitCount();
            if (this.graph == 0) {
                System.out.println(this.atStr + "," + metaCount + "," + ftCount + "," + metaInstCount + "," + ftInstCount);
            } else {
                System.out.println(metaCount + "," + ftCount + "," + metaInstCount + "," + ftInstCount);
            }
        }
        catch (Exception e) {
            DBProfilerHg.log("Error message: " + e.getMessage());
        }
    }

    public static void log(String entry) {
        System.out.println(new Date() + ":" + entry);
    }

    public static void main(String[] args) throws Exception {
        int graph = 0;
        Connection dbConn = null;
        if (args.length < 1) {
            System.out.println("Usage: dbprofilehg graph");
            System.out.println("graph: 1 for output formatted for octave plotting; 0 for text file output");
            System.exit(-1);
        }
        graph = Integer.parseInt(args[0]);
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        dbConn = DriverManager.getConnection(Config.SEARCHDB_STR);
        Statement stmt = dbConn.createStatement();
        DBProfilerHg.init();
        Vector<String> atVec = new Vector<String>();
        for (int i = 0; i < geneSymbol.length; ++i) {
            ResultSet rs = stmt.executeQuery("select * from kgXref where geneSymbol='" + geneSymbol[i] + "';");
            if (!rs.next()) continue;
            rs.beforeFirst();
            atVec.clear();
            String atStr = "\"" + geneSymbol[i] + "\"";
            atVec.add(geneSymbol[i]);
            while (rs.next()) {
                String temp = rs.getString("kgID");
                if (!atVec.contains(temp)) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("mRNA"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("spID"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("spDisplayID"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (!atVec.contains(temp = rs.getString("refseq"))) {
                    atStr = atStr + " OR ";
                    atStr = atStr + "\"" + temp + "\"";
                    atVec.add(temp);
                }
                if (atVec.contains(temp = rs.getString("protAcc"))) continue;
                atStr = atStr + " OR ";
                atStr = atStr + "\"" + temp + "\"";
                atVec.add(temp);
            }
            atStr = "(" + atStr + ")";
            DBProfilerHg pf = new DBProfilerHg(atStr, atVec, graph);
            pf.start();
            pf.join();
        }
        System.out.println("Done with profiling!");
    }
}

