/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.util.Hashtable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.getopt.luke.TermInfo;
import org.getopt.luke.TermInfoQueue;

public class HighFreqTerms {
    public static int defaultNumTerms = 100;

    public static void main(String[] stringArray) throws Exception {
        FSDirectory fSDirectory = FSDirectory.getDirectory((String)stringArray[0], (boolean)false);
        TermInfo[] termInfoArray = HighFreqTerms.getHighFreqTerms((Directory)fSDirectory, null, new String[]{"body"});
        for (int i = 0; i < termInfoArray.length; ++i) {
            System.out.println(i + ".\t" + termInfoArray[i].term);
        }
    }

    public static TermInfo[] getHighFreqTerms(Directory directory, Hashtable hashtable, String[] stringArray) throws Exception {
        return HighFreqTerms.getHighFreqTerms(directory, hashtable, defaultNumTerms, stringArray);
    }

    public static TermInfo[] getHighFreqTerms(Directory directory, Hashtable hashtable, int n, String[] stringArray) throws Exception {
        int n2;
        TermInfo[] termInfoArray;
        if (directory == null || stringArray == null) {
            return null;
        }
        IndexReader indexReader = IndexReader.open((Directory)directory);
        TermInfoQueue termInfoQueue = new TermInfoQueue(n);
        TermEnum termEnum = indexReader.terms();
        int n3 = 0;
        while (termEnum.next()) {
            termInfoArray = termEnum.term().field();
            if (stringArray != null && stringArray.length > 0) {
                n2 = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!termInfoArray.equals(stringArray[i])) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) continue;
            }
            if (hashtable != null && hashtable.get(termEnum.term().text()) != null || termEnum.docFreq() <= n3) continue;
            termInfoQueue.put(new TermInfo(termEnum.term(), termEnum.docFreq()));
            if (termInfoQueue.size() < n) continue;
            termInfoQueue.pop();
            n3 = ((TermInfo)termInfoQueue.top()).docFreq;
        }
        termInfoArray = new TermInfo[termInfoQueue.size()];
        for (n2 = 0; n2 < termInfoArray.length; ++n2) {
            termInfoArray[termInfoArray.length - n2 - 1] = (TermInfo)termInfoQueue.pop();
        }
        indexReader.close();
        return termInfoArray;
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir>\n\n");
    }
}

