/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

class MultiFieldSortedHitQueue
extends PriorityQueue {
    protected ScoreDocComparator[] comparators;
    protected SortField[] fields;
    protected float maxscore = 1.0f;

    MultiFieldSortedHitQueue(IndexReader reader, SortField[] fields, int size) throws IOException {
        int n = fields.length;
        this.comparators = new ScoreDocComparator[n];
        this.fields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            String fieldname = fields[i].getField();
            this.comparators[i] = FieldSortedHitQueue.getCachedComparator((IndexReader)reader, (String)fieldname, (int)fields[i].getType(), (SortComparatorSource)fields[i].getFactory());
            this.fields[i] = new SortField(fieldname, this.comparators[i].sortType(), fields[i].getReverse());
        }
        this.initialize(size);
    }

    protected final boolean lessThan(Object a, Object b) {
        ScoreDoc docA = (ScoreDoc)a;
        ScoreDoc docB = (ScoreDoc)b;
        if (docA.score > this.maxscore) {
            this.maxscore = docA.score;
        }
        if (docB.score > this.maxscore) {
            this.maxscore = docB.score;
        }
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.fields[i].reverse ? this.comparators[i].compareReverse(docA, docB) : this.comparators[i].compare(docA, docB);
        }
        return c > 0;
    }

    FieldDoc fillFields(FieldDoc doc) {
        int n = this.comparators.length;
        Comparable[] fields = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].sortValue(doc);
        }
        doc.fields = fields;
        if (this.maxscore > 1.0f) {
            doc.score /= this.maxscore;
        }
        return doc;
    }

    SortField[] getFields() {
        return this.fields;
    }
}

