/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocLookupComparator;

class FloatSortedHitQueue
extends FieldSortedHitQueue {
    FloatSortedHitQueue(IndexReader reader, String float_field, int size) throws IOException {
        super(reader, float_field, size);
    }

    protected ScoreDocLookupComparator createComparator(IndexReader reader, String field) throws IOException {
        return FloatSortedHitQueue.comparator(reader, field);
    }

    static ScoreDocLookupComparator comparator(IndexReader reader, String fieldname) throws IOException {
        TermEnum enumerator = reader.terms(new Term(fieldname, ""));
        return FloatSortedHitQueue.comparator(reader, enumerator, fieldname);
    }

    static ScoreDocLookupComparator comparator(final IndexReader reader, final TermEnum enumerator, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocLookupComparator(){
            protected final float[] fieldOrder = this.generateSortIndex();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final float[] generateSortIndex() throws IOException {
                float[] retArray = new float[reader.maxDoc()];
                if (retArray.length > 0) {
                    TermDocs termDocs = reader.termDocs();
                    try {
                        if (enumerator.term() == null) {
                            throw new RuntimeException("no terms in field " + field);
                        }
                        do {
                            Term term;
                            if ((term = enumerator.term()).field() != field) {
                                break;
                            }
                            float termval = Float.parseFloat(term.text());
                            termDocs.seek(enumerator);
                            while (termDocs.next()) {
                                retArray[termDocs.doc()] = termval;
                            }
                        } while (enumerator.next());
                    }
                    finally {
                        termDocs.close();
                    }
                }
                return retArray;
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                float fi = this.fieldOrder[i.doc];
                float fj = this.fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public final int compareReverse(ScoreDoc i, ScoreDoc j) {
                float fi = this.fieldOrder[i.doc];
                float fj = this.fieldOrder[j.doc];
                if (fi > fj) {
                    return -1;
                }
                if (fi < fj) {
                    return 1;
                }
                return 0;
            }

            public final boolean sizeMatches(int n) {
                return this.fieldOrder.length == n;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Float(this.fieldOrder[i.doc]);
            }

            public int sortType() {
                return 5;
            }
        };
    }
}

