/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.util.PDFTextStripper;

public class PDFHighlighter
extends PDFTextStripper {
    private Writer highlighterOutput = null;
    private Color highlightColor = Color.YELLOW;
    private String[] searchedWords;
    private ByteArrayOutputStream textOS = null;
    private Writer textWriter = null;
    static /* synthetic */ Class class$org$pdfbox$util$PDFHighlighter;

    public PDFHighlighter() throws IOException {
        super.setLineSeparator("");
        super.setPageSeparator("");
        super.setWordSeparator("");
        super.setShouldSeparateByBeads(false);
        super.setSuppressDuplicateOverlappingText(false);
    }

    public void generateXMLHighlight(PDDocument pdDocument, String highlightWord, Writer xmlOutput) throws IOException {
        this.generateXMLHighlight(pdDocument, new String[]{highlightWord}, xmlOutput);
    }

    public void generateXMLHighlight(PDDocument pdDocument, String[] sWords, Writer xmlOutput) throws IOException {
        this.highlighterOutput = xmlOutput;
        this.searchedWords = sWords;
        this.highlighterOutput.write("<XML>\n<Body units=characters color=#" + this.getHighlightColorAsString() + " mode=active version=2>\n<Highlight>\n");
        this.textOS = new ByteArrayOutputStream();
        this.textWriter = new OutputStreamWriter((OutputStream)this.textOS, "UTF-16");
        this.writeText(pdDocument, this.textWriter);
        this.highlighterOutput.write("</Highlight>\n</Body>\n</XML>");
        this.highlighterOutput.flush();
    }

    protected void endPage(PDPage pdPage) throws IOException {
        this.textWriter.flush();
        String page = new String(this.textOS.toByteArray(), "UTF-16");
        this.textOS.reset();
        if (page.indexOf("a") != -1) {
            page = page.replaceAll("a[0-9]{1,3}", ".");
        }
        for (int i = 0; i < this.searchedWords.length; ++i) {
            Pattern pattern = Pattern.compile(this.searchedWords[i], 2);
            Matcher matcher = pattern.matcher(page);
            while (matcher.find()) {
                int begin = matcher.start();
                int end = matcher.end();
                this.highlighterOutput.write("    <loc pg=" + (this.getCurrentPageNo() - 1) + " pos=" + (begin - 10) + " len=" + (end - begin + 20) + ">\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        PDFHighlighter xmlExtractor = new PDFHighlighter();
        PDDocument doc = null;
        try {
            if (args.length < 2) {
                PDFHighlighter.usage();
            }
            String[] highlightStrings = new String[args.length - 1];
            System.arraycopy(args, 1, highlightStrings, 0, highlightStrings.length);
            doc = PDDocument.load(args[0]);
            xmlExtractor.generateXMLHighlight(doc, highlightStrings, (Writer)new OutputStreamWriter(System.out));
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java " + (class$org$pdfbox$util$PDFHighlighter == null ? (class$org$pdfbox$util$PDFHighlighter = PDFHighlighter.class$("org.pdfbox.util.PDFHighlighter")) : class$org$pdfbox$util$PDFHighlighter).getName() + " <pdf file> word1 word2 word3 ...");
        System.exit(1);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public void setHighlightColor(String color) {
        this.highlightColor = Color.decode(color);
    }

    public String getHighlightColorAsString() {
        String red = Integer.toHexString(this.highlightColor.getRed());
        String green = Integer.toHexString(this.highlightColor.getGreen());
        String blue = Integer.toHexString(this.highlightColor.getBlue());
        return (red.length() < 2 ? "0" + red : red) + (green.length() < 2 ? "0" + green : green) + (blue.length() < 2 ? "0" + blue : blue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

