/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.ttf.NameRecord;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;
import org.pdfbox.ttf.TrueTypeFont;

public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List nameRecords = new ArrayList();

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        NameRecord nr;
        int i;
        int formatSelector = data.readUnsignedShort();
        int numberOfNameRecords = data.readUnsignedShort();
        int offsetToStartOfStringStorage = data.readUnsignedShort();
        for (i = 0; i < numberOfNameRecords; ++i) {
            nr = new NameRecord();
            nr.initData(ttf, data);
            this.nameRecords.add(nr);
        }
        for (i = 0; i < numberOfNameRecords; ++i) {
            nr = (NameRecord)this.nameRecords.get(i);
            data.seek(this.getOffset() + 6L + (long)(numberOfNameRecords * 2 * 6) + (long)nr.getStringOffset());
            int platform = nr.getPlatformId();
            int encoding = nr.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && encoding == 1) {
                charset = "UTF-16";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "ISO-10646-1";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String string = data.readString(nr.getStringLength(), charset);
            nr.setString(string);
        }
    }

    public List getNameRecords() {
        return this.nameRecords;
    }
}

