/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDJpeg
extends PDXObjectImage {
    private static final List DCT_FILTERS = new ArrayList();

    public PDJpeg(PDStream jpeg) {
        super(jpeg, "jpg");
    }

    public PDJpeg(PDDocument doc, InputStream is) throws IOException {
        super(new PDStream(doc, is, true), "jpg");
        COSStream dic = this.getCOSStream();
        dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("XObject"));
        BufferedImage image = this.getRGBImage();
        this.setBitsPerComponent(8);
        this.setColorSpace(PDDeviceRGB.INSTANCE);
        this.setHeight(image.getHeight());
        this.setWidth(image.getWidth());
    }

    public BufferedImage getRGBImage() throws IOException {
        return ImageIO.read(this.getPDStream().getPartiallyFilteredStream(DCT_FILTERS));
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        InputStream data = this.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
        byte[] buf = new byte[1024];
        int amountRead = -1;
        while ((amountRead = data.read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
    }

    static {
        DCT_FILTERS.add(COSName.DCT_DECODE.getName());
        DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
    }
}

