/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import weka.gui.LogPanel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.AssociationsPanel;
import weka.gui.explorer.AttributeSelectionPanel;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.explorer.ClustererPanel;
import weka.gui.explorer.PreprocessPanel;
import weka.gui.visualize.MatrixPanel;

public class Explorer
extends JPanel {
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected ClassifierPanel m_ClassifierPanel = new ClassifierPanel();
    protected ClustererPanel m_ClustererPanel = new ClustererPanel();
    protected AssociationsPanel m_AssociationPanel = new AssociationsPanel();
    protected AttributeSelectionPanel m_AttributeSelectionPanel = new AttributeSelectionPanel();
    protected MatrixPanel m_VisualizePanel = new MatrixPanel();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    private static Explorer m_explorer;
    private static long m_initialJVMSize;

    public Explorer() {
        String string = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_LogPanel.logMessage("Weka Explorer");
        this.m_LogPanel.logMessage("(c) 1999-2004 The University of Waikato, Hamilton, New Zealand");
        this.m_LogPanel.logMessage("web: http://www.cs.waikato.ac.nz/~ml/");
        this.m_LogPanel.logMessage("Started on " + string);
        this.m_LogPanel.statusMessage("Welcome to the Weka Explorer");
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_ClassifierPanel.setLog(this.m_LogPanel);
        this.m_AssociationPanel.setLog(this.m_LogPanel);
        this.m_ClustererPanel.setLog(this.m_LogPanel);
        this.m_AttributeSelectionPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab("Preprocess", null, this.m_PreprocessPanel, "Open/Edit/Save instances");
        this.m_TabbedPane.addTab("Classify", null, this.m_ClassifierPanel, "Classify instances");
        this.m_TabbedPane.addTab("Cluster", null, this.m_ClustererPanel, "Identify instance clusters");
        this.m_TabbedPane.addTab("Associate", null, this.m_AssociationPanel, "Discover association rules");
        this.m_TabbedPane.addTab("Select attributes", null, this.m_AttributeSelectionPanel, "Determine relevance of attributes");
        this.m_TabbedPane.addTab("Visualize", null, this.m_VisualizePanel, "Explore the data");
        this.m_TabbedPane.setSelectedIndex(0);
        this.m_TabbedPane.setEnabledAt(1, false);
        this.m_TabbedPane.setEnabledAt(2, false);
        this.m_TabbedPane.setEnabledAt(3, false);
        this.m_TabbedPane.setEnabledAt(4, false);
        this.m_TabbedPane.setEnabledAt(5, false);
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Explorer.this.m_ClassifierPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AssociationPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_ClustererPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AttributeSelectionPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_VisualizePanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_TabbedPane.setEnabledAt(1, true);
                Explorer.this.m_TabbedPane.setEnabledAt(2, true);
                Explorer.this.m_TabbedPane.setEnabledAt(3, true);
                Explorer.this.m_TabbedPane.setEnabledAt(4, true);
                Explorer.this.m_TabbedPane.setEnabledAt(5, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            m_initialJVMSize = Runtime.getRuntime().totalMemory();
            m_explorer = new Explorer();
            final JFrame jFrame = new JFrame("Weka Explorer");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_explorer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
            jFrame.setIconImage(image);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile(new File(stringArray[0]));
            }
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() >= m_initialJVMSize + 200000L) continue;
                                jFrame.dispose();
                                m_explorer = null;
                                System.gc();
                                Thread[] threadArray = new Thread[Thread.activeCount()];
                                Thread.enumerate(threadArray);
                                for (int i = 0; i < threadArray.length; ++i) {
                                    Thread thread = threadArray[i];
                                    if (thread == null || thread == Thread.currentThread()) continue;
                                    if (thread.getName().startsWith("Thread")) {
                                        thread.stop();
                                        continue;
                                    }
                                    if (!thread.getName().startsWith("AWT-EventQueue")) continue;
                                    thread.stop();
                                }
                                threadArray = null;
                                JOptionPane.showMessageDialog(null, "Not enough memory. Please load a smaller dataset or use larger heap size.", "OutOfMemory", 2);
                                System.err.println("displayed message");
                                System.err.println("Not enough memory. Please load a smaller dataset or use larger heap size.");
                                System.err.println("exiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

